/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenCoverageViewAction.java,v 1.4 2005/08/10 02:24:23 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

import org.eclipse.hyades.trace.views.adapter.internal.CoverageStatisticViewer;

/**
 * Implements the "Open With -> Coverage" action (see the contextual
 * menu of the "Profiling monitor view")
 *  @author hind.hasnaoui@fr.ibm.com  --
 */
public class OpenCoverageViewAction extends OpenTraceViewAction {

	private final String VIEW_ID="org.eclipse.hyades.trace.views.adapter.internal.CoverageStatisticViewer";
		
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 */
	public OpenCoverageViewAction() {
		super("");
	}
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 */
	public OpenCoverageViewAction(String label) {
		super(label);
	}
	
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 * @param image org.eclipse.jface.resource.ImageDescriptor
	 */	
	public OpenCoverageViewAction(String label, ImageDescriptor image) {
		super(label, image);
	}

	/**
	 * 
	 */
	public boolean isVisibleForType(Object mofObject) {
		return true;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		IWorkbenchWindow window =
			UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			CoverageStatisticViewer view =
				(CoverageStatisticViewer) persp.showView(VIEW_ID);
			
			if(view != null){
				 view.addViewPage(getMofObject(), true);
			}

		} catch (Exception e) {
			String msg = TraceUIMessages._5;
			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "",
			// no special message
			err);

			e.printStackTrace();
		}

	}

	/*
	 * 
	 */
	public void run(IAction action) {
		run();
	}
	public String getViewID() {
		return VIEW_ID;
	}

}
