/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenExecutionStatisticViewAction.java,v 1.8 2008/05/29 02:13:47 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;

public class OpenExecutionStatisticViewAction extends OpenTraceViewAction {
	public OpenExecutionStatisticViewAction() {
		super("");
	}

	public OpenExecutionStatisticViewAction(String label) {
		super(label);
	}

	public OpenExecutionStatisticViewAction(String label, ImageDescriptor image) {
		super(label, image);
	}

	public boolean isVisibleForType(Object mofObject) {
		return true;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		IWorkbenchWindow window =
			UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			EObject eobject = getMofObject();
			if (eobject != null) eobject = getObjectToView(eobject); 
			
			IWorkbenchPage persp = UIPlugin.getActivePage();
			ExecutionStatisticViewer2 view =
				(ExecutionStatisticViewer2) persp.showView(ExecutionStatisticViewer2.VIEW_ID);
			
			if(view != null) {
				 ((ExecutionStatisticViewer2)view).showExecutionSummaryTab(eobject);
			}

		} catch (Exception e) {
			String msg =
				TraceUIMessages._3;
			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "",
			// no special message
			err);

			e.printStackTrace();
		}

	}

	public void run(IAction action) {
		run();
	}

	public String getViewID() {
		return ExecutionStatisticViewer2.VIEW_ID;
	}
}
