/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenMethodDetailsAction.java,v 1.7 2008/05/20 12:53:46 ialelekov Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenMethodDetailsAction extends OpenTraceViewAction {
	public OpenMethodDetailsAction() {
		super("");
	}

	public OpenMethodDetailsAction(String label) {
		super(label);
	}

	public OpenMethodDetailsAction(String label, ImageDescriptor image) {
		super(label, image);
	}

	public void run() {
		try	{
			ExecutionStatisticViewer2 view = ExecutionStatisticViewer2.getActiveViewer();
			if(view != null) view.showMethodDetailsTab();
		}
		catch(Exception e) {
			Status err = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, e.toString(), null ); 

			IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
			ErrorDialog.openError(window.getShell(),
				TraceUIMessages._100,
				"", // no special message
				err);
		
			e.printStackTrace();    
		}                               
	}

	public void run(IAction action) {
		run();
	}
	
	public String getViewID() {
		return ExecutionStatisticViewer2.VIEW_ID;
	}
}
