/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenMethodInvocationAction.java,v 1.7 2008/05/20 12:53:46 ialelekov Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenMethodInvocationAction extends OpenTraceViewAction {
	public OpenMethodInvocationAction() {
		super("");
	}

	public OpenMethodInvocationAction(String label) {
		super(label);
	}

	public OpenMethodInvocationAction(String label, ImageDescriptor image) {
		super(label, image);
	}

	public void run() {
		IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
			
		try	{
			ExecutionStatisticViewer2 view = ExecutionStatisticViewer2.getActiveViewer();
			if(view != null) view.showMethodInvocationTab();
		}
		catch(Exception e) {
			String msg = TraceUIMessages._100;                 

			Status err = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, e.toString(), null ); 

			ErrorDialog.openError(window.getShell(),
				msg,
				"", // no special message
				err);
		
			e.printStackTrace();    
		}                               
    }

	public void run(IAction action) {
		run();
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

	public String getViewID() {
		return ExecutionStatisticViewer2.VIEW_ID;
	}
}
