/**********************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenPatternViewAction.java,v 1.6 2006/01/20 20:22:03 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import java.util.Iterator;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.PatternViewer;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
*
*/
public class OpenPatternViewAction extends OpenTraceViewAction
{
	
	private final String VIEW_ID="org.eclipse.hyades.trace.views.adapter.internal.PatternViewer";
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenPatternViewAction() {
	super("");
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenPatternViewAction(String label) {
	super(label);
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 * @param image org.eclipse.jface.resource.ImageDescriptor
 */
public OpenPatternViewAction(String label, ImageDescriptor image) {
	super(label, image);
}

/**
 * Insert the method's description here.
 * Creation date: (12/4/2000 2:21:48 PM)
 * @return boolean
 */ 
public void run()
{
	IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
			
	try
	{
		IWorkbenchPage persp = UIPlugin.getActivePage();
		PatternViewer view = (PatternViewer)persp.showView(VIEW_ID);
		   
		if(view != null)
			 view.addViewPage(getMofObject(), true);                       
	}
	catch(Exception e)
	{
		Status err = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, TraceUIMessages._1, null );  

		ErrorDialog.openError(window.getShell(),
				TraceUIMessages._1,
				e.toString(),   // no special message
				err); 
		
		e.printStackTrace(); 
	}                               	
}


/*
 * 
 */
public void run(IAction action)
{
	run();
}
public String getViewID() {
	return VIEW_ID;
}

private boolean isEnabledForObj(TRCAgentProxy obj){
	TRCCollectionMode tcm = obj.getCollectionMode();
	//please refer to PDCoreUtil.java (comments and a chart around line 1140)
	if (tcm.getValue() == TRCCollectionMode.HEAP_AND_EXECUTION_FULL) {
		return true;
	} else if (tcm.getValue() == TRCCollectionMode.EXECUTION_NO_INSTANCES) {
		return true;
	} else if (tcm.getValue() == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES) {
		return true;
	} else if (tcm.getValue() == TRCCollectionMode.EXECUTION_FULL) {
		return true;
	}
	return false;
}
private boolean isEnabledForObj(TRCProcessProxy obj){
	EList el = obj.getAgentProxies();
	for (Iterator iter = el.iterator(); iter.hasNext();) {
		TRCAgentProxy element = (TRCAgentProxy) iter.next();
		if (isEnabledForObj(element)) {
			return true;
		}
	}
	return false;
}
private boolean isEnabledForObj(TRCNode obj){
	EList el = obj.getProcessProxies();
	for (Iterator iter = el.iterator(); iter.hasNext();) {
		TRCProcessProxy element = (TRCProcessProxy) iter.next();
		if (isEnabledForObj(element)) {
			return true;
		}
	}
	return false;
}
private boolean isEnabledForObj(TRCMonitor obj){
	EList el = obj.getNodes();
	for (Iterator iter = el.iterator(); iter.hasNext();) {
		TRCNode element = (TRCNode) iter.next();
		if (isEnabledForObj(element)) {
			return true;
		}
	}
	return false;
}

public boolean isEnabledForObject(Object obj)
{
	EObject eo = getMofObject();
	if (eo instanceof TRCAgentProxy) {
		return isEnabledForObj((TRCAgentProxy)eo);
	} else if (eo instanceof TRCProcessProxy) {
		return isEnabledForObj((TRCProcessProxy)eo);
	} else if (eo instanceof TRCNode) {
		return isEnabledForObj((TRCNode)eo);
	} else if (eo instanceof TRCMonitor) {
		return isEnabledForObj((TRCMonitor)eo);
	}
	return true;
}
}

