/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenReferencePatternViewAction.java,v 1.4 2005/08/10 02:24:23 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.ReferenceTableViewer;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
*
*/
public class OpenReferencePatternViewAction extends OpenTraceViewAction											
{
	private final String VIEW_ID="org.eclipse.hyades.trace.views.adapter.internal.ReferenceTableViewer";
/**
 * Insert the method's description here.
 * Creation date: (12/4/2000 2:21:48 PM)
 * @return boolean
 */
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenReferencePatternViewAction() {
	super("");
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenReferencePatternViewAction(String label) {
	super(label);
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 * @param image org.eclipse.jface.resource.ImageDescriptor
 */
public OpenReferencePatternViewAction(String label, ImageDescriptor image) {
	super(label, image);
}

/**
 *
 */   
public void run()
{
	IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
			
	try
	{
		IWorkbenchPage persp = UIPlugin.getActivePage();     
		ReferenceTableViewer view = (ReferenceTableViewer)persp.showView(VIEW_ID);
			
		if(view != null)
			 view.addViewPage(getMofObject(), true);                       
	}
	catch(Exception e)
	{
		String msg = TraceUIMessages._2;     
		Status err = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, msg, null );  

		ErrorDialog.openError(window.getShell(),
				msg,
				e.toString(),   // no special message
				err);           
	}                               
}


/*
 * 
 */
public void run(IAction action)
{
	run();
}
public String getViewID() {
	return VIEW_ID;
}

}

