/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenSourceAction.java,v 1.3 2007/05/31 04:48:17 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 * Insert the type's description here.
 * Creation date: (09/28/2000 12:00:37 PM)
 * @author: Administrator
 */
public class OpenSourceAction extends Action
					implements IWorkbenchWindowActionDelegate, IViewActionDelegate 
					//extends OpenTraceViewAction
{
	protected ISelection _selection;
	
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenSourceAction() {
	super("");
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenSourceAction(String label) {
	super(label);
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 * @param image org.eclipse.jface.resource.ImageDescriptor
 */
public OpenSourceAction(String label, ImageDescriptor image) {
	super(label, image);
}

/**
 * 
 */   
public void run()
{
	/* Create an eclipse job to handle the opening... */
	new Job( TraceUIMessages._269 ) {
		public IStatus run(IProgressMonitor monitor) {

				Object sel = null;
				
				if ( _selection != null && !_selection.isEmpty() ) {
					sel = ((IStructuredSelection)_selection).getFirstElement();
					
					if ( sel instanceof IEObjectSelection ) {
						EObject eObject = ((IEObjectSelection) sel).getEObject();
						
						if (eObject instanceof TRCMethodInvocation || 
								eObject instanceof TRCMethod ||
								eObject instanceof TRCClass ||
								eObject instanceof TRCObject) {
							sel = eObject;
						}			
					}	
				}
				
				OpenSource.openSource(sel);
				
				return Status.OK_STATUS;				
			}		
	}.schedule();
	

}

public void selectionChanged(IAction action, ISelection selection) {
	
	this._selection = selection;
}

/*
 * 
 */
public void run(IAction action)
{
	run();
}

public void dispose()
{
	//super.dispose();
	
	_selection = null;
	
}

public void init(IWorkbenchWindow window) {}
public void init(IViewPart view) {}

}
