/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenTraceViewAction.java,v 1.3 2008/05/29 02:13:47 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.actions.OpenAssociatedTraceViewAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 * @author popescu
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class OpenTraceViewAction extends OpenAssociatedTraceViewAction
										  implements IWorkbenchWindowActionDelegate, IViewActionDelegate
{
	/**
	 * @param label
	 */
	public OpenTraceViewAction(String label) {
		super(label);
	}

	/**
	 * @param label
	 * @param image
	 */
	public OpenTraceViewAction(String label, ImageDescriptor image) {
		super(label, image);
	}

	public EObject getMofObject() {
		return HyadesUtil.getMofObject();  
	}

	public EObject getObjectToView(EObject selObject) {
		return TraceViewer.getObjectToView_(selObject);
	}
	
	public void selectionChanged(IAction action, ISelection selection) {}

	public void init(IWorkbenchWindow window) {}
	
	/**
	 * Initializes this action delegate with the view it will work in.
	 *
	 * @param view the view that provides the context for this delegate
	 */
	public void init(IViewPart view){}

	public void dispose() {}
}
