/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ActiveFilter.java,v 1.1 2006/09/21 19:19:30 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;

public abstract class ActiveFilter {
	private HashSet oneNameSet;

	private final String enabledKey;
	private final String disabledKey;
	
	public ActiveFilter(final String enabledKey, final String disabledKey) {
		this.enabledKey = enabledKey;
		this.disabledKey = disabledKey;
	}
	
	public String getEnabledKey() {
		return enabledKey;
	}
	
	public String getDisabledKey() {
		return disabledKey;
	}
	
	public abstract WhereExpression createDisabledExpression();
	public abstract WhereExpression createActiveExpression();
	
	public static boolean isFilterEnabled(final ActiveFilter filter,
			final SimpleSearchQuery query) {
		return filter.containsNamedSubexpression(query, filter.getEnabledKey());
	}
	
	public static boolean isFilterDisabled(final ActiveFilter filter,
			final SimpleSearchQuery query) {
		return filter.containsNamedSubexpression(query, filter.getDisabledKey());
	}

	protected WhereExpression getNamedSubexpression(final WhereExpression we, final String name) {
		return getNamedSubexpression(we, createSet(name));
	}
	
	protected static WhereExpression getNamedSubexpression(final WhereExpression we, final Set names) {
		if (names.contains(we.getName())) {
			return we;
		}
		if (we instanceof LogicalExpression) {
			LogicalExpression le = (LogicalExpression) we;
			EList subExpsessions = le.getArguments();
			for (int i = 0; i < subExpsessions.size(); i++) {
				 WhereExpression subExpression = (WhereExpression) subExpsessions.get(i);
				 WhereExpression keyNamedSubexpression = getNamedSubexpression(subExpression, names);
				 if (keyNamedSubexpression != null) {
					 return keyNamedSubexpression;
				 }
			 }
		}

		return null;
	}

	private Set createSet(final String element) {
		if (oneNameSet == null) {
			oneNameSet = new HashSet(1);
		} else {
			oneNameSet.clear();
		}
		oneNameSet.add(element);
		return oneNameSet;
	}

	private boolean containsNamedSubexpression(final SimpleSearchQuery query, final String name) {
		if (name.equals(query.getName())) {
			return true;
		}
		WhereExpression whereExpression = query.getWhereExpression();
		if (whereExpression == null) {
			return false;
		}
		WhereExpression subexpression = getNamedSubexpression(whereExpression, name);
		return (subexpression != null);
	}
}
