/**********************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AggregatedExecutionStatisticsTab.java,v 1.7 2008/04/17 07:49:33 aalexeev Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.internal.AggregatedExecutionDetailsView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AggregatedExecutionStatisticsTab extends ExecutionStatisticTabItem {

	protected AggregatedExecutionDetailsView _view;

	private static final String _title = TraceUIPlugin.getString("60");

    protected AggregatedExecutionStatisticsTab(ExecutionStatisticPage2 page) {
		super(page);
	}

	public void createControl(Composite parent) {
		_view = new AggregatedExecutionDetailsView(parent, this);
		_view.initialize();

		_page.setContextMenu(_view.getAggregatedExecutionStatistic().getTree(),
                       _view.getAggregatedExecutionStatistic().getTreeViewer());
		_page.setContextMenu(_view.getAggregatedCallStack().getTree(),
		               _view.getAggregatedCallStack().getTreeViewer());
	}

	public void fillContextMenu(IMenuManager menu) {
		if (_view != null) {
			_view.menuAboutToShow(menu);
		}
	}

	public Control getControl() {
		return (_view != null) ? _view.getControl() : null;
	}

	public AggregatedExecutionDetailsView getView() {
		return _view;
	}

	public MultiLevelStatisticView getStatisticView() {
		return (_view != null) ? _view.getAggregatedExecutionStatistic() : null;
	}

	public String getViewTitle() {
		return _title;
	}

	public boolean isEmpty() {
		return !PerftraceUtil.hasFullMethodInvocationInfo(_page.getMOFObject());
	}

	public void refresh() {
		if (_view != null)
			_view.refresh();
	}

	public void selectionChanged() {
		if (_view != null)
			_view.selectionChanged();

	}

	public void setFocus() {
		if (_view != null) {
			_view.getControl().setFocus();
		}
	}

	public void update(boolean newPage) {
		if (_view != null) {
			_view.update();
        }
	}
	
	public void dispose() {
		super.dispose();
		if (_view != null) {
			_view.dispose();
			_view = null;
		}
	}

	public void updateCallStacks() {
		if (_view.getAggregatedExecutionStatistic().getTree().isFocusControl()) {
            _view.getAggregatedCallStack().updateCallStackInfoProvider();          
        } else if (_view.getAggregatedCallStack().getTree().isFocusControl()) {
            _view.getAggregatedExecutionStatistic().expandToSelectedElement(false);            
        }
	}

    public void expandToSelectedElement() {
        _view.expandToSelectedElement();
    }

	public Object[] getViewerControls() {
		return new Object[] { 
				_view.getAggregatedExecutionStatistic().getTree(),
				_view.getAggregatedCallStack().getTree()
				};
	}
    
	public void tabItemSelected() {
		expandToSelectedElement();
	}

	public boolean isFilteringEnabled() {
		return false;
	}

	protected void handleHidden() {
		StatisticView v = _view.getAggregatedCallStack(); 
		if(v != null)
			v.setHidden();
		
		v = _view.getAggregatedExecutionStatistic();
		if(v != null)
			v.setHidden();
	}

	protected void handleVisible() {
		StatisticView v = _view.getAggregatedCallStack(); 
		if(v != null)
			v.setVisible();
		
		v = _view.getAggregatedExecutionStatistic();
		if(v != null)
			v.setVisible();
	}
}
