/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CoverageStatisticViewer.java,v 1.4 2008/07/21 18:49:43 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.trace.views.internal.*;


public class CoverageStatisticViewer extends MultiLevelStatisticMethodViewer {

	protected static final String _title =
		TraceUIPlugin.getString("1");

	public CoverageStatisticViewer() {
		super();
	}

	/**
	 * create a coverage page
	 */
	public TraceViewerPage createPage(EObject mofObject) {
		if(_fi != null)
			_fi.restore();
		return new CoverageStatisticPage(mofObject, this);
	}

	/**
	 * return the view title
	 */
	public String getViewTitle() {
		return _title;
	}
	
	public String getDefaultPageMessage() {
		return TraceMessages._25;
	}
}
