/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DynamicFilter.java,v 1.2 2006/10/31 18:54:53 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;

public abstract class DynamicFilter extends ActiveFilter {
	protected static final Map REGISTERED_FILTERS = new HashMap();
	
	public DynamicFilter(final String enabledKey, final String disabledKey) {
		super(enabledKey, disabledKey);
		register(this);
	}
	
	public abstract SimpleSearchQuery update(final SimpleSearchQuery filter, final EObject object);
	
	public static boolean containsDynamicFilters(final SimpleSearchQuery filter) {
		if (filter == null) {
			return false;
		}
		WhereExpression whereExpression = filter.getWhereExpression();
		if (whereExpression == null) {
			return false;
		}
		WhereExpression subexpression = getNamedSubexpression(whereExpression, REGISTERED_FILTERS.keySet());
		return (subexpression != null);
	}

	public static SimpleSearchQuery updateDynamicFilters(final SimpleSearchQuery filter, final EObject object) {
		if (filter == null) {
			return null;
		}
		WhereExpression whereExpression = filter.getWhereExpression();
		if (whereExpression == null) {
			return filter;
		}
		return updateDynamicFilters(filter, whereExpression, object);
	}

	private static SimpleSearchQuery updateDynamicFilters(final SimpleSearchQuery query, final WhereExpression we, final EObject object) {
		SimpleSearchQuery result = query;
		Object filter = REGISTERED_FILTERS.get(we.getName());
		if (filter != null) {
			result = ((DynamicFilter) filter).update(result, object);
		}
		if (we instanceof LogicalExpression) {
			LogicalExpression le = (LogicalExpression) we;
			EList subExpsessions = le.getArguments();
			 for (int i = 0; i < subExpsessions.size(); i++) {
				 WhereExpression subExpression = (WhereExpression) subExpsessions.get(i);
				 result = updateDynamicFilters(result, subExpression, object);
			 }
		}
		return result;
	}
	
	private static void register(final DynamicFilter filter) {
		REGISTERED_FILTERS.put(filter.getEnabledKey(), filter);
	}
}
