/**********************************************************************
 * Copyright (c) 2006,2008 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionStatisticTab.java,v 1.9 2008/04/17 07:49:33 aalexeev Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.views.internal.ExecutionStatisticView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.filters.internal.actions.FiltersEditorAction;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.ui.forms.IFormColors;
import org.eclipse.ui.forms.widgets.Form;

public class ExecutionStatisticTab extends ExecutionStatisticTabItem {
	protected static final String _title = TraceUIPlugin.getString("2");
	
	protected MultiLevelStatisticView _view;
	protected HyadesFormToolkit _toolkit;
	protected Form _form;
	protected Link _info;

    public ExecutionStatisticTab(ExecutionStatisticPage2 page) {
		super(page);
	}
	
	public void createControl(Composite parent) {
    	_toolkit = new HyadesFormToolkit(parent.getDisplay());
    	_form = _toolkit.createForm(parent);
    	_form.setText(_title);
    	GridLayout gridLayout = new GridLayout();
    	gridLayout.marginLeft = gridLayout.marginRight = 0;
    	gridLayout.marginTop = gridLayout.marginBottom = 0;
    	_form.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
    	_form.getBody().setLayout(gridLayout);
    	_form.getBody().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
    	_info = new Link(_form.getBody(), SWT.WRAP | _toolkit.getOrientation());
    	_info.setBackground(_toolkit.getColors().getBackground());
    	_info.setForeground(_toolkit.getColors().getColor(IFormColors.TITLE));
    	Font font = _info.getFont();
    	FontData fd = font.getFontData()[0];
    	font = new Font(null, new FontData(fd.getName(), fd.getHeight(), fd.getStyle() | SWT.BOLD));
    	_info.setFont(font);
    	_info.addSelectionListener(new SelectionListener() {
    		public void widgetDefaultSelected(SelectionEvent e) {}
    	
    		public void widgetSelected(SelectionEvent e) {
    			if (_page != null && _page.getViewer() != null) {
    				FiltersEditorAction feAction = new FiltersEditorAction(_page.getViewer().getFilterInformationManager(), true);
    				feAction.run();
    			}
    		}
    	});
    	_info.setLayoutData(GridUtil.createHorizontalFill());
    	
		_view = new ExecutionStatisticView(_form.getBody(), _page);

		_page.setContextMenu(_view.getTree(), _view.getTreeViewer());
		_view.getControl().setFocus();
	}	

	public Control getControl() {
		return _form;
	}
	
	public void refresh() {
		if (_view != null) {
			_view.updateButtons();
			_view.refresh();
			_info.setText(NLS.bind(CommonUITraceMessages.CHOOSE_FILTER_MSG, getCurrentFilterName()));
		}
	}	

	public void setFocus() {
		if (_view != null) {
			_view.getControl().setFocus();
			_view.showNewSelection();
		}
	}	

	public void selectionChanged() {
		if (_view != null) {
			_view.selectionChanged();
		}
	}	

	public void fillContextMenu(IMenuManager menu) {
		if (_view != null) {
			_view.menuAboutToShow(menu);
		}
	}

	public void dispose() {
		if (_view != null) {
			_view.dispose();
			_view = null;
		}

		if (_toolkit != null) {
			_toolkit.dispose();
			_toolkit = null;
		}
		if (_form != null) {
			_form.dispose();
			_form = null;
		}

		_page = null;
	}

	public MultiLevelStatisticView getView() {
		return _view;
	}

	public MultiLevelStatisticView getStatisticView() {
		return _view;
	}

	public void update(boolean newPage) {
		if (_view != null) {
			_view.update();
			_info.setText(NLS.bind(CommonUITraceMessages.CHOOSE_FILTER_MSG, getCurrentFilterName()));
		}
	}

	public String getCurrentFilterName() {
		String filterName;

		SimpleSearchQuery filter = _page.getViewer().getCurrentFilter();
		if (filter != null)
			filterName = filter.getName();
		else
			filterName = CommonUITraceMessages.ST_FLTAPN;
		
		return filterName;
	}

	public String getViewTitle() {
		return _title;
	}
	
	public void setCheckedLevels(int newLevel) {
		_view.setLevel(newLevel);
		_view.updateButtons();
		_view.redrawTable();
	}

	public void runShowPercentAction() {
		if (_view != null) {
			_view.getShowPercentAction().run();
		}
	}

	public void runDeltaColumnsAction() {
		if (_view != null) {
			_view.getDeltaColumnsAction().run();
		}
	}

	public boolean isFilteringEnabled() {
		return true;
	}
	
    public IAction[] getSupportedActions() {
        ExecutionStatisticViewer2 viewer = _page.getViewer();
        return new IAction[] {
        		viewer.getReportAction(),
        		viewer.getFiltersAction(),
                viewer._packageLevel,
                viewer._classLevel,
                viewer._methodLevel,
                viewer._instanceLevel,
                viewer._openSource,
                viewer._percentMode,
                viewer._deltaColumns
        };
    }

	public Object[] getViewerControls() {
		return new Object[] { _view.getTree() };
	}

	protected void handleHidden() {
		if(_view != null)
			_view.setHidden();
	}

	protected void handleVisible() {
		if(_view != null)
			_view.setVisible();
	}
}
