/**********************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionStatisticTabItem.java,v 1.5 2008/04/17 07:49:33 aalexeev Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ExecutionStatisticTabItem {

	protected ExecutionStatisticPage2 _page;
	
	protected ExecutionStatisticTabItem(ExecutionStatisticPage2 page) {
		_page = page;
	}
	
	public ExecutionStatisticPage2 getPage() {
		return _page;
	}
	
	public IContextViewer getContextViewer() {
		if (_page != null && _page.getTraceViewer() instanceof IContextViewer) {
			return (IContextViewer)_page.getTraceViewer();
		}
		return null;
	}
	
	public void dispose() {
		_page = null;
	}
	
	public EObject getMOFObject() {
		return (_page != null) ? _page.getMOFObject() : null;
	}
	
	public abstract void createControl(Composite parent);
	
	public abstract Control getControl();
	
	public abstract void refresh();
	
	public abstract void setFocus();

	public abstract void selectionChanged();

	public abstract void fillContextMenu(IMenuManager menu);
	
	public abstract void update(boolean newPage);

	public abstract String getViewTitle();

	public void setCheckedLevels(int newLevel) {
	}

	public void runShowPercentAction() {
	}

	public void runDeltaColumnsAction() {
	}

	public void runPreviousAction() {		
	}

	public void runNextAction() {
	}

	public void runZoomOutAction() {
	}

	public void runZoomInAction() {
	}

	public void runStdSelectAction() {
	}

	public void runShowCalleeAction() {
	}

	public void runHomeAction() {
	}

	public void runShowCallerAction() {
	}
	
    public void expandToSelectedElement() {        
    }
    
	public IAction[] getSupportedActions() {
        ExecutionStatisticViewer2 viewer = _page.getViewer();
        return new IAction[] {
        		viewer.getReportAction(),
                viewer._openSource
        	};
	}

	public Object[] getViewerControls() {
		return null;
	}
	
	public boolean isFilteringEnabled() {
		return false;
	}
	
	public void tabItemSelected() {
	}

	public boolean isEmpty() {
		return false;
	}

	public MultiLevelStatisticView getStatisticView() {
		return null;
	}

	public boolean isTimeMenuEnabled() {
		return false;
	}
	
	final void setVisible(){
		handleVisible();
	}

	final void setHidden(){
		handleHidden();
	}

	protected void handleVisible(){
	}

	protected void handleHidden(){
	}

}
