/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionStatisticViewer2.java,v 1.23 2010/06/30 20:45:50 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.ExecutionStatisticView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;

public class ExecutionStatisticViewer2 extends MultiLevelStatisticMethodViewer implements IPartListener {
	public static final String VIEW_ID="org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2";
	public static final String RUNTIME_ID = "RUNTIME_ID";
	
	private static ExecutionStatisticViewer2 activeViewer;
	
	protected Action _percentMode;
	protected Action _deltaColumns;	
    protected Action _next;
    protected Action _previous;
    protected Action _update;
    protected Action _caller;
    protected Action _callee;
    protected Action _showRawTime;
    protected Action _zoomInAction;
    protected Action _zoomOutAction;
    protected Action _stdSelectAction;
    protected Action _showCompensatedTime;
    protected Action _openColorDialog;
	
	protected Action _instanceLevel;
	
	protected IContributionItem[] _toolbarItems;
	protected IMenuManager _timeMenu;
    
	protected static final String _title = TraceUIPlugin.getString("2");    

	public ExecutionStatisticViewer2() {
		super();
	}

	/**
	 * create a coverage page
	 */
	public TraceViewerPage createPage(EObject mofObject) {
		if(_fi != null)
			_fi.restore();
		return new ExecutionStatisticPage2(mofObject, this);
	}

	/**
	 * return the view title
	 */
	public String getViewTitle() {
		return _title;
	}
	
	protected void getLevelActions(Vector actions)
	{
		super.getLevelActions(actions);

		_instanceLevel = new Action(IContextAttributes.SHOW_INSTANCE_LEVEL) {
			public void run() {
				MultiLevelStatisticPage page = (MultiLevelStatisticPage) getCurrentPage();

				if(page == null)
				{
				  revertChecked(_instanceLevel);
				  return;
				}

				setCheckedLevels(page, ExecutionStatisticView.INSTANCE_LEVEL);

			}
			public int getStyle() {
				return IAction.AS_CHECK_BOX;
			}
		};
		_instanceLevel.setEnabled(true);

		actions.addElement(new Separator());
		actions.addElement(_instanceLevel);		
	}
	
    private void getMultiLevelActions(Vector actions) {
        createPercentModeAction();

        String strShowDelta = TraceUIMessages._84;  
        _deltaColumns = new Action(strShowDelta)
        {
            public void run()
            {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)getCurrentPage();

                if(page == null)
                {
                  revertChecked(_deltaColumns);
                  return;
                }

                page.runDeltaColumnsAction();      
            }
            
            public int getStyle() { return IAction.AS_CHECK_BOX; }
            
        
        };

        _deltaColumns.setText(strShowDelta);
        TracePluginImages.setImageDescriptors(_deltaColumns,TracePluginImages.T_LCL,TracePluginImages.IMG_DELTACOLUMNS);
        _deltaColumns.setDescription(strShowDelta);   
        _deltaColumns.setToolTipText(strShowDelta);
        _deltaColumns.setEnabled(true);
        
        int actionSize = actions.size();
        
        super.getActions(actions);
        
        if ((actionSize+1)< actions.size())
        {
            actions.insertElementAt(_percentMode, actionSize+2);
            actions.insertElementAt(_deltaColumns, actionSize+3);
        }
        else
        {
            actions.addElement(_percentMode);
            actions.addElement(_deltaColumns);
        }
    }
    
    private void getSinglePatternActions(Vector actions) {
        String compTime = TraceUIMessages._112;
        _showCompensatedTime = new Action(compTime) {
            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue(
                        TraceConstants.TIME_OPTION,
                        TraceConstants.COMPENSATED_TIME);

                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();

            }
        };
        _showCompensatedTime.setText(compTime);
        _showCompensatedTime.setDescription(compTime);
        _showCompensatedTime.setToolTipText(compTime);
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt(
                TraceConstants.TIME_OPTION);
        _showCompensatedTime.setChecked(ref == TraceConstants.COMPENSATED_TIME);

        String rawTime = TraceUIMessages._111;
        _showRawTime = new Action(rawTime) {
            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue(
                        TraceConstants.TIME_OPTION, TraceConstants.RAW_TIME);

                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();

            }
        };
        _showRawTime.setText(rawTime);
        _showRawTime.setDescription(rawTime);
        _showRawTime.setToolTipText(rawTime);
        ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt(
                TraceConstants.TIME_OPTION);
        _showRawTime.setChecked(ref == TraceConstants.RAW_TIME);

        String strPrev = TraceUIMessages._9;
        _previous = new Action(strPrev) {
            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();

                if (page == null)
                    return;

                page.runPreviousAction();
            }
        };
        _previous.setText(strPrev);
        TracePluginImages.setImageDescriptors(_previous,
                TracePluginImages.T_LCL, TracePluginImages.IMG_PREV);
        _previous.setDescription(strPrev);
        _previous.setToolTipText(TraceUIMessages._11);

        String strNext = TraceUIMessages._10;
        _next = new Action(strNext) {
            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();

                if (page == null)
                    return;

                page.runNextAction();
            }
        };
        _next.setText(strNext);
        TracePluginImages.setImageDescriptors(_next, TracePluginImages.T_LCL,
                TracePluginImages.IMG_NEXT);
        _next.setDescription(strNext);
        _next.setToolTipText(TraceUIMessages._12);

        String strHome = TraceUIMessages._73;
        _update = new Action(strHome) {
            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();

                if (page == null)
                    return;

                page.runHomeAction();
            }
            public int getStyle() {
                return IAction.AS_CHECK_BOX;
            }
        };
        _update.setText(strHome);
        TracePluginImages.setImageDescriptors(_update,
                TracePluginImages.T_TOOL, TracePluginImages.IMG_HOME);
        _update.setDescription(strHome);
        _update.setToolTipText(strHome);

        String strStdSelect = TraceUIMessages._117;
        _stdSelectAction = new Action(strStdSelect) {
            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();

                if (page == null)
                    return;

                page.runStdSelectAction();
            }

            public int getStyle() {
                return IAction.AS_CHECK_BOX;
            }

        };

        _stdSelectAction.setText(strStdSelect);
        TracePluginImages.setImageDescriptors(_stdSelectAction,
                TracePluginImages.T_LCL, TracePluginImages.IMG_RESTORE_ORG);
        _stdSelectAction.setDescription(strStdSelect);
        _stdSelectAction.setToolTipText(strStdSelect);

        String strZoomIn = TraceUIMessages._7;
        _zoomInAction = new Action(strZoomIn) {
            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();

                if (page == null)
                    return;

                page.runZoomInAction();
            }

            public int getStyle() {
                return IAction.AS_CHECK_BOX;
            }

        };

        _zoomInAction.setText(strZoomIn);
        TracePluginImages.setImageDescriptors(_zoomInAction,
                TracePluginImages.T_LCL, TracePluginImages.IMG_ZOOMIN);
        _zoomInAction.setDescription(strZoomIn);
        _zoomInAction.setToolTipText(strZoomIn);

        String strZoomOut = TraceUIMessages._8;
        _zoomOutAction = new Action(strZoomOut) {
            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();

                if (page == null)
                    return;

                page.runZoomOutAction();
            }

            public int getStyle() {
                return IAction.AS_CHECK_BOX;
            }

        };

        _zoomOutAction.setText(strZoomOut);
        TracePluginImages.setImageDescriptors(_zoomOutAction,
                TracePluginImages.T_LCL, TracePluginImages.IMG_ZOOMOUT);
        _zoomOutAction.setDescription(strZoomOut);
        _zoomOutAction.setToolTipText(strZoomOut);

        String strCaller = TraceUIMessages._71;
        _caller = new Action(strCaller) {
            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();

                if (page == null)
                    return;

                page.runShowCallerAction();
            }
        };

        _caller.setText(strCaller);
        TracePluginImages.setImageDescriptors(_caller, TracePluginImages.T_LCL,
                TracePluginImages.IMG_CALLER);
        _caller.setDescription(strCaller);
        _caller.setToolTipText(strCaller);

        String strCalee = TraceUIMessages._72;
        _callee = new Action(strCalee) {
            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();

                if (page == null)
                    return;

                page.runShowCalleeAction();
            }
        };

        _callee.setText(strCalee);
        TracePluginImages.setImageDescriptors(_callee, TracePluginImages.T_LCL,
                TracePluginImages.IMG_CALLEE);
        _callee.setDescription(strCalee);
        _callee.setToolTipText(strCalee);

        _openColorDialog = new Action(TraceUIMessages._99) {
            public void run() {
                GraphColorDialog dialog = new GraphColorDialog(getViewSite()
                        .getShell(), TraceUIMessages._97, null);
                dialog.open();
            }
        };

        _openColorDialog.setText(TraceUIMessages._99);
        TracePluginImages.setImageDescriptors(_openColorDialog,
                TracePluginImages.T_TOOL, TracePluginImages.IMG_COLORS);
        _openColorDialog.setDescription(TraceUIMessages._99);
        _openColorDialog.setToolTipText(TraceUIMessages._99);

        createPercentModeAction();

        actions.add(new Separator());
        actions.add(_caller);
        actions.add(_callee);
        actions.add(new Separator());
        actions.add(_previous);
        actions.add(_next);
        actions.add(new Separator());
        actions.add(_stdSelectAction);
        actions.add(_zoomInAction);
        actions.add(_zoomOutAction);
        actions.add(new Separator());
        actions.add(_update);
        actions.add(new Separator());
        actions.add(_openColorDialog);

        IMenuManager menu = getViewSite().getActionBars().getMenuManager();
        _timeMenu = new MenuManager(TraceUIMessages._113);
        menu.add(_timeMenu);

        _timeMenu.add(_showCompensatedTime);
        _timeMenu.add(_showRawTime);
    }

    public void getActions(Vector actions) {
        getMultiLevelActions(actions);
        getSinglePatternActions(actions);
    }
    
    public void makeActions() {
		if (isInitializedMenu())
			return; //create the toolbar only once

    	super.makeActions();
    	
		IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();
    	_toolbarItems = tbm.getItems();
    }
    
	public Action percentMode() {
		return _percentMode;
	}

	public Action deltaColumns() {
		return _deltaColumns;
	}	
	
	public Action getInstanceLevel() {
		return _instanceLevel;
	}		
	
	protected void setActionsNull()
	{
		super.setActionsNull();
		_instanceLevel = null;
	}

	public void updateContext()
	{
		super.updateContext();
		setActionProperties(_instanceLevel, _context, IContextAttributes.SHOW_INSTANCE_LEVEL);
	}	

	public void setCheckedLevels(MultiLevelStatisticPage page, int newLevel)
	{
		((ExecutionStatisticPage2) page).setCheckedLevels(newLevel);
	}

    public Object[] getViewerControls()
    {
    	if(getCurrentPage() instanceof ExecutionStatisticPage2)
    	{
    		return ((ExecutionStatisticPage2)getCurrentPage()).getViewerControls();
    	}
    	return null;
    }

    public Viewer[] getExportViewer()
    {
    	return null;
    }

	public void showMethodDetailsTab() {
		Object obj = getModelObject();
		if (obj != null) showMethodDetailsTab((EObject) obj);
	}
	
	public void showMethodDetailsTab(EObject object) {
        setPageTab(object, ExecutionStatisticPage2.METHOD_DETAILS_TAB_INDEX);
        addViewPage(object, true);
		ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();
        if (page != null) {
    		// Bug 299440 - Inform Method Details that the selected method should be updated
    		page.getMethodDetailsTab().getView().updateCurrentSelection();
        	
            page.showMethodDetailsTab();
        }
	}

	public void showExecutionStatisticTab(EObject object) {
        setPageTab(object, ExecutionStatisticPage2.EXECUTION_DETAILS_TAB_INDEX);
        addViewPage(object, true);
		ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();
        if (page != null) {
            page.showExecutionStatisticTab();
        }
	}

	public void showMethodInvocationTab() {
		Object obj = getModelObject();
		if (obj != null) showMethodInvocationTab((EObject) obj);
	}
	
	public void showMethodInvocationTab(EObject object) {
	    setPageTab(object, ExecutionStatisticPage2.METHOD_INVOCATION_TAB_INDEX);
	    addViewPage(object, true);
	    ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();
	    if (page != null) {
	        page.showMethodInvocationTab();
	    }
	}
	
    public void showAggregatedExecutionStatisticTab(EObject object) {
        setPageTab(object, ExecutionStatisticPage2.AGGREGATED_EXECUTION_STATISTICS_TAB_INDEX);
        addViewPage(object, true);
        ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();
        if (page != null) {
            page.showAggregatedExecutionStatistic();
        }
    }
    
    public void showExecutionSummaryTab(EObject object) {
    	setPageTab(object, ExecutionStatisticPage2.EXECUTION_SUMMARY_TAB_INDEX);
        addViewPage(object, true);
        ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();
        if (page != null) {
            page.showExecutionSummaryTab();
        }
    }
    
    protected void setPageTab(EObject object, int index){
        EObject _mofObject = getObjectToView(object);
        if (_mofObject == null) {
            return;
        }        
        TraceViewerPage page = getPage(_mofObject);
        if (page != null
            && page instanceof ExecutionStatisticPage2) {
            
            ((ExecutionStatisticPage2)page).setActiveTabIndex(index);
        }
    }
    
    public void enableSupportedActions(ExecutionStatisticTabItem tabItem) {
        IAction[] all = getAllActions();
    	IAction[] supported = (tabItem != null) ? 
    			tabItem.getSupportedActions() : new IAction[0];

    	MultiLevelStatisticView statisticView = (tabItem != null) ? 
    			tabItem.getStatisticView() : null;
		boolean enableColumnsActions = (statisticView != null);
    	boolean enableTimeMenu = (tabItem != null) ? tabItem.isTimeMenuEnabled() : false;

    	IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();
		tbm.removeAll();

		boolean wasSeparator = false;
		for (int i = 0; i < _toolbarItems.length; i++) {
			if (_toolbarItems[i] instanceof Separator) {
				if (!wasSeparator) {
					tbm.add(_toolbarItems[i]);
					wasSeparator = true;
				}
			} else {
				wasSeparator = false;
				if (isOneOfActions(_toolbarItems[i], supported) 
						|| !isOneOfActions(_toolbarItems[i], all)) {
					tbm.add(_toolbarItems[i]);
				}
			}
		}

		IMenuManager menuMgr = getViewSite().getActionBars().getMenuManager();
		IContributionItem[] menuItems = menuMgr.getItems();
		menuMgr.removeAll();
		if (enableColumnsActions) {
			menuMgr.add(_chooseColumns);
			menuMgr.add(_sortByColumn);
		}
		for (int i = 0; i < menuItems.length; i++) {
			if (menuItems[i] instanceof ActionContributionItem) {
				IAction action = ((ActionContributionItem)menuItems[i]).getAction();
				if (action != _sortByColumn && action != _chooseColumns) {
					menuMgr.add(menuItems[i]);
				}
			} else if (menuItems[i] != _timeMenu) {
				menuMgr.add(menuItems[i]);
			}
		}
		if (enableTimeMenu) {
			menuMgr.add(_timeMenu);
		}

		getViewSite().getActionBars().updateActionBars();
    }
    
    private boolean isOneOfActions(IContributionItem item, IAction[] actions) {
    	if (! (item instanceof ActionContributionItem)) {
    		return false;
    	}
    	IAction lookFor = ((ActionContributionItem)item).getAction();
    	for (int i = 0; i < actions.length; i++) {
    		if (actions[i] == lookFor) {
    			return true;
    		}
    	}
    	return false;
    }
    
    protected IAction[] getAllActions() {
        return new IAction[] {
        		getReportAction(),
        		getFiltersAction(),
                _percentMode,
                _deltaColumns,
                _classLevel,
                _packageLevel,
                _instanceLevel,
                _methodLevel,
                _next,
                _previous,
                _update,
                _caller,
                _callee,
                _openSource,
                _zoomInAction,
                _zoomOutAction,
                _stdSelectAction,
                _openColorDialog
        };
    }

	private void createPercentModeAction() {
		if (_percentMode != null) {
			return;
		}
		String strShowPercent = TraceUIMessages._13;
		_percentMode = new Action(strShowPercent) {
            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2) getCurrentPage();

                if (page == null)
                    return;
                page.runShowPercentAction();
            }

            public int getStyle() {
                return IAction.AS_CHECK_BOX;
            }
        };

        _percentMode.setText(strShowPercent);
        TracePluginImages.setImageDescriptors(_percentMode,
                TracePluginImages.T_LCL, TracePluginImages.IMG_PERCENT);
        _percentMode.setDescription(strShowPercent);
        _percentMode.setToolTipText(strShowPercent);
        _percentMode.setEnabled(true);
	}
	
		
	public void showPage(IPage page) {
		super.showPage(page);
		if (page instanceof ExecutionStatisticPage2) {
			final ExecutionStatisticPage2 executionStatisticPage = (ExecutionStatisticPage2)page;
			AccessController.doPrivileged(new PrivilegedAction() {
				public Object run() {
					System.setProperty("ShowInvocationFlow", Boolean.toString(PerftraceUtil.hasFullMethodInvocationInfo(executionStatisticPage.getMOFObject())));
					System.setProperty("ShowInvocationDetails", Boolean.toString(PerftraceUtil.hasMethodInvocationInfo(executionStatisticPage.getMOFObject())));
					return null;
				}
			});
		}
	}
	
	public Action getReportAction() {
		return _printColumns;
	}
	
	public String getDefaultPageMessage() {
		return TraceMessages._22;
	}

	public String getViewID() {
		return VIEW_ID;
	}

	public void init(IViewSite site, IMemento memento) throws PartInitException {
		super.init(site, memento);
		if (memento == null) return;

		final String rid = memento.getString(RUNTIME_ID);
		if (rid == null) return;

		loadingTrace();
		
		site.getShell().getDisplay().asyncExec(new Runnable() {
			public void run() {
				PDProjectExplorer.getFromActivePerspective();
				
				EObject obj = PDContentProvider.getAgent(rid);
				if (obj != null) { 
					showExecutionSummaryTab(obj);				}
				else
					loadingTraceDone();
			}
		});
	}
	
	public void saveState (IMemento memento) {
		String rid = null;
		if (_mofObject != null && _mofObject instanceof TRCAgentProxy) {
			rid = ((TRCAgentProxy) _mofObject).getRuntimeId();
		}

		if (rid != null) {
			memento.putString(RUNTIME_ID, rid);
			super.saveState(memento);
		} 
	}

	public boolean isActiveViewer() {
		return this == activeViewer;
	}

	public void partActivated(IWorkbenchPart part) {
		if(part instanceof ExecutionStatisticViewer2)
			activeViewer = (ExecutionStatisticViewer2) part;	
	}

	public void partBroughtToTop(IWorkbenchPart part) {
		if(part instanceof ExecutionStatisticViewer2)
			activeViewer = (ExecutionStatisticViewer2) part;	
	}

	public void partClosed(IWorkbenchPart part) {
		if(activeViewer == part)
			activeViewer = null;	
	}

	public void partDeactivated(IWorkbenchPart part) {}

	public void partOpened(IWorkbenchPart part) {}

	public void createPartControl(Composite parent) {
		super.createPartControl(parent);
		getViewSite().getPage().addPartListener(this);
	}

    public void dispose() {
		getViewSite().getPage().removePartListener(this);
    	super.dispose();
    }

	public static ExecutionStatisticViewer2 getActiveViewer() {
		return activeViewer;
	}
}
