/**********************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionSummaryTab.java,v 1.6 2008/04/17 07:49:33 aalexeev Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.trace.views.internal.ExecutionStatisticView;
import org.eclipse.hyades.trace.views.internal.ExecutionSummaryView;
import org.eclipse.hyades.trace.views.internal.MemoryStatisticView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class ExecutionSummaryTab extends ExecutionStatisticTabItem {

	private static final String TITLE = TraceUIPlugin.getString("59");
	
	protected ExecutionSummaryView _view;
	
	protected ExecutionSummaryTab(final ExecutionStatisticPage2 page) {
		super(page);
	}

	public void createControl(final Composite parent) {
		_view = new ExecutionSummaryView(parent, this);
		_view.initialize();

		setViewContextMenu(_view.getExecutionStatisticView());
		setViewContextMenu(_view.getMemoryStatisticView());
	}

	public void fillContextMenu(final IMenuManager menu) {
		if (_view != null) {
			_view.menuAboutToShow(menu);
		}
	}

	public Control getControl() {
		return (_view != null) ? _view.getControl() : null;
	}

	public ExecutionSummaryView getView() {
		return _view;
	}

	public MultiLevelStatisticView getStatisticView() {
		if (_view == null) {
			return null;
		}
		MultiLevelStatisticView execution = _view.getExecutionStatisticView();
		MultiLevelStatisticView memory = _view.getMemoryStatisticView();
		if (execution != null) {
			return (memory == null || !hasFocus(memory)) ? execution : memory;
		} else {
			return memory;
		}
	}

	private boolean hasFocus(MultiLevelStatisticView view) {
		Tree tree = view.getTree();
		if (tree != null) {
			try {
				return tree.isFocusControl();
			} catch (SWTException e) {
				return false;
			}
		}
		return false;
	}

	public String getViewTitle() {
		return TITLE;
	}

	public void refresh() {
		if (_view != null)
			_view.refresh();
	}

	public void selectionChanged() {
	}

	public void setFocus() {
		if (_view != null) {
			_view.getControl().setFocus();
		}
	}

	public void update(boolean newPage) {
		if (_view != null) {
			_view.update();
        }
	}
	
	public void dispose() {
		super.dispose();
		if (_view != null) {
			_view.dispose();
			_view = null;
		}
	}

	public void update() {
		if (updateView(_view.getExecutionStatisticView())) {
			return;
		}
		updateView(_view.getMemoryStatisticView());
	}

	public Object[] getViewerControls() {
		ExecutionStatisticView executionView = _view.getExecutionStatisticView();
		MemoryStatisticView memoryView = _view.getMemoryStatisticView();
		if (memoryView == null) {
			return (executionView == null) ? new Object[0] : new Object[] {executionView.getTree()};
		}
		return (executionView == null) ? new Object[] {executionView.getTree()}
				: new Object[] {executionView.getTree(), memoryView.getTree()};
	}
	
	public boolean isFilteringEnabled() {
		return false;
	}

	private void setViewContextMenu(final StatisticView view) {
		if (view == null) {
			return;
		}
		_page.setContextMenu(view.getTree(), view.getTreeViewer());
	}

	private boolean updateView(final StatisticView view) {
		if (view == null || !view.getTree().isFocusControl()) {
			return false;
		}
		
		view.update();
		return true;
	}
	
	public void setCheckedLevels(int newLevel) {
		if (_view != null) {
			_view.setCheckedLevels(newLevel);
		}
	}
	
	public void runShowPercentAction() {
		if (_view != null) {
			_view.runShowPercentAction();
		}
	}
	
	public void runDeltaColumnsAction() {
		if (_view != null) {
			_view.runDeltaColumnsAction();
		}
	}

	public IAction[] getSupportedActions() {
        ExecutionStatisticViewer2 viewer = _page.getViewer();
        return new IAction[] {
        		viewer.getReportAction(),
                viewer._packageLevel,
                viewer._classLevel,
                viewer._methodLevel,
                viewer._openSource,
                viewer._percentMode,
                viewer._deltaColumns
        };
    }

	protected void handleHidden() {
		StatisticView v = _view.getExecutionStatisticView();
		if(v != null)
			v.setHidden();
		
		v = _view.getMemoryStatisticView();
		if(v != null)
			v.setHidden();
	}

	protected void handleVisible() {
		StatisticView v = _view.getExecutionStatisticView();
		if(v != null)
			v.setVisible();
		
		v = _view.getMemoryStatisticView();
		if(v != null)
			v.setVisible();
	}
	
}
