/********************************************************************** 
 * Copyright (c) 2005, 2009  IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: FilterEventsUI.java,v 1.16 2009/08/27 17:54:43 ewchan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.ibm.icu.util.ULocale;

public class FilterEventsUI {
	//public static EAttribute ATTRIBUTE_CREATION_TIME = CBEPackageImpl.init().getCBECommonBaseEvent_CreationTime();
	//public static EClass ATTRIBUTE_EVENTS = CBEPackageImpl.init().getCBECommonBaseEvent();	
	private static EAttribute[] comboAttributes =
	{
		TracePackageImpl.init().getTRCPackage_BaseTime(),
		TracePackageImpl.init().getTRCPackage_CumulativeTime(),
		TracePackageImpl.init().getTRCPackage_Calls(),
		TracePackageImpl.init().getTRCPackage_TotalSize(),
		TracePackageImpl.init().getTRCPackage_CollectedSize(),
		TracePackageImpl.init().getTRCPackage_TotalInstances(),
		TracePackageImpl.init().getTRCPackage_CollectedInstances()		
	};
	
	
	private Button filterByTimeOrEventsControl;
	
	private Combo orderCombo;
	private Text lengthText;
	private Combo typeOfDurationCombo;
	
	private FiltersStandardTabUI _standardTabUI;
	
	private IContextLabelFormatProvider _topBaseTime;
	private IContextLabelFormatProvider _topCumulTime;
	private IContextLabelFormatProvider _topCalls;
	private IContextLabelFormatProvider _topTotalSize;	
	private IContextLabelFormatProvider _topCollectedSize;
	private IContextLabelFormatProvider _topTotalInst;
	private IContextLabelFormatProvider _topCollectedInst;

	public FilterEventsUI(FiltersStandardTabUI standardTabUI)
	{
		_standardTabUI = standardTabUI;
		
		String context = ContextUpdaterHelper.getCurrentFocusContextLanguage();
		
		_topBaseTime = getContextLabelFormatProvider(context, IContextAttributes.FT_TOP_BASE_TIME);		
		_topCumulTime = getContextLabelFormatProvider(context, IContextAttributes.FT_TOP_CUMULATIVE_TIME);
		_topCalls = getContextLabelFormatProvider(context, IContextAttributes.FT_TOP_CALLS);
		_topTotalSize = getContextLabelFormatProvider(context, IContextAttributes.FT_TOP_TOTAL_SIZE);		
		_topCollectedSize = getContextLabelFormatProvider(context, IContextAttributes.FT_TOP_COLLECTED_SIZE);
		_topTotalInst = getContextLabelFormatProvider(context, IContextAttributes.FT_TOP_TOTAL_INST);
		_topCollectedInst = getContextLabelFormatProvider(context, IContextAttributes.FT_TOP_COLLECTED_INST);
	}
	
	private IContextLabelFormatProvider getContextLabelFormatProvider(String context, String attributeId)
	{
		return ContextManager.getContextLabelFormatProvider(context, attributeId, IContextLabelFormatProvider.MODE_VIEW_FILTER);
	}
	
	public Control createControl(Composite parent) {
		Composite timeEventsContainer = createCompositeWithNumberColumns(parent, 1);
		
		filterByTimeOrEventsControl = new Button(timeEventsContainer, SWT.CHECK);
		//_caseControl.setLayoutData(GridUtil.createHorizontalFill());
		filterByTimeOrEventsControl.setLayoutData(new GridData());
		filterByTimeOrEventsControl.setText(TraceUIMessages._184);
		filterByTimeOrEventsControl.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_TIME_OR_EVENTS, "=", String.valueOf(filterByTimeOrEventsControl.getSelection()));
				filterByTimeEventsUpdate();
			}
		});

		Composite comboBoxContainers = createCompositeWithNumberColumns(timeEventsContainer, 5);
		
		Label showLabel = new Label(comboBoxContainers, SWT.BOLD);
		showLabel.setText(TraceUIMessages._185);
		
		//get locale information for ordering of user input
		//see https://bugs.eclipse.org/bugs/show_bug.cgi?id=286290
		ULocale ulocale = ULocale.getDefault();
		boolean rotateLayout = ulocale.getLanguage().equals("fr") || ulocale.getLanguage().equals("es") || ulocale.getLanguage().equals("ru");;
		
		if (rotateLayout) {
			lengthText = new Text(comboBoxContainers, SWT.BORDER);
			lengthText.setLayoutData(GridUtil.createHorizontalFill());
			lengthText.addKeyListener(new KeyAdapter() {
				public void keyReleased(KeyEvent key) {
					if (!isInt(lengthText.getText().trim()))
						_standardTabUI.setError(TraceUIMessages._196);
					else
						_standardTabUI.noError();
				}
			});
			
			orderCombo = new Combo(comboBoxContainers, SWT.BORDER | SWT.READ_ONLY);
			orderCombo.setLayoutData(GridUtil.createHorizontalFill());
			orderCombo.add(TraceUIMessages._187);
			orderCombo.add(TraceUIMessages._186);
			orderCombo.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					//getFilter().putAttributeOperatorValue(FILTER_STANDARD_ORDER, "=", orderCombo.getText());
				}
			});
		}
		else {
			orderCombo = new Combo(comboBoxContainers, SWT.BORDER | SWT.READ_ONLY);
			orderCombo.setLayoutData(GridUtil.createHorizontalFill());
			orderCombo.add(TraceUIMessages._187);
			orderCombo.add(TraceUIMessages._186);
			orderCombo.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					//getFilter().putAttributeOperatorValue(FILTER_STANDARD_ORDER, "=", orderCombo.getText());
				}
			});
			
			lengthText = new Text(comboBoxContainers, SWT.BORDER);
			lengthText.setLayoutData(GridUtil.createHorizontalFill());
			lengthText.addKeyListener(new KeyAdapter() {
				public void keyReleased(KeyEvent key) {
					if (!isInt(lengthText.getText().trim()))
						_standardTabUI.setError(TraceUIMessages._196);
					else
						_standardTabUI.noError();
				}
			});			
		}
		
		Label byLabel = new Label(comboBoxContainers, SWT.BOLD);
		byLabel.setText(TraceUIMessages._188);
		
		typeOfDurationCombo = new Combo(comboBoxContainers, SWT.BORDER | SWT.READ_ONLY);
		typeOfDurationCombo.setLayoutData(GridUtil.createHorizontalFill());
		typeOfDurationCombo.add(_topBaseTime.getDisplayStringFromElement(IContextAttributes.FT_TOP_BASE_TIME, null, IContextLabelFormatProvider.MODE_VIEW_FILTER));
		typeOfDurationCombo.add(_topCumulTime.getDisplayStringFromElement(IContextAttributes.FT_TOP_CUMULATIVE_TIME, null, IContextLabelFormatProvider.MODE_VIEW_FILTER));
		typeOfDurationCombo.add(_topCalls.getDisplayStringFromElement(IContextAttributes.FT_TOP_CALLS, null, IContextLabelFormatProvider.MODE_VIEW_FILTER));
		typeOfDurationCombo.add(_topTotalSize.getDisplayStringFromElement(IContextAttributes.FT_TOP_TOTAL_SIZE, null, IContextLabelFormatProvider.MODE_VIEW_FILTER));
		typeOfDurationCombo.add(_topCollectedSize.getDisplayStringFromElement(IContextAttributes.FT_TOP_COLLECTED_SIZE, null, IContextLabelFormatProvider.MODE_VIEW_FILTER));
		typeOfDurationCombo.add(_topTotalInst.getDisplayStringFromElement(IContextAttributes.FT_TOP_TOTAL_INST, null, IContextLabelFormatProvider.MODE_VIEW_FILTER));
		typeOfDurationCombo.add(_topCollectedInst.getDisplayStringFromElement(IContextAttributes.FT_TOP_COLLECTED_INST, null, IContextLabelFormatProvider.MODE_VIEW_FILTER));		
		typeOfDurationCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_TYPE, "=", typeOfDurationCombo.getText());
			}
		});
		
		orderCombo.select(0);
		typeOfDurationCombo.select(0);		
		
		return timeEventsContainer;
	}	
	
	private Composite createCompositeWithNumberColumns(Composite parent, int numColumns)
	{
		Composite container = new Composite(parent, SWT.NULL);
		container.setLayoutData(GridUtil.createHorizontalFill());
		GridLayout layout = new GridLayout();
		layout.numColumns = numColumns;
		container.setLayout(layout);
		
		return container;
	}
	
	public void filterByTimeEventsUpdate()
	{
		boolean filterByTimeOrEvents = filterByTimeOrEventsControl.getSelection(); 
		orderCombo.setEnabled(filterByTimeOrEvents);
		lengthText.setEnabled(filterByTimeOrEvents);
		typeOfDurationCombo.setEnabled(filterByTimeOrEvents);		
	}		
	
	
//	private Double convertFromSeconds(Double seconds)
//	{
//		return seconds;
//	}
//
//	private Double convertToSeconds(Double time)
//	{
//		return time;
//	}	
	
	private int getInt(String str)
	{
		return Integer.parseInt(str);
	}
	
	private boolean isInt(String str)
	{
		try
		{
			Integer.parseInt(str);
			return true;
		}
		catch (NumberFormatException nfe)
		{
			return false;
		}
	}	
	
	public void initializeValues()
	{
		filterByTimeOrEventsControl.setSelection(false);		
	}
	
	public void initializeFrom(SimpleSearchQuery filter)
	{
		if (filter.getOrderByExpresions().size() > 0)
		{
			filterByTimeOrEventsControl.setSelection(true);
			
			OrderByElement orderByElement = (OrderByElement)filter.getOrderByExpresions().get(0);
			
			if (OrderByOperators.ASC_LITERAL.equals(orderByElement.getOperator()))
				orderCombo.select(1);
			else
				orderCombo.select(0);

			lengthText.setText((new Integer(filter.getMaxElements())).toString());
			
			EStructuralFeature feature = ((SimpleOperand)orderByElement.getOperand()).getFeature();
			for (int i = 0; i < comboAttributes.length; i++)
			{
				if (comboAttributes[i].equals(feature))
				{
					typeOfDurationCombo.select(i);
					break;
				}
			}
				
		}
		else
		{
			filterByTimeOrEventsControl.setSelection(false);	
			orderCombo.select(0);	
			lengthText.setText("10");	
			typeOfDurationCombo.select(0);
		}
		
		filterByTimeEventsUpdate();
	}	
	
	
	public void performApply(SimpleSearchQuery filter)
	{
		if (filterByTimeOrEventsControl.getSelection())
		{
			EStructuralFeature feature = comboAttributes[typeOfDurationCombo.getSelectionIndex()];
			
			OrderByOperators operator; 
			if (orderCombo.getSelectionIndex() == 1)
				operator = OrderByOperators.ASC_LITERAL;
			else
				operator = OrderByOperators.DESC_LITERAL;

			int maxElements = getInt(lengthText.getText().trim());
			
			addOrderByExpressionAndSetMaxElements(filter, feature, operator, maxElements);
		}
	}	
	
	public static void addOrderByExpressionAndSetMaxElements(SimpleSearchQuery query, EStructuralFeature feature, OrderByOperators operator, int maxElements)
	{
		OrderByElement orderByElement = ExtensionsFactory.eINSTANCE.createOrderByElement();
		SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
		operand.setFeature(feature);
		orderByElement.setOperand(operand);
		orderByElement.setOperator(operator);
		query.getOrderByExpresions().add(orderByElement);
		query.setMaxElements(maxElements);
	}
}
