/********************************************************************** 
 * Copyright (c) 2005, 2008  IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: FiltersStandardTabTraceViewsUI.java,v 1.19 2008/07/17 22:49:18 ewchan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.hyades.ui.util.ICommonUIHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;


public class FiltersStandardTabTraceViewsUI extends FiltersStandardTabUI {
	
	public static EAttribute ATTRIBUTE_PACKAGE_NAME = TracePackageImpl.init().getTRCPackage_Name();
	public static EAttribute ATTRIBUTE_CLASS_NAME = TracePackageImpl.init().getTRCClass_Name();
	public static EAttribute ATTRIBUTE_METHOD_NAME = TracePackageImpl.init().getTRCMethod_Name();
	public static EAttribute ATTRIBUTE_BASE_TIME = TracePackageImpl.init().getTRCMethod_BaseTime();
	
	public static RelationalOperators OPERATOR_LIKE = RelationalOperators.get(RelationalOperators.LIKE);
	public static RelationalOperators OPERATOR_GREATER_THAN = RelationalOperators.get(RelationalOperators.GT);
	
	private boolean _showMethodLevel;
	
	private Text _filterText;
	private Button _packageLevel;
	private Button _classLevel;
	private Button _methodLevel;
	private Button _caseControl;
	private Button _gettersFilter;
	private Button _baseTimeFilter;
	
	//private ImportTraceRange _traceRange;	
	private FilterEventsUI _eventsUI;
	
	private IContextLabelFormatProvider _packageLabelProvider;
	private IContextLabelFormatProvider _classLabelProvider;
	private IContextLabelFormatProvider _methodLabelProvider;	
	
	public FiltersStandardTabTraceViewsUI(boolean showMethodLevel)
	{
		super();
		_showMethodLevel = showMethodLevel;
	}

	private void updateLabelProvider() {
		String context = ContextUpdaterHelper.getCurrentFocusContextLanguage();
		_packageLabelProvider = getContextLabelFormatProvider(context, IContextAttributes.PACKAGE_NAME);		
		_classLabelProvider = getContextLabelFormatProvider(context, IContextAttributes.CLASS_NAME);
		_methodLabelProvider = getContextLabelFormatProvider(context, IContextAttributes.METHOD_NAME);
	}
	
	private IContextLabelFormatProvider getContextLabelFormatProvider(String context, String attributeId)
	{
		return ContextManager.getContextLabelFormatProvider(context, attributeId, IContextLabelFormatProvider.MODE_VIEW_FILTER);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.filters.ui.IFiltersTabUI#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public Control createControl(Composite parent) {
		Composite content = new Composite(parent, SWT.NULL);
		content.setLayout(new GridLayout());
		
		
		Group nameFilters = new Group(content, SWT.NULL);
		nameFilters.setText(TraceUIMessages._270);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		nameFilters.setLayout(layout);
		GridData data = GridUtil.createHorizontalFill();
		nameFilters.setLayoutData(data);
		
		Composite filterContainer = new Composite(nameFilters, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		filterContainer.setLayout(layout);
		data = GridUtil.createHorizontalFill();
		//data.horizontalSpan = 2;
		filterContainer.setLayoutData(data);

		
		Label filter = new Label(filterContainer, SWT.NULL);
		filter.setText(TraceUIMessages._182);
		
		
		Composite filterTextContainer = new Composite(filterContainer, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		filterTextContainer.setLayout(layout);
		data = GridUtil.createHorizontalFill();
		//data.horizontalSpan = 2;
		filterTextContainer.setLayoutData(data);

		_filterText = new Text(filterTextContainer, SWT.BORDER);
		_filterText.setLayoutData(GridUtil.createHorizontalFill());
		_filterText.addKeyListener(new KeyAdapter() {
			public void keyReleased(KeyEvent key) {
				//saveFilterText(filterText.getText());
			}
		});

		_caseControl = new Button(filterTextContainer, SWT.CHECK);
		_caseControl.setLayoutData(new GridData());
		_caseControl.setText(TraceUIMessages._183);
		
		Composite levelContainer = new Composite(filterContainer, SWT.NULL);
		layout = new GridLayout();
		levelContainer.setLayout(layout);
		levelContainer.setLayoutData(GridUtil.createHorizontalFill());
		
		Label filterByLabel = new Label(levelContainer, SWT.NULL);
		filterByLabel.setText(TraceUIMessages._178);

		Composite buttonLevelContainer = new Composite(levelContainer, SWT.NULL);
		layout = new GridLayout();
		buttonLevelContainer.setLayout(layout);
		buttonLevelContainer.setLayoutData(GridUtil.createHorizontalFill());
		
		updateLabelProvider();		

		_packageLevel = new Button(buttonLevelContainer, SWT.RADIO);
		_packageLevel.setText(_packageLabelProvider.getDisplayStringFromElement(TraceMessages.ST_FPKN,null,IContextLabelFormatProvider.MODE_VIEW_FILTER));
		_packageLevel.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//changeLevelTo(ATTRIBUTE_PACKAGE_NAME);
			}
		});
		
		_classLevel = new Button(buttonLevelContainer, SWT.RADIO);
		_classLevel.setText(_classLabelProvider.getDisplayStringFromElement(TraceMessages.ST_FPCN,null,IContextLabelFormatProvider.MODE_VIEW_FILTER));
		_classLevel.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//changeLevelTo(ATTRIBUTE_CLASS_NAME);
			}
		});
		
		_methodLevel = null;
		if (_showMethodLevel)
		{
			_methodLevel = new Button(buttonLevelContainer, SWT.RADIO);
			_methodLevel.setText(_methodLabelProvider.getDisplayStringFromElement(TraceMessages.ST_FPMN,null,IContextLabelFormatProvider.MODE_VIEW_FILTER));
			_methodLevel.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					//changeLevelTo(ATTRIBUTE_METHOD_NAME);
				}
			});
		}
		
//		_traceRange = new ImportTraceRange(this);
//		_traceRange.createControl(content);
		
		_eventsUI = new FilterEventsUI(this);
		_eventsUI.createControl(nameFilters);
		
		Composite gettersFilterContainer = new Composite(nameFilters, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		gettersFilterContainer.setLayout(layout);
		data = GridUtil.createHorizontalFill();
		gettersFilterContainer.setLayoutData(data);
		
		_gettersFilter = new Button(gettersFilterContainer, SWT.CHECK);
		_gettersFilter.setText(TraceUIMessages._233);
		_gettersFilter.setSelection(false);
		
		Group valueFilters = new Group(content, SWT.NULL);
		valueFilters.setText(TraceUIMessages._234);
		layout = new GridLayout();
		layout.numColumns = 2;
		valueFilters.setLayout(layout);
		data = GridUtil.createHorizontalFill();
		valueFilters.setLayoutData(data);
		
		Composite valueFilterContainer = new Composite(valueFilters, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		valueFilterContainer.setLayout(layout);
		data = GridUtil.createHorizontalFill();
		valueFilterContainer.setLayoutData(data);
		
		_baseTimeFilter = new Button(valueFilterContainer, SWT.CHECK);
		_baseTimeFilter.setText(TraceUIMessages._235);
		_baseTimeFilter.setSelection(false);
		Composite thresholdContainer = new Composite(valueFilters, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		thresholdContainer.setLayout(layout);
		data = new GridData(GridData.FILL_HORIZONTAL);
		thresholdContainer.setLayoutData(data);
		
		return content;
	}

	protected void createSpacer(Composite parent) {
		Label spacer = new Label(parent, SWT.NONE);
		GridData data = new GridData();
		data.horizontalAlignment = GridData.FILL;
		data.verticalAlignment = GridData.BEGINNING;
		spacer.setLayoutData(data);
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.filters.ui.internal.dialog.FiltersTabUI#initializeFrom(org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery)
	 */
	public void initializeFrom(SimpleSearchQuery filter) {
		// initialize values		
		_filterText.setText("");
		_caseControl.setSelection(true);
		_eventsUI.initializeValues();
		
		boolean levelSet = false;
		
		if (filter.getWhereExpression() != null 
				&& (filter.getWhereExpression() instanceof LogicalExpression))
		{
			LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
			EList filterElements = logicalExpression.getArguments();

			for (int i = 0; i < filterElements.size(); i++)
			{
				if (filterElements.get(i) instanceof BinaryExpression) {
					BinaryExpression be = (BinaryExpression)filterElements.get(i);
					EStructuralFeature feature = ((SimpleOperand)be.getLeftOperand()).getFeature();
					//EClass type = be.getLeftOperand().getType();				

					if (feature != null)
					{
						boolean validFeature = false;
						String filterText = "";
						if (feature.equals(ATTRIBUTE_PACKAGE_NAME))
						{
							filterText = _packageLabelProvider.convertModelValueToDisplayString(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));						
							_packageLevel.setSelection(true);
							validFeature = true;
						}
						else if (feature.equals(ATTRIBUTE_CLASS_NAME))
						{
							filterText = _classLabelProvider.convertModelValueToDisplayString(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));						
							_classLevel.setSelection(true);
							validFeature = true;
						}						
						else if (feature.equals(ATTRIBUTE_METHOD_NAME))
						{
							filterText = _methodLabelProvider.convertModelValueToDisplayString(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));						
							_methodLevel.setSelection(true);
							validFeature = true;
						}	

						if (validFeature)
						{
							_filterText.setText(filterText);
							_caseControl.setSelection(!be.isCaseInsensitive());
							levelSet = true;
						}
					}
				}
			}
		}
		
		//bug #173719 - changed from !isFilterDisabled
		_gettersFilter.setSelection(ActiveFilter.isFilterEnabled(TraceUIPlugin.GETSET_FILTER, filter));
		_baseTimeFilter.setSelection(ActiveFilter.isFilterEnabled(TraceUIPlugin.THRESHOLD_FILTER, filter));
		

		if (!levelSet)
			_packageLevel.setSelection(true);

		_eventsUI.initializeFrom(filter);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.filters.ui.internal.dialog.FiltersTabUI#performApply(org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery)
	 */
	public SimpleSearchQuery performApply() {
		SimpleSearchQuery resultFilter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();		
		LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
		EList arguments = logicalExpression.getArguments();
		
		_eventsUI.performApply(resultFilter);
		
		if (_filterText.getText().trim().length() > 0)
		{
			if (_packageLevel.getSelection())
				arguments.add(ICommonUIHelper.INSTANCE.createBinaryExpression(ATTRIBUTE_PACKAGE_NAME, OPERATOR_LIKE, _packageLabelProvider.convertDisplayStringToModelValue(_filterText.getText().trim()), !_caseControl.getSelection()));
			else if (_classLevel.getSelection())
				arguments.add(ICommonUIHelper.INSTANCE.createBinaryExpression(ATTRIBUTE_CLASS_NAME, OPERATOR_LIKE, _classLabelProvider.convertDisplayStringToModelValue(_filterText.getText().trim()), !_caseControl.getSelection()));			
			else if (_methodLevel != null && _methodLevel.getSelection())
				arguments.add(ICommonUIHelper.INSTANCE.createBinaryExpression(ATTRIBUTE_METHOD_NAME, OPERATOR_LIKE, _methodLabelProvider.convertDisplayStringToModelValue(_filterText.getText().trim()), !_caseControl.getSelection()));
		}
		
		if (_gettersFilter.getSelection()) {
			arguments.add(TraceUIPlugin.GETSET_FILTER.createActiveExpression());
		} else {
			arguments.add(TraceUIPlugin.GETSET_FILTER.createDisabledExpression());
		}
		
		if (_baseTimeFilter.getSelection()) {
			arguments.add(TraceUIPlugin.THRESHOLD_FILTER.createActiveExpression());
		} else {
			arguments.add(TraceUIPlugin.THRESHOLD_FILTER.createDisabledExpression());
		}

		resultFilter.setWhereExpression(logicalExpression);
		
		return resultFilter;
	}
}
