/**********************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GetSetFilter.java,v 1.4 2008/07/17 22:49:18 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.util.ICommonUIHelper;

public class GetSetFilter extends ActiveFilter {

	private static final String[] PATTERNS = {"get*", "set*", "is*", "access$*" };
	
	public GetSetFilter() {
		super(UIPlugin.getPluginId() + "_GET_SET_CHECKED_", UIPlugin.getPluginId() + "_GET_SET_UNCHECKED_");
	}

	public WhereExpression createActiveExpression() {
		LogicalExpression result = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		result.setOperator(LogicalOperators.AND_LITERAL);
		
		for (int i = 0; i < PATTERNS.length; i++) {
			LogicalExpression expression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
			expression.setOperator(LogicalOperators.NOT_LITERAL);
			BinaryExpression binaryExpression = ICommonUIHelper.INSTANCE.createBinaryExpression(TracePackageImpl.init().getTRCMethod_Name(), 
					RelationalOperators.get(RelationalOperators.LIKE), PATTERNS[i], false);
			expression.getArguments().add(binaryExpression);
			result.getArguments().add(expression);
		}
		result.setName(getEnabledKey());  //bug #173719
		return result;
	}

	public WhereExpression createDisabledExpression() {
		LogicalExpression result = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		result.setOperator(LogicalOperators.AND_LITERAL);
		result.getArguments().add(ICommonUIHelper.INSTANCE.createBinaryExpression(TracePackageImpl.init().getTRCPackage_BaseTime(), RelationalOperators.NEQ_LITERAL, "-1", true));
		result.setName(getDisabledKey());
		return result;
	}
}
