/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MemoryStatisticPage.java,v 1.2 2005/08/24 15:29:55 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.views.internal.MemoryStatisticView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Composite;

public class MemoryStatisticPage extends MultiLevelStatisticPage {

	public MemoryStatisticPage(EObject mofObject, TraceViewer _viewer) {
		super(mofObject, _viewer);
	}

	/**
	 * display the coverage data by creating an instance
	 * of the CoverageStatistic class
	 */
	protected MultiLevelStatisticView displayData(Composite parent) {
		// Let's save the level and load it in the new instance
		MemoryStatisticView view = new MemoryStatisticView(parent, this);

		return view;
	}
	
	public void updateButtons(int level)
	{
		super.updateButtons(level);
		
		getInstanceLevel().setChecked(MemoryStatisticView.INSTANCE_LEVEL == level);
		deltaColumns().setEnabled(MemoryStatisticView.INSTANCE_LEVEL != level);
	}
	
	public Action percentMode() {
		return ((MemoryStatisticViewer) getTraceViewer()).percentMode();
	}
	
	public Action deltaColumns() {
		return ((MemoryStatisticViewer) getTraceViewer()).deltaColumns();
	}		
	
	/**
	 * @return the Method Level action
	 */
	public Action getInstanceLevel() {
		return ((MemoryStatisticViewer) _viewer).getInstanceLevel();
	}	
}
