/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MemoryStatisticViewer.java,v 1.14 2008/07/21 18:49:43 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Vector;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.MemoryStatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class MemoryStatisticViewer extends MultiLevelStatisticViewer {

	protected Action _percentMode;
	protected Action _deltaColumns;	
	
	protected Action _instanceLevel;		
	
	protected static final String _title =
		TraceUIPlugin.getString("3");

	public MemoryStatisticViewer() {
		super();
		setDefaultFilterName(CommonUIMessages._111);
	}

	/**
	 * create a coverage page
	 */
	public TraceViewerPage createPage(EObject mofObject) {
		if(_fi != null)
			_fi.restore();
		return new MemoryStatisticPage(mofObject, this);
	}

	/**
	 * return the view title
	 */
	public String getViewTitle() {
		return _title;
	}
	
	protected void getLevelActions(Vector actions)
	{
		super.getLevelActions(actions);
		
		_instanceLevel = new Action(IContextAttributes.SHOW_INSTANCE_LEVEL) {
			public void run() {
				MultiLevelStatisticPage page = (MultiLevelStatisticPage) getCurrentPage();

				if(page == null)
				{
				  revertChecked(_instanceLevel);
				  return;
				}

				setCheckedLevels(page, MemoryStatisticView.INSTANCE_LEVEL);

			}
			public int getStyle() {
				return IAction.AS_CHECK_BOX;
			}
		};
//		_instanceLevel.setText(strInstanceLevel);
//		TracePluginImages.setImageDescriptors(
//				_instanceLevel,
//			TracePluginImages.T_LCL,
//			TracePluginImages.IMG_OBJ);
//		_instanceLevel.setImageDescriptor(instanceLevelLP.getIcon());
//		_instanceLevel.setDescription(strInstanceLevel);
//		_instanceLevel.setToolTipText(strInstanceLevel);
		_instanceLevel.setEnabled(true);

		actions.addElement(new Separator());
		actions.addElement(_instanceLevel);		
	}
	
	public void getActions(Vector actions)
	{
	 	String strShowPercent = TraceUIMessages._13;  	  										
		_percentMode = new Action(strShowPercent)
		{
			public void run()
			{
				MemoryStatisticPage page = (MemoryStatisticPage)getCurrentPage();

				if(page == null)
				{
				  revertChecked(_percentMode);
				  return;
				}
				
				page.getView().getShowPercentAction().run();      
			}
			public int getStyle() { return IAction.AS_CHECK_BOX; }


		};

		_percentMode.setText(strShowPercent);
		TracePluginImages.setImageDescriptors(_percentMode,TracePluginImages.T_LCL,TracePluginImages.IMG_PERCENT);			
		_percentMode.setDescription(strShowPercent);   
		_percentMode.setToolTipText(strShowPercent);
		_percentMode.setEnabled(true);

		String strShowDelta = TraceUIMessages._84;	
		_deltaColumns = new Action(strShowDelta)
		{
			public void run()
			{
				MemoryStatisticPage page = (MemoryStatisticPage)getCurrentPage();

				if(page == null)
				{
				  revertChecked(_deltaColumns);
				  return;
				}
				
				page.getView().getDeltaColumnsAction().run();      
			}
			
			public int getStyle() { return IAction.AS_CHECK_BOX; }
		};

		_deltaColumns.setText(strShowDelta);
		TracePluginImages.setImageDescriptors(_deltaColumns,TracePluginImages.T_LCL,TracePluginImages.IMG_DELTACOLUMNS);
		_deltaColumns.setDescription(strShowDelta);   
		_deltaColumns.setToolTipText(strShowDelta);
		_deltaColumns.setEnabled(true);
		
		int actionSize = actions.size();
		
		super.getActions(actions);
		
		if ((actionSize+1)< actions.size())
		{
			actions.insertElementAt(_percentMode, actionSize+2);
			actions.insertElementAt(_deltaColumns, actionSize+3);
		}
		else
		{
			actions.addElement(new Separator());
			actions.addElement(_percentMode);
			actions.addElement(_deltaColumns);
		}	
	}
	
	public Action percentMode() {
		return _percentMode;
	}

	public Action deltaColumns() {
		return _deltaColumns;
	}		
	
	public Action getInstanceLevel() {
		return _instanceLevel;
	}		
	
	protected void setActionsNull()
	{
		super.setActionsNull();
		_instanceLevel = null;
	}		
	
	public void updateContext()
	{
		super.updateContext();
		setActionProperties(_instanceLevel, _context, IContextAttributes.SHOW_INSTANCE_LEVEL);
	}
	
	/**
	 * Returns the default page message.
	 * 
	 */
	public String getDefaultPageMessage() {
		
		return TraceMessages._23;
	}
	
}
