/**********************************************************************
 * Copyright (c) 2006, 2010 Intel Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MethodDetailsTab.java,v 1.8 2010/06/30 20:45:50 jwest Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.internal.MethodDetails;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class MethodDetailsTab extends ExecutionStatisticTabItem {

	protected static final String _title = TraceUIPlugin.getString("7");

	protected MethodDetails _view;
	protected String _description;
	
    public MethodDetailsTab(ExecutionStatisticPage2 page) {
		super(page);
	}
	
	public void createControl(Composite parent) {
		_view = new MethodDetails(parent, this);
		_view.initialize();

		_page.setContextMenu(_view.getMethodStatistic().getTree(), _view
				.getMethodStatistic().getTreeViewer());
		
		_page.setContextMenu(_view.getChildrenStatistic().getTree(), _view
				.getChildrenStatistic().getTreeViewer());
		
		_page.setContextMenu(_view.getParentStatistic().getTree(), _view
				.getParentStatistic().getTreeViewer());

		PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(),
				TraceUIPlugin.getPluginId() + ".mthi0000");
	}

	public boolean isEmpty() {
		return !PerftraceUtil.hasMethodInvocationInfo(_page.getMOFObject());
	}
	
	public Control getControl() {
		return (_view != null) ? _view.getControl() : null;
	}
	
	public void refresh() {
		if (_view != null) {
			_view.updateButtons();
			_view.refresh();
		}
	}	

	public void setFocus() {
		if (_view != null) {
			_view.getControl().setFocus();
		}
	}	

	public void selectionChanged() {
		if (_view != null) {
			_view.selectionChanged();
		}
	}	

	public void fillContextMenu(IMenuManager menu) {
		if (_view != null) {
			_view.menuAboutToShow(menu);
		}
	}

	public void dispose() {
		if (_view != null) {
			_view.dispose();
		}

		_view = null;
		_page = null;
	}

	public void update(boolean newPage) {
		if (newPage && _view != null) {
			_view.update(true);
		}
	}
	
	public MethodDetails getView() {
		return (MethodDetails)_view;
	}
	
	public MultiLevelStatisticView getStatisticView() {
		if (_view == null) {
			return null;
		}
		if (hasFocus(_view.getChildrenStatistic())) {
			return _view.getChildrenStatistic();
		}
		if (hasFocus(_view.getParentStatistic())) {
			return _view.getParentStatistic();
		}
		return _view.getMethodStatistic();
	}

	private boolean hasFocus(MultiLevelStatisticView view) {
		Tree tree = view.getTree();
		if (tree != null) {
			try {
				return tree.isFocusControl();
			} catch (SWTException e) {
				return false;
			}
		}
		return false;
	}
	
	 public String getViewTitle()
	 {
		return _title;
	 }
	 
	 public Action percentMode() {
		 return ((ExecutionStatisticViewer2) _page.getTraceViewer()).percentMode();
	 }

	public void updateTitle()
	{
		ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(getMOFObject());		
		setViewTitle(selModel.getFirstElement());
	}

	protected void setViewTitle(Object selection) {
		
		StringBuffer methodName = new StringBuffer(TraceUIPlugin.getString("7"));
		
		if (selection != null) {
			
			TRCMethod method = null;
			if (selection instanceof TRCMethod)
				method = (TRCMethod)selection;
			else if(selection instanceof TRCMethodInvocation)
				method = ((TRCMethodInvocation)selection).getMethod();
			
			if (method != null) {
				String className = "";
				String packName = "";
				if (method.getDefiningClass() != null) {
					className = method.getDefiningClass().getName();
					if (method.getDefiningClass().getPackage() != null)
						packName = method.getDefiningClass().getPackage().getName();
				}
				if (packName.length() > 0) {
					methodName.append(": ").append(packName).append(".")
				      	.append(className).append(".")
				      	.append(method.getName()).append(method.getSignature());
				} else {
					methodName.append(": ")
					    .append(className).append(".")
				     	.append(method.getName()).append(method.getSignature());
				}
			}
		} else {
			methodName.append(": ").append(TraceUIMessages._171);
		}
		
		setContentDescription(methodName.toString());
	}

	private void setContentDescription(String string) {
		_description = string;
	}

	public String getContentDescription() {
		return _description;
	}
	
	public TRCMethod getCurrentSelection() {
		return _view.getCurrentSelection();
	}

	public void updateStatusContext(IContextLanguage language)
	{
		if (_view != null) {
			_view.updateStatusContext(language);
		}
	}

	public void runShowPercentAction() {
		if (_view != null) {
			_view.getMethodStatistic().getShowPercentAction().run();	
			_view.getParentStatistic().getShowPercentAction().run();		
			_view.getChildrenStatistic().getShowPercentAction().run();
		}
	}
	
    public IAction[] getSupportedActions() {
        ExecutionStatisticViewer2 viewer = _page.getViewer();
        return new IAction[] {
        		viewer.getReportAction(),
                viewer._openSource,
                viewer._percentMode
          	};
    }

	public Object[] getViewerControls() {
		return new Object[] { 
				_view.getMethodStatistic().getTree(),
				_view.getChildrenStatistic().getTree(),
				_view.getParentStatistic().getTree()
				};
	}
	
	public void tabItemSelected() {
		_view.refresh();
	}

	protected void handleHidden() {
		StatisticView v = _view.getMethodStatistic();
		if(v != null)
			v.setHidden();
		
		v = _view.getParentStatistic();
		if(v != null)
			v.setHidden();

		v = _view.getChildrenStatistic();
		if(v != null)
			v.setHidden();
	}

	protected void handleVisible() {
		StatisticView v = _view.getMethodStatistic();
		if(v != null)
			v.setVisible();
		
		v = _view.getParentStatistic();
		if(v != null)
			v.setVisible();

		v = _view.getChildrenStatistic();
		if(v != null)
			v.setVisible();
	}
}
