/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MultiLevelStatisticMethodPage.java,v 1.1 2005/07/22 14:49:37 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticMethodView;
import org.eclipse.jface.action.Action;

public abstract class MultiLevelStatisticMethodPage extends MultiLevelStatisticPage{
	
	public MultiLevelStatisticMethodPage(EObject mofObject, TraceViewer _viewer) {
		super(mofObject, _viewer);
	}	
	
	/**
	 * @return the Method Level action
	 */
	public Action getMethodLevel() {
		return ((MultiLevelStatisticMethodViewer) _viewer).getMethodLevel();
	}
	
	public void updateButtons(int level)
	{
		super.updateButtons(level);

		getMethodLevel().setChecked(MultiLevelStatisticMethodView.METHOD_LEVEL == level);
	}
}
