/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MultiLevelStatisticMethodViewer.java,v 1.9 2008/03/03 17:12:42 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Vector;

import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticMethodView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

public abstract class MultiLevelStatisticMethodViewer extends MultiLevelStatisticViewer{
	
	protected Action _methodLevel;
	
	public MultiLevelStatisticMethodViewer() {
		super();
		setDefaultFilterName(TraceUIMessages._236);
	}
	
	/**
	 * @return the method level action
	 */
	public Action getMethodLevel() {
		return _methodLevel;
	}	

	protected void setActionsNull()
	{
		super.setActionsNull();
		_methodLevel = null;
	}
	
	protected void getLevelActions(Vector actions)
	{
		super.getLevelActions(actions);

		_methodLevel = new Action(IContextAttributes.SHOW_METHOD_LEVEL) {
			public void run() {
				MultiLevelStatisticPage page = (MultiLevelStatisticPage) getCurrentPage();

				if(page == null)
				{
				  revertChecked(_methodLevel);
				  return;
				}

				setCheckedLevels(page, MultiLevelStatisticMethodView.METHOD_LEVEL);

			}
			public int getStyle() {
				return IAction.AS_CHECK_BOX;
			}
		};
//		_methodLevel.setText(strMethodLevel);
//		TracePluginImages.setImageDescriptors(
//			_methodLevel,
//			TracePluginImages.T_LCL,
//			TracePluginImages.IMG_METHOD);
//		_methodLevel.setImageDescriptor(methodLevelLP.getIcon());
//		_methodLevel.setDescription(strMethodLevel);
//		_methodLevel.setToolTipText(strMethodLevel);
		_methodLevel.setEnabled(true);
		
		actions.addElement(_methodLevel);
	}
	
	public void updateContext()
	{
		super.updateContext();
		setActionProperties(_methodLevel, _context, IContextAttributes.SHOW_METHOD_LEVEL);
	}
	
	/**
	 * Returns the default page message.
	 * 
	 */
	
	
}
