/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MultiLevelStatisticPage.java,v 1.6 2008/04/17 07:49:33 aalexeev Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class MultiLevelStatisticPage extends TraceViewerPage {
	
	protected MultiLevelStatisticView _view;	
	
	public MultiLevelStatisticPage(EObject mofObject, TraceViewer _viewer) {
		super(mofObject, _viewer);
	}	
	
	protected abstract MultiLevelStatisticView displayData(Composite parent);
	
	/**
	 * This method :
	 * - activates the method coverage analysis
	 * - displays the results and add a contextual menu 
	 */
	public void createControl(Composite parent) {

		//Display data
		_view = displayData(parent);

		//Contextual menu
		setContextMenu(_view.getTree(), _view.getTreeViewer());
		makeActions();

	}
		
	/**
	 * disposes the CoverageStatistic view
	 */
	public void dispose() {
		if (_view != null && _view.getControl() != null)
			super.dispose();

		//dispose method of the CoverageStatistic class
		if (_view != null) {
			_view.dispose();
		}

		_view = null;
	}

	/**
	 * Contribute to the view popup menu
	 * @param menu
	 */
	public void fillContextMenu(IMenuManager menu) {
		if (_view != null) {
			_view.menuAboutToShow(menu);
		}
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 2:54:24 PM)
	 */
	public void makeActions()
	{
		getTraceViewer().makeActions();
	}	
	
	/**
	 * refresh the content of the page when the "RefreshViews"
	 * command is activated
	 */
	public void refreshPage() {
		if(getView() == null)
			return;
		
		getView().updateButtons();
		getView().refresh();
	}	
	
	/**
	 * @return the Package level action
	 */
	public Action getPackageLevel() {
		return ((MultiLevelStatisticViewer) _viewer).getPackageLevel();
	}

	/**
	 * @return the Class level action
	 */
	public Action getClassLevel() {
		return ((MultiLevelStatisticViewer) _viewer).getClassLevel();
	}	
	
	/**
	 * the control is used by the viewer to display this page
	 */
	public Control getControl() {
		if (getView() != null)
			return getView().getControl();
		else
			return null;
	}
	
	/**
	 * set the focus on the view
	 */
	public void setFocus() {
		if (getView() != null)
		{
			getControl().setFocus();
			getView().showNewSelection();
		}
	}	

	/**
	 * the same element must be selected in all the statistics views
	 */
	public void selectionChanged() {
		if (getView() != null)
			getView().selectionChanged();
	}	
	
	/**
	 * @return the CoverageStatistic instance
	 */
	public MultiLevelStatisticView getView() {
		return _view;
	}	
	
	/**
	 * update the content of the page
	 */
	public void update(boolean newPage) {
		if (newPage && getView() != null) {
			getView().updateUI(getView().getColumnDataList());
		}
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (8/1/2001 6:31:38 PM)
	 * @return org.eclipse.jface.action.Action
	 */
	public Action openSource() {
		return ((MultiLevelStatisticViewer)_viewer).openSource();
	}	
	
	public boolean isEmpty()
	{
		if(_view != null)
			return _view.isEmpty();
		
		return true;
	}	
	
	public void updateButtons(int level)
	{
		getPackageLevel().setChecked(MultiLevelStatisticView.PACKAGE_LEVEL == level);
		getClassLevel().setChecked(MultiLevelStatisticView.CLASS_LEVEL == level);		
	}
	
	public SimpleSearchQuery getCurrentFilter()
	{
		return ((MultiLevelStatisticViewer)_viewer).getCurrentFilter();
	}
	
	public void updateFilterAppliedDescription()
	{
		((MultiLevelStatisticViewer)_viewer).updateFilterAppliedDescription();
	}
	
	protected void handleHidden() {
		super.handleHidden();
		_view.setHidden();
	}

	protected void handleVisible() {
		super.handleVisible();
		_view.setVisible();
	}
}
