/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PatternPage.java,v 1.5 2008/04/17 07:49:33 aalexeev Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.internal.ExecutionDetails;
import org.eclipse.hyades.trace.views.internal.Pattern;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * Insert the type's description here. Creation date: (06/14/2000 12:34:21 PM)
 * 
 * @author: Administrator
 */
public class PatternPage extends TraceViewerPage {
	protected ExecutionDetails _view;

	/**
	 */
	public PatternPage(EObject mofObject, TraceViewer _viewer) {
		super(mofObject, _viewer);
	}

	/**
	 * Insert the method's description here. Creation date: (06/14/2000 12:38:21
	 * PM)
	 * 
	 * @param parent
	 *            org.eclipse.swt.widgets.Composite
	 */
	public void createControl(Composite parent) {
		_view = new ExecutionDetails(parent, this);
		_view.initialize();

		setContextMenu(_view.getCanvas().canvas(), _view.getExecutionGraph());
		setContextMenu(_view.getExecutionStatistic().getTree(), _view
				.getExecutionStatistic().getTreeViewer());

		makeActions();
	}

	/**
	 * @see org.eclipse.ui.part.IPage#dispose
	 */
	public void dispose() {
		if (_view != null && _view.getControl() != null)
			super.dispose();

		if (_view != null)
			_view.dispose();

		_mofObject = null;
		_view = null;
	}

	/**
	 * Returns the SWT control for this page
	 * 
	 * @return the SWT control for this page
	 */
	public Control getControl() {
		return _view.getControl();
	}

	public ExecutionDetails getView() {
		return _view;
	}

	/**
	 * Insert the method's description here. Creation date: (1/11/2001 2:54:24
	 * PM)
	 */
	public void makeActions() {
		_viewer.makeActions();
	}

	public Action baseTime() {
		return ((PatternViewer) _viewer).baseTime();
	}

	public Action rawTime() {
		return ((PatternViewer) _viewer).rawTime();
	}

	/**
	 * Insert the method's description here. Creation date: (6/5/2001 2:45:25
	 * PM)
	 */
	public void refreshPage() {
		if (getView() != null)
			getView().refresh();
	}

	/**
	 * Insert the method's description here. Creation date: (6/5/2001 2:45:25
	 * PM)
	 */
	public void selectionChanged() {
		getView().selectionChanged();
	}

	/**
	 * Sets focus to a part in the page.
	 */
	public void setFocus() {
		_view.getControl().setFocus();
	}

	/**
	 * Insert the method's description here. Creation date: (08/14/2000 5:50:25
	 * PM)
	 */
	public void update(boolean newPage) {
		if (newPage && _view != null)
			_view.update(newPage);

	}

	/**
	 * Contribute to the view popup menu
	 * 
	 * @param menu
	 */
	public void fillContextMenu(IMenuManager menu) {
		if (_view != null) {
			_view.menuAboutToShow(menu);
		}
	}

	public boolean isEmpty() {		
		return _view != null ? _view.isEmpty() : true;
	}

	public Action percentMode() {
		return ((PatternViewer) _viewer).percentMode();
	}

	protected void handleHidden() {
		if(_view == null)
			return;
		StatisticView v = _view.getExecutionStatistic();
		if(v != null)
			v.setHidden();

		Pattern p = _view.getExecutionGraph();
		if(p != null)
			p.setHidden();
	}

	protected void handleVisible() {
		if(_view == null)
			return;
		StatisticView v = _view.getExecutionStatistic();
		if(v != null)
			v.setVisible();
		
		Pattern p = _view.getExecutionGraph();
		if(p != null)
			p.setVisible();
	}
}
