/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PatternViewer.java,v 1.13 2006/01/27 20:47:40 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.actions.internal.ContextSelectionMenuListener;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.part.IPage;

/**
 * Insert the type's description here.
 * Creation date: (06/14/2000 2:49:21 PM)
 * @author: Administrator
 */
public class PatternViewer extends TraceViewer implements IContextViewer
{
   protected Action _reset;
   protected Action _showRawTime;
   private Action _zoomInAction;
   private Action _zoomOutAction;
   private Action _stdSelectAction;
   protected Action _showCompensatedTime;
   protected Action _percentMode;   
   private   boolean _stdSelect = true;
   private   boolean _zoomIn = false;
   private   boolean _zoomOut = false;
   
	protected ContextSelectionMenuListener _contextSelectionMenuListener;
	
	protected String _context;
	protected boolean _contextChanged;


/**
 * HistogramEditor constructor comment.
 */
public PatternViewer() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (08/01/2000 4:17:37 PM)
 * @return org.eclipse.hyades.trace.ui.TraceViewerPage
 */
public TraceViewerPage createPage(EObject mofObject)
{
	return  new PatternPage(mofObject, this);
}
/**
 * @see IWorkbenchPart#dispose
 */
public void dispose()
{
	Enumeration pages = _pages.elements(); 
	while(pages.hasMoreElements())
	{
		IPage page = (IPage) pages.nextElement();

		if(page instanceof PatternPage)
		  ((PatternPage)page).dispose();
	}

	_showCompensatedTime = null;
	_showRawTime = null;
	_stdSelectAction = null;
	_zoomInAction = null;
	_zoomOutAction = null;
	_percentMode = null;

	super.dispose();    
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 2:54:24 PM)
 */
public void makeActions()
{
	if(isInitializedMenu())
	  return; //create the toolbar only once

	super.makeActions();

	initializedMenu(true);
	
    String compTime = TraceUIMessages._112;
	_showCompensatedTime = new Action(compTime)
	{
		public void run()
		{
			TraceUIPlugin.getDefault().getPreferenceStore()
				.setValue(TraceConstants.TIME_OPTION, TraceConstants.COMPENSATED_TIME);
			
			TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
			
		}
	};      
	_showCompensatedTime.setText(compTime);
	_showCompensatedTime.setDescription(compTime);
	_showCompensatedTime.setToolTipText(compTime);   
	int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.TIME_OPTION);
	_showCompensatedTime.setChecked(ref == TraceConstants.COMPENSATED_TIME);         
	
    String rawTime = TraceUIMessages._111;
	_showRawTime = new Action(rawTime)
	{
		public void run()
		{
			TraceUIPlugin.getDefault().getPreferenceStore()
				.setValue(TraceConstants.TIME_OPTION, TraceConstants.RAW_TIME);
			
			TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
			
		}
	};      
	_showRawTime.setText(rawTime);
	_showRawTime.setDescription(rawTime);
	_showRawTime.setToolTipText(rawTime);   
	ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.TIME_OPTION);
	_showRawTime.setChecked(ref == TraceConstants.RAW_TIME);         
		
   String strHome = TraceUIMessages._73;			
	_reset = new Action(strHome)
	{
		public void run()
		{
			PatternPage page = (PatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			page.getView().update();
		}
	};      
	_reset.setText(strHome);
	TracePluginImages.setImageDescriptors(_reset,TracePluginImages.T_TOOL,TracePluginImages.IMG_HOME);		
	_reset.setDescription(strHome);
	_reset.setToolTipText(strHome);         

	String strStdSelect = TraceUIMessages._117;				
	_stdSelectAction = new Action(strStdSelect)
	{
		public void run()
		{
			PatternPage page = (PatternPage)getCurrentPage();

			_stdSelect = true;
			_zoomIn = !_stdSelect;
			_zoomOut = !_stdSelect;		 

			_stdSelectAction.setChecked(true);
			_zoomInAction.setChecked(false);			
			_zoomOutAction.setChecked(false);

			if(page == null)
			  return;
			
			page.getView().zoomIn(_zoomIn);
			page.getView().zoomOut(_zoomOut);												
		}
		
		public int getStyle() { return IAction.AS_CHECK_BOX; }
		
	};
	
	_stdSelectAction.setText(strStdSelect);
	TracePluginImages.setImageDescriptors(_stdSelectAction,TracePluginImages.T_LCL,TracePluginImages.IMG_RESTORE_ORG);		
	_stdSelectAction.setDescription(strStdSelect);
	_stdSelectAction.setToolTipText(strStdSelect);

	
	String strZoomIn = TraceUIMessages._7;				
	_zoomInAction = new Action(strZoomIn)
	{
		public void run()
		{
			PatternPage page = (PatternPage)getCurrentPage();

			_zoomIn = isChecked();
			if (_zoomIn==false)
			{
				_stdSelect = true;
			}
			else {
				_stdSelect = !_zoomIn;
				_zoomOut = !_zoomIn;
			}			 
			if(_zoomIn) 
			{				
				_stdSelectAction.setChecked(false);
				_zoomOutAction.setChecked(false);
			}
			else
				_stdSelectAction.setChecked(true);
					
			if(page == null) {
				return;
			}
			
			page.getView().zoomIn(_zoomIn);												
		}
		
		public int getStyle() { return IAction.AS_CHECK_BOX; }
		
	};

	_zoomInAction.setText(strZoomIn);
	TracePluginImages.setImageDescriptors(_zoomInAction,TracePluginImages.T_LCL,TracePluginImages.IMG_ZOOMIN);		
	_zoomInAction.setDescription(strZoomIn);
	_zoomInAction.setToolTipText(strZoomIn);         

    String strZoomOut = TraceUIMessages._8;
	_zoomOutAction = new Action(strZoomOut)
	{
		public void run()
		{
			PatternPage page = (PatternPage)getCurrentPage();

			_zoomOut = isChecked();
			if (_zoomOut==false)
			{
				_stdSelect = true;
			}
			else {
				_stdSelect = !_zoomOut;
				_zoomIn = !_zoomOut;
			}
			 
			if(_zoomOut) 
			{
				_stdSelectAction.setChecked(false);
				_zoomInAction.setChecked(false);
			}
			else
				_stdSelectAction.setChecked(true);
			
			if(page == null) {
				return;
			}
			
			page.getView().zoomOut(_zoomOut);						
		}
		
		public int getStyle() { return IAction.AS_CHECK_BOX; }
		
	};

	_zoomOutAction.setText(strZoomOut);
	TracePluginImages.setImageDescriptors(_zoomOutAction,TracePluginImages.T_LCL,TracePluginImages.IMG_ZOOMOUT);			
	_zoomOutAction.setDescription(strZoomOut);   
	_zoomOutAction.setToolTipText(strZoomOut);                   
	
	Action openColorDialog = new Action(TraceUIMessages._99)
	{
		public void run()
		{
			GraphColorDialog dialog =
				new GraphColorDialog(
					getViewSite().getShell(),
					TraceUIMessages._97,
					null);
			dialog.open();
		}
	};

	openColorDialog.setText(TraceUIMessages._99);
	TracePluginImages.setImageDescriptors(openColorDialog,TracePluginImages.T_TOOL,TracePluginImages.IMG_COLORS);	
	openColorDialog.setDescription(TraceUIMessages._99);   
	openColorDialog.setToolTipText(TraceUIMessages._99);

  	String strShowPercent = TraceUIMessages._13;  	  	
	_percentMode = new Action(strShowPercent)
	{
		public void run()
		{
			PatternPage page = (PatternPage)getCurrentPage();

			if(page == null)
			  return;
			page.getView().getExecutionStatistic().getShowPercentAction().run();      
		}
		public int getStyle() { return IAction.AS_CHECK_BOX; }


	};

	_percentMode.setText(strShowPercent);
	TracePluginImages.setImageDescriptors(_percentMode,TracePluginImages.T_LCL,TracePluginImages.IMG_PERCENT);
	_percentMode.setDescription(strShowPercent);   
	_percentMode.setToolTipText(strShowPercent);
	_percentMode.setEnabled(true);
	
	IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();
	IMenuManager menu = getViewSite().getActionBars().getMenuManager();
	MenuManager submenu = new MenuManager(TraceUIMessages._113);
	menu.add(submenu);

	submenu.add(_showCompensatedTime);
	submenu.add(_showRawTime);
	
	MenuManager submenu2 = new MenuManager(TraceUIMessages._222);
	submenu2.addMenuListener(getContextSelectionMenuListener());
	submenu2.add(new Action(){});
	menu.add(submenu2);
	
	tbm.add(new Separator());
	tbm.add(_stdSelectAction);
	tbm.add(_zoomInAction);
	tbm.add(_zoomOutAction);
	tbm.add(new Separator());
	tbm.add(_reset);			
	tbm.add(new Separator());
    tbm.add(openColorDialog);
	tbm.add(new Separator());
	tbm.add(_percentMode);
    
	// require update because toolbar control has been created by this point,
	// but manager does not update it automatically once it has been created
	getViewSite().getActionBars().updateActionBars();           
}
/**
 * Insert the method's description here.
 * Creation date: (8/1/2001 6:25:59 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action baseTime() {
	return _showCompensatedTime;
}
/**
 * Insert the method's description here.
 * Creation date: (8/1/2001 6:25:59 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action rawTime() {
	return _showRawTime;
}

public Action percentMode() {
	return _percentMode;
}

/**
 * Insert the method's description here.
 * Creation date: (10/5/2001 11:42:53 AM)
 */
public void setFocus() {
	
	if (getCurrentPage()!=null)
	((PatternPage)getCurrentPage()).setFocus();

}

/*
 * Returns the object that should be viewd if
 * true if the selObject is selected in the monitors view
 * For example, if the process node is selected, the view should display
 * the profiling data if trace collects profiling data
 * 
 */
public EObject getObjectToView(EObject selObject)
{
	if(selObject == null)
	  return selObject;

	if(selObject instanceof TRCProcessProxy)
	{
		int nbOfAgents = 0;
		TRCAgentProxy a = null;
		EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
		for(int idx=0; idx<agents.size(); idx++)
		{
			TRCAgentProxy agent = (TRCAgentProxy) agents.get(idx);
			if(agent == null || agent.eIsProxy())
				continue;
			if(agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE))
			{
				nbOfAgents++;
				a = agent;
			}
		}
		
		if(nbOfAgents==1)
		  return a;
	}

	return selObject;
}

/*
 * Initial title view 
 */
 public String getViewTitle()
 {
 	return TraceUIPlugin.getString("4");
 }

 public void initializeActionBar()
 {
	_stdSelectAction.setChecked(true);
	_zoomInAction.setChecked(false);
	_zoomOutAction.setChecked(false);
 }
 
	public ContextSelectionMenuListener getContextSelectionMenuListener()
	{
		if (_contextSelectionMenuListener == null)
			_contextSelectionMenuListener = new ContextSelectionMenuListener();
		
		return _contextSelectionMenuListener;
	}
	
	/**
	 * Shows the given page
	 */
	public void showPage(IPage page) {
		super.showPage(page);

		getContextSelectionMenuListener().setViewer(this);
	}
	
	public void updateContext()
	{
		ContextUpdaterHelper.setCurrentFocusContextLanguage(getSelectedContext());
		_contextChanged = false;
	}


	public String getSelectedContext()
	{
		return _context;
	}

	public boolean contextChanged()
	{
		return _contextChanged;
	}

	public void setSelectedContext(String context)
	{
		setSelectedContext(context, true);
	}

	public void setSelectedContext(String context, boolean refresh)
	{
		if (context == null)
			_contextChanged = _context != null;
		else
			_contextChanged = !context.equals(_context);
		
		_context = context;
		
		if (_contextChanged && refresh && getCurrentPage() != null)
			((TraceViewerPage)getCurrentPage()).refreshPage();
	}
	
	/**
	 * 
	 * @return viewer associated with this view, if applicable
	 * can be a TreeViewer, TableTreeViewer or null if the view is not using a viewer
	 */
    public Viewer[] getExportViewer()
    {
    	return null;
    }
    
	/**
	 * 
	 * @return control containing the data to be exported
	 */
	public Object[] getViewerControls()
	{
		if(getCurrentPage() != null && getCurrentPage() instanceof PatternPage)
		{
			return new Object[] {((PatternPage)getCurrentPage()).getView().getCanvas()
					, ((PatternPage)getCurrentPage()).getView().getExecutionStatistic().getTree()};
		}
		return null;
	}

	/**
	 * Returns the default page message.
	 * 
	 */
	public String getDefaultPageMessage() {
		
		return TraceMessages._21;
	}
	
}
