/********************************************************************** 
 * Copyright (c) 2005, 2007  IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ProfilingAdvancedTabAttributeSet.java,v 1.15 2007/11/27 15:22:12 ewchan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.trace.ui.internal.util.BasicTraceFeatureFilterAttribute;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.ui.filters.IFilterAttribute;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.hyades.ui.util.ICommonUIHelper;


public class ProfilingAdvancedTabAttributeSet implements IAdvancedTabAttributeSet
{
	public class ObjectCollectedFilterAttribute implements IFilterAttribute
	{
		private String _id;
		private String _attributeId;
		private String _context;
		
		public ObjectCollectedFilterAttribute(String id, String attributeId)
		{
			_id = id;
			_attributeId = attributeId;
		}

		
		public String id() {
			return _id;
		}
		
		public void setContext(String context)
		{
			_context = context;
		}

		
		public String displayText() {
			IContextLabelFormatProvider clfp = ContextManager.getContextLabelFormatProvider(_context, _attributeId, IContextLabelFormatProvider.MODE_VIEW_FILTER);
			if (clfp!=null)
				return clfp.getDisplayStringFromElement(_attributeId, null, IContextLabelFormatProvider.MODE_VIEW_FILTER);
			else
				return _attributeId;

		}

		public String validate(String operator, String value) {
			if (!TraceUIMessages._212.equalsIgnoreCase(value)
				&& !TraceUIMessages._213.equalsIgnoreCase(value))
				return TraceUIMessages._214;

			return null;
		}

		public String[] operators() {
			String[] operators = new String[1];
			
			operators[0] = TraceUIMessages._215;
			return operators;
		}

		public WhereExpression getWhereExpression(String operator, String value) {
			if (TraceUIMessages._212.equalsIgnoreCase(value))
				return ICommonUIHelper.INSTANCE.createBinaryExpression(TracePackage.eINSTANCE.getTRCFullTraceObject_CollectTime(), RelationalOperators.get(RelationalOperators.GT), "0", false);
		    else
		    	return ICommonUIHelper.INSTANCE.createBinaryExpression(TracePackage.eINSTANCE.getTRCFullTraceObject_CollectTime(), RelationalOperators.get(RelationalOperators.EQ), "0", false);
		}

		public String getValue(WhereExpression whereExpression) {
		 	BinaryExpression be = (BinaryExpression)whereExpression;
		 	
		 	if (RelationalOperators.get(RelationalOperators.GT).equals(be.getOperator()))
		 		return TraceUIMessages._212;
		 	else
		 		return TraceUIMessages._213;	
		}

		public String getOperator(WhereExpression whereExpression) {
			return TraceUIMessages._215;
		}

		public String defaultValue() {
			return TraceUIMessages._212;
		}
	}
	
	
	private static RelationalOperators[] _operators = new RelationalOperators[]
	   {
			RelationalOperators.get(RelationalOperators.EQ),
			RelationalOperators.get(RelationalOperators.LIKE),
			RelationalOperators.get(RelationalOperators.NEQ),
			RelationalOperators.get(RelationalOperators.GT),
			RelationalOperators.get(RelationalOperators.LT),
			RelationalOperators.get(RelationalOperators.GE),
			RelationalOperators.get(RelationalOperators.LE)
	   };
	

	
	private IFilterAttribute [] _attributes = new IFilterAttribute[]
		{
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad1", IContextAttributes.PACKAGE_NAME, TracePackage.eINSTANCE.getTRCPackage_Name(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad2", IContextAttributes.PACKAGE_BASE_TIME, TracePackage.eINSTANCE.getTRCPackage_BaseTime(), _operators, true), 
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad3", IContextAttributes.PACKAGE_INH_BASE_TIME, TracePackage.eINSTANCE.getTRCPackage_InheritedBaseTime(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad4", IContextAttributes.PACKAGE_CUMULATIVE_TIME, TracePackage.eINSTANCE.getTRCPackage_CumulativeTime(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad5", IContextAttributes.PACKAGE_INH_CUMULATIVE_TIME, TracePackage.eINSTANCE.getTRCPackage_InheritedCumulativeTime(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad6", IContextAttributes.PACKAGE_CALLS, TracePackage.eINSTANCE.getTRCPackage_Calls(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad7", IContextAttributes.PACKAGE_INH_CALLS, TracePackage.eINSTANCE.getTRCPackage_InheritedCalls(), _operators, true),
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad8", IContextAttributes.PACKAGE_TOTAL_INST, TracePackage.eINSTANCE.getTRCPackage_TotalInstances(), _operators, true), 
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad9", IContextAttributes.PACKAGE_COLLECTED_INST, TracePackage.eINSTANCE.getTRCPackage_CollectedInstances(), _operators, true),			
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad10", IContextAttributes.PACKAGE_TOTAL_SIZE, TracePackage.eINSTANCE.getTRCPackage_TotalSize(), _operators, true),
			
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad11", IContextAttributes.CLASS_NAME, TracePackage.eINSTANCE.getTRCClass_Name(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad12", IContextAttributes.CLASS_BASE_TIME, TracePackage.eINSTANCE.getTRCClass_BaseTime(), _operators, true), 
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad13", IContextAttributes.CLASS_INH_BASE_TIME, TracePackage.eINSTANCE.getTRCClass_InheritedBaseTime(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad14", IContextAttributes.CLASS_CUMULATIVE_TIME, TracePackage.eINSTANCE.getTRCClass_CumulativeTime(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad15", IContextAttributes.CLASS_INH_CUMULATIVE_TIME, TracePackage.eINSTANCE.getTRCClass_InheritedCumulativeTime(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad16", IContextAttributes.CLASS_CALLS, TracePackage.eINSTANCE.getTRCClass_Calls(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad17", IContextAttributes.CLASS_INH_CALLS, TracePackage.eINSTANCE.getTRCClass_InheritedCalls(), _operators, true),
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad18", IContextAttributes.CLASS_TOTAL_INST, TracePackage.eINSTANCE.getTRCClass_TotalInstances(), _operators, true), 
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad19", IContextAttributes.CLASS_COLLECTED_INST, TracePackage.eINSTANCE.getTRCPackage_CollectedInstances(), _operators, true),			
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad20", IContextAttributes.CLASS_TOTAL_SIZE, TracePackage.eINSTANCE.getTRCClass_TotalSize(), _operators, true),	
			
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad21", IContextAttributes.METHOD_NAME, TracePackage.eINSTANCE.getTRCMethod_Name(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad22", IContextAttributes.METHOD_BASE_TIME, TracePackage.eINSTANCE.getTRCMethod_BaseTime(), _operators, true), 
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad23", IContextAttributes.METHOD_CUMULATIVE_TIME, TracePackage.eINSTANCE.getTRCMethod_CumulativeTime(), _operators, true),
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad24", IContextAttributes.METHOD_CALLS, TracePackage.eINSTANCE.getTRCMethod_Calls(), _operators, true),
			
//		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad25", TraceUIPlugin.getString(_200"), TracePackage.eINSTANCE.getTRCProcess_Pid(), _operators, true),
//			new BasicTraceFeatureFilterAttribute("ftprofiling_ad26", TraceUIPlugin.getString(_201"), TracePackage.eINSTANCE.getTRCProcess_Name(), _operators, true),
			
		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad27", IContextAttributes.FT_THREAD_ID, TracePackage.eINSTANCE.getTRCThread_Id(), _operators, true),
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad28", IContextAttributes.THREAD_NAME, TracePackage.eINSTANCE.getTRCThread_Name(), _operators, true),
			
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad29", IContextAttributes.FT_OBJECT_ID, TracePackage.eINSTANCE.getTRCObject_Id(), _operators, true),
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad30", IContextAttributes.OBJECT_SIZE, TracePackage.eINSTANCE.getTRCObject_Size(), _operators, true),
			
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad31", IContextAttributes.OBJECT_CALLS, TracePackage.eINSTANCE.getTRCFullTraceObject_Calls(), _operators, true),		
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad32", IContextAttributes.OBJECT_BASE_TIME, TracePackage.eINSTANCE.getTRCFullTraceObject_BaseTime(), _operators, true),
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad33", IContextAttributes.OBJECT_CUMULATIVE_TIME, TracePackage.eINSTANCE.getTRCFullTraceObject_CumulativeTime(), _operators, true),
			new ObjectCollectedFilterAttribute("ftprofiling_ad34", IContextAttributes.OBJECT_COLLECTED),
			
			new BasicTraceFeatureFilterAttribute("ftprofiling_ad35", IContextAttributes.FT_AGENT_NAME, HierarchyPackage.eINSTANCE.getTRCAgent_Name(), _operators, true)
//		    new BasicTraceFeatureFilterAttribute("ftprofiling_ad36", TraceUIPlugin.getString(_210"), HierarchyPackage.eINSTANCE.getTRCNode_Name(), _operators, true),		
		};
	
	public IFilterAttribute getFilterAttribute(EStructuralFeature feature)
	{
		for (int i = 0; i < _attributes.length; i++)
		{
			if (((BasicTraceFeatureFilterAttribute)_attributes[i]).feature().equals(feature))
				return _attributes[i];
		}
		
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.filters.ui.ext.IAdvancedAttributeSet#getAttributes()
	 */
	public IFilterAttribute[] getAttributes() {
		String context = ContextUpdaterHelper.getCurrentFocusContextLanguage();
		
		for (int i = 0; i < _attributes.length; i++)
		{
			if (_attributes[i] instanceof BasicTraceFeatureFilterAttribute)
				((BasicTraceFeatureFilterAttribute)_attributes[i]).setContext(context);
			else if (_attributes[i] instanceof ObjectCollectedFilterAttribute)
				((ObjectCollectedFilterAttribute)_attributes[i]).setContext(context);				
		}
		
		return _attributes;
	}
}

	
