/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReferenceTablePage.java,v 1.4 2005/09/16 22:32:50 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.internal.ReferenceTable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPage;

/*
 * CONTEXT_ID clst0000 for Execution Statistic view
 */

/**
 * Insert the type's description here. Creation date: (06/14/2000 12:34:21 PM)
 * 
 * @author: Administrator
 */
public class ReferenceTablePage extends TraceViewerPage {

	protected ReferenceTable _view;

	public ReferenceTablePage(EObject mofObject, TraceViewer _viewer) {
		super(mofObject, _viewer);
	}

	/**
	 * Insert the method's description here. Creation date: (06/14/2000 12:38:21
	 * PM)
	 * 
	 * @return org.eclipse.swt.widgets.Control
	 * @param parent
	 *            org.eclipse.swt.widgets.Composite
	 */
	public void createControl(Composite parent) {
		_view = new ReferenceTable(parent, this);

		setContextMenu(_view.getTree(), _view.getTreeViewer());
		makeActions();
	}

	/**
	 * @see IPage#dispose
	 */
	public void dispose() {
		if (_view != null && _view.getControl() != null)
			super.dispose();

		if (_view != null)
			_view.dispose();

		_mofObject = null;
		_view = null;
	}

	/**
	 * @return the SWT control for this page
	 */
	public Control getControl() {
		return _view.getControl();
	}

	public ReferenceTable getView() {
		return _view;
	}

	/**
	 * Insert the method's description here. Creation date: (1/11/2001 2:54:24
	 * PM)
	 */
	public void makeActions() {
		_viewer.makeActions();
	}

	/**
	 * Insert the method's description here. Creation date: (8/1/2001 6:31:38
	 * PM)
	 * 
	 * @return org.eclipse.jface.action.Action
	 */
	public Action openSource() {
		return ((ReferenceTableViewer) _viewer).openSource();
	}

	public Action referands() {
		return ((ReferenceTableViewer) _viewer).referands();
	}

	public Action referee() {
		return ((ReferenceTableViewer) _viewer).referee();
	}

	/**
	 * Insert the method's description here. Creation date: (6/5/2001 2:45:25
	 * PM)
	 */
	public void refreshPage() {
		getView().refresh();
	}

	/**
	 * Insert the method's description here. Creation date: (6/5/2001 2:45:25
	 * PM)
	 */
	public void selectionChanged() {
		getView().selectionChanged();
	}

	/**
	 * Sets focus to a part in the page.
	 */
	public void setFocus() {
		_view.getControl().setFocus();
		_view.showNewSelection();
	}

	/**
	 * Insert the method's description here. Creation date: (08/14/2000 5:50:25
	 * PM)
	 */
	public void update(boolean newPage) {
		if (newPage)
			_view.updateUI(_view.getColumnDataList());
	}

	/**
	 * Contribute to the view popup menu
	 * 
	 * @param menu
	 */
	public void fillContextMenu(IMenuManager menu) {
		if (_view != null) {
			_view.menuAboutToShow(menu);
		}
	}

	public boolean isEmpty() {
		return _view.isEmpty();
	}

	public SimpleSearchQuery getCurrentFilter() {
		return ((ReferenceTableViewer) _viewer).getCurrentFilter();
	}

	public void updateFilterAppliedDescription() {
		((ReferenceTableViewer) _viewer).updateFilterAppliedDescription();
	}
}
