/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReferenceTableViewer.java,v 1.14 2008/07/21 18:49:43 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.FilterTraceViewer;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.actions.internal.ContextSelectionMenuListener;
import org.eclipse.hyades.trace.views.internal.ReferenceTable;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.ui.filters.IFilterScopes;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;


/**
 * Insert the type's description here.
 * Creation date: (06/14/2000 2:49:21 PM)
 * @author: Administrator
 */
public class ReferenceTableViewer extends FilterTraceViewer implements IContextViewer
{
   protected Action _openSource;   
   protected Action _referee;
   protected Action _referands;
   protected Action _chooseColumns;
   protected Action _sortByColumn;
   protected ContextSelectionMenuListener _contextSelectionMenuListener;
   
	protected String _context;
	protected boolean _contextChanged;
   
   protected final String _title = TraceUIMessages._104;
   
/**
 * ReferenceTableViewer constructor comment.
 */
public ReferenceTableViewer() {
	super();
		
}
/**
 * Insert the method's description here.
 * Creation date: (08/01/2000 4:17:37 PM)
 * @return org.eclipse.hyades.trace.ui.TraceViewerPage
 */
public TraceViewerPage createPage(EObject mofObject)
{
	if(_fi != null)
		_fi.restore();
	return new ReferenceTablePage(mofObject, this);
}
/**
 * @see IWorkbenchPart#dispose
 */
public void dispose()
{
	Enumeration pages = _pages.elements();  
	while(pages.hasMoreElements())
	{
		IPage page = (IPage) pages.nextElement();

		if(page instanceof ReferenceTablePage)
		  ((ReferenceTablePage)page).dispose();
	}

    _referands = null;
    _referee   = null;
    
	super.dispose();
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 2:54:24 PM)
 */
public void makeActions()
{
	if(isInitializedMenu())
	  return; //create the toolbar only once

	super.makeActions();	
	
	initializedMenu(true);
			
    String referandsStr = TraceUIMessages._108;
	_referands = new Action(referandsStr)
	{
		public void run()
		{
			TraceUIPlugin.getDefault().getPreferenceStore()
				.setValue(TraceConstants.OBJ_REF_OPTION, TraceConstants.OBJ_REF_REFERANDS);

			TraceUIPlugin.getDefault().notifyRefChangedEventListener();
			
		}
	};      
	_referands.setText(referandsStr);
	_referands.setDescription(referandsStr);
	_referands.setToolTipText(referandsStr);   
	int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION);
	_referands.setChecked(ref == TraceConstants.OBJ_REF_REFERANDS);         

    String refereeStr = TraceUIMessages._109;
	_referee = new Action(refereeStr)
	{
		public void run()
		{
			TraceUIPlugin.getDefault().getPreferenceStore()
				.setValue(TraceConstants.OBJ_REF_OPTION, TraceConstants.OBJ_REF_REFEREES);
			
			TraceUIPlugin.getDefault().notifyRefChangedEventListener();
		}
	};      
	_referee.setText(refereeStr);
	_referee.setDescription(refereeStr);
	_referee.setToolTipText(refereeStr);            
	_referee.setChecked(ref == TraceConstants.OBJ_REF_REFEREES);         
		
   String openSourceStr = TraceUIMessages._74;										
	_openSource = new Action(openSourceStr)
	{
		public void run()
		{
			ReferenceTablePage page = (ReferenceTablePage)getCurrentPage();

			if(page == null)
			  return;

			OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(page.getMOFObject()).getFirstElement());
		}
	};

	_openSource.setText(openSourceStr);
	TracePluginImages.setImageDescriptors(_openSource,TracePluginImages.T_TOOL,TracePluginImages.IMG_SOURCE);	
	_openSource.setDescription(openSourceStr);   
	_openSource.setToolTipText(openSourceStr);
	_openSource.setEnabled(false);
	
	String strChooseColumns = TraceUIMessages._56;
	_chooseColumns = new Action(strChooseColumns) {
		public void run() {
			ReferenceTablePage page = (ReferenceTablePage)getCurrentPage();
			if (page == null) {
				return;
			}
			ReferenceTable view = page.getView();
			view.getChooseColumnsAction(view.getColumnDataList(), view.getColumnsPreferencesKey()).run();
		}
	};
	_chooseColumns.setText(strChooseColumns);
	TracePluginImages.setImageDescriptors(_chooseColumns, TracePluginImages.T_LCL, TracePluginImages.IMG_CHOOSECOLUMNS);
	_chooseColumns.setDescription(strChooseColumns);
	_chooseColumns.setToolTipText(strChooseColumns);
	_chooseColumns.setEnabled(true);

	String strSortByColumn = TraceUIMessages._58;
	_sortByColumn = new Action(strSortByColumn) {
		public void run() {
			ReferenceTablePage page = (ReferenceTablePage)getCurrentPage();
			if (page == null) {
				return;
			}
			ReferenceTable view = page.getView();
			view.getSortByColumnAction().run();
		}
	};
	
	_sortByColumn.setText(strSortByColumn);
	TracePluginImages.setImageDescriptors(_sortByColumn, TracePluginImages.T_LCL, TracePluginImages.IMG_SORTCOLUMNS);
	_sortByColumn.setDescription(strSortByColumn);
	_sortByColumn.setToolTipText(strSortByColumn);
	_sortByColumn.setEnabled(true);
	
	IMenuManager menum = getViewSite().getActionBars().getMenuManager();
	menum.add(_referands);
	menum.add(_referee);
	menum.add(new Separator());
	menum.add(_chooseColumns);
	menum.add(_sortByColumn);
	MenuManager submenu = new MenuManager(TraceUIMessages._222);
	submenu.addMenuListener(getContextSelectionMenuListener());
	submenu.add(new Action(){});
	menum.add(submenu);
	
	IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();
		
	tbm.add(new Separator());
	tbm.add(_openSource);	

	// require update because toolbar control has been created by this point,
	// but manager does not update it automatically once it has been created
	getViewSite().getActionBars().updateActionBars();           
}

public ContextSelectionMenuListener getContextSelectionMenuListener()
{
	if (_contextSelectionMenuListener == null)
		_contextSelectionMenuListener = new ContextSelectionMenuListener();
	
	return _contextSelectionMenuListener;
}

/**
 * Insert the method's description here.
 * Creation date: (8/21/2001 4:20:37 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action openSource() {
	return _openSource;
}

public Action referands() {
	return _referands;
}

public Action referee() {
	return _referee;
}

/**
 * Insert the method's description here.
 * Creation date: (10/5/2001 11:42:53 AM)
 */
public void setFocus() {

	if (getCurrentPage()!=null)
	((ReferenceTablePage)getCurrentPage()).setFocus();
	
	ContextUpdaterHelper.setCurrentFocusContextLanguage(getSelectedContext());
}

/**
 * Shows the given page
 */
public void showPage(IPage page) {
	super.showPage(page);

	getContextSelectionMenuListener().setViewer(this);
}

/*
 * Returns true if the object can be viewed using this type of view 
 * 
 */
 public boolean isValidObject(Object object)
 {
 	if(object == null)
 	  return false;
 	  
	if(object instanceof TRCMonitor || object instanceof TRCNode)	   
	   return true;

    if( (object instanceof TRCAgentProxy)
         && ((TRCAgentProxy)object).getType().equals(HyadesConstants.PROFILE_AGENT_TYPE))
    {
			return true;    	
    }     

	if(object instanceof TRCProcessProxy)
	{
		EList agents = ((TRCProcessProxy)object).getAgentProxies();
		for(int idx=0; idx<agents.size(); idx++)
		{
			TRCAgentProxy agent = (TRCAgentProxy) agents.get(idx);
			if(agent == null || agent.eIsProxy())
				continue;
			if(agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE))
			{
				return true;
			}
		}
		
	}
 	  
 	return false;
 }

/*
 * Returns the object that should be viewd if
 * true if the selObject is selected in the monitors view
 * For example, if the process node is selected, the view should display
 * the profiling data if trace collects profiling data
 * 
 */
public EObject getObjectToView(EObject selObject)
{
	if(selObject == null)
	  return selObject;

	if(selObject instanceof TRCProcessProxy)
	{
		int nbOfAgents = 0;
		TRCAgentProxy a = null;
		EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
		for(int idx=0; idx<agents.size(); idx++)
		{
			TRCAgentProxy agent = (TRCAgentProxy) agents.get(idx);
			if(agent == null || agent.eIsProxy())
				continue;
			if(agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE))
			{
				nbOfAgents++;
				a = agent;
			}
		}
		
		if(nbOfAgents==1)
		  return a;
	}

	return selObject;
}

/*
 * Initial title view 
 */
 public String getViewTitle()
 {
 	return _title;
 }
 
public String[] getFilterScope()
{
	String[] scope = new String[1];
	scope[0] = IFilterScopes.PROFILING_AGENT_FILTER_SCOPE;
	return scope;
}

public void filterUpdated()
{
	TraceViewerPage page = (TraceViewerPage)getCurrentPage();
	if (page != null) {
		if (fPartVisible)
			page.refreshPage();
		else
			fForceRefresh = true;
	}
}

/**
 * 
 * @return control containing the data to be exported
 */
public Object[] getViewerControls()
{
	if(getCurrentPage() != null && getCurrentPage() instanceof ReferenceTablePage)
	{
		return new Object[]{((ReferenceTablePage)getCurrentPage()).getView().getTree()};
	}
	return null;
}

/**
 * 
 * @return viewers associated with this view, if applicable
 * can be a TreeViewer, TableTreeViewer or null if the view is not using a viewer
 */
public Viewer[] getExportViewer()
{
	if(getCurrentPage() != null && getCurrentPage() instanceof ReferenceTablePage)
	{
		return new Viewer[] {((ReferenceTablePage)getCurrentPage()).getView().getTreeViewer()};
	}
	return null;
}

public void updateContext()
{
	ContextUpdaterHelper.setCurrentFocusContextLanguage(getSelectedContext());
	_contextChanged = false;
}


public String getSelectedContext()
{
	return _context;
}

public boolean contextChanged()
{
	return _contextChanged;
}

public void setSelectedContext(String context)
{
	setSelectedContext(context, true);
}

public void setSelectedContext(String context, boolean refresh)
{
	if (context == null)
		_contextChanged = _context != null;
	else
		_contextChanged = !context.equals(_context);
	
	_context = context;
	
	if (_contextChanged && refresh && getCurrentPage() != null)
		((TraceViewerPage)getCurrentPage()).refreshPage();
}

/**
 * Returns the default page message.
 * 
 */
public String getDefaultPageMessage() {
	
	return TraceMessages._23;
}

}
