/**********************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SinglePatternTab.java,v 1.7 2008/10/20 21:00:32 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.internal.MethodInvocationDetails;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.SinglePattern;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class SinglePatternTab extends ExecutionStatisticTabItem {

	protected MethodInvocationDetails _view;
	private final String _title = TraceUIPlugin.getString("5");
	
	private boolean _stdSelect = true;
	private boolean _zoomIn = false;
	private boolean _zoomOut = false;
	
	protected SinglePatternTab(ExecutionStatisticPage2 page) {
		super(page);
	}

	public void createControl(Composite parent) {
		_view = new MethodInvocationDetails(parent, this);
		_view.initialize();

		_page.setContextMenu(_view.getCanvas().canvas(), _view.getInvocationGraph());
		_page.setContextMenu(_view.getInvocationStatistic().getTree(), _view.getInvocationStatistic().getTreeViewer());
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(),
				TraceUIPlugin.getPluginId() + ".mthi0000");
	}

	public void fillContextMenu(IMenuManager menu) {
		if (_view != null) {
			_view.menuAboutToShow(menu);
		}
	}

	public Control getControl() {
		if (_view != null) {
			return _view.getControl();
		}
		return null;
	}

	public String getViewTitle() {
		return _title;
	}

	public boolean isEmpty() {
		return !PerftraceUtil.hasFullMethodInvocationInfo(_page.getMOFObject());
	}

	public void refresh() {
		if (_view != null) {
			_view.refresh();
		}
	}

	public boolean isTimeMenuEnabled() {
		return true;
	}

	public void runShowPercentAction() {
		if (_view != null) {
			_view.getInvocationStatistic().getShowPercentAction().run();
		}
	}

	public void selectionChanged() {
		if (_view != null) {
			_view.selectionChanged();
		}
	}

	public void setFocus() {
		if (_view != null) {
			_view.getControl().setFocus();
		}
	}

	public void update(boolean newPage) {
		if (_view != null) {
			_view.update(true);
		}
	}
	
	public void dispose() {
		super.dispose();
		if (_view != null) {
			_view.dispose();
			_view = null;
		}
	}
	
	public MultiLevelStatisticView getStatisticView() {
		return _view != null ? _view.getInvocationStatistic() : null;
	}

	public Action previous() {
		return _page.getViewer()._previous;
	}

	public Action next() {
		return _page.getViewer()._next;
	}

	public Action caller() {
		return _page.getViewer()._caller;
	}

	public Action callee() {
		return _page.getViewer()._callee;
	}

	public Action update() {
		return _page.getViewer()._update;
	}
	
	public Action openSource() {
		return _page.openSource();
	}

	public Action baseTime() {
		return _page.getViewer()._showCompensatedTime;
	}

	public Action rawTime() {
		return _page.getViewer()._showRawTime;
	}

	public Action percentMode() {
		return _page.percentMode();
	}
	
	public void runStdSelectAction() {
		_stdSelect = true;
		_zoomIn = !_stdSelect;
		_zoomOut = !_stdSelect;

		_page.getViewer()._stdSelectAction.setChecked(true);
		_page.getViewer()._zoomInAction.setChecked(false);
		_page.getViewer()._zoomOutAction.setChecked(false);

		_view.zoomIn(_zoomIn);
		_view.zoomOut(_zoomOut);
	}
	
	public void runZoomInAction() {
		_zoomIn = _page.getViewer()._zoomInAction.isChecked();
		if (_zoomIn == false) {
			_stdSelect = true;
		} else {
			_stdSelect = !_zoomIn;
			_zoomOut = !_zoomIn;
		}
		if (_zoomIn) {
			_page.getViewer()._stdSelectAction.setChecked(false);
			_page.getViewer()._zoomOutAction.setChecked(false);
		} else
			_page.getViewer()._stdSelectAction.setChecked(true);

		_view.zoomIn(_zoomIn);
	}

	public void runZoomOutAction() {
		_zoomOut = _page.getViewer()._zoomOutAction.isChecked();
		if (_zoomOut == false) {
			_stdSelect = true;
		} else {
			_stdSelect = !_zoomOut;
			_zoomIn = !_zoomOut;
		}

		if (_zoomOut) {
			_page.getViewer()._stdSelectAction.setChecked(false);
			_page.getViewer()._zoomInAction.setChecked(false);
		} else
			_page.getViewer()._stdSelectAction.setChecked(true);

		_view.zoomOut(_zoomOut);
	}

	public void runShowCalleeAction() {
		if (_view != null) {
			_view.showCallee();
		}
	}

	public void runHomeAction() {
		if (_view != null) {
			_view.update();
		}
	}

	public void runShowCallerAction() {
		if (_view != null) {
			_view.showCaller();
		}
	}
	
	public void runPreviousAction() {		
		if (_view != null) {
			_view.previous();
		}
	}

	public void runNextAction() {
		if (_view != null) {
			_view.next();
		}
	}

	public IAction[] getSupportedActions() {
		ExecutionStatisticViewer2 viewer = _page.getViewer();
		return new IAction[] {
        		viewer.getReportAction(),
				viewer._callee,
				viewer._caller,
				viewer._update,
				viewer._next,
				viewer._previous,
				viewer._openSource,
				viewer._openColorDialog,		
				viewer._zoomInAction,
				viewer._zoomOutAction,
				viewer._stdSelectAction
		};
	}

	public Object[] getViewerControls() {
		return new Object[] { _view.getInvocationStatistic().getTree() };
	}

	protected void handleHidden() {
		StatisticView v = _view.getInvocationStatistic();
		if(v != null)
			v.setHidden();
		
		SinglePattern p = _view.getInvocationGraph();
		if(p != null)
			p.setHidden();
	}

	protected void handleVisible() {
		StatisticView v = _view.getInvocationStatistic();
		if(v != null)
			v.setVisible();

		SinglePattern p = _view.getInvocationGraph();
		if(p != null)
			p.setVisible();
	}
}
