/**********************************************************************
 * Copyright (c) 2006, 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ThresholdFilter.java,v 1.4 2007/11/27 15:22:12 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.ui.util.ICommonUIHelper;

public class ThresholdFilter extends DynamicFilter {
	private static String DEFAULT_NEGLIBLE_BASE_TIME = "0.001";
	
	private String threshold = DEFAULT_NEGLIBLE_BASE_TIME;
	
	public ThresholdFilter() {
		super(UIPlugin.getPluginId() + "_THRESHOLD_CHECKED_", UIPlugin.getPluginId() + "_THRESHOLD_UNCHECKED_");
	}

	public SimpleSearchQuery update(final SimpleSearchQuery filter, final EObject object) {
		if (filter == null || filter.getWhereExpression() == null) {
			return filter;
		}
		double totalTime = PerftraceUtil.getTotalCumulativeTime(object);
		threshold = Double.toString(0.001*totalTime);
		SimpleSearchQuery result = duplicateQuery(filter, createActiveExpression(), getEnabledKey());
		return result;
	}
	
	public WhereExpression createActiveExpression() {
		LogicalExpression result = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		result.setOperator(LogicalOperators.AND_LITERAL);
		result.getArguments().add(ICommonUIHelper.INSTANCE.createBinaryExpression(TracePackageImpl.init().getTRCMethod_BaseTime(), RelationalOperators.get(RelationalOperators.GE), threshold, true));
		result.setName(getEnabledKey());
		return result;
	}
	
	public WhereExpression createDisabledExpression() {
		LogicalExpression result = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		result.setOperator(LogicalOperators.AND_LITERAL);
		result.getArguments().add(ICommonUIHelper.INSTANCE.createBinaryExpression(TracePackageImpl.init().getTRCPackage_BaseTime(), RelationalOperators.NEQ_LITERAL, "-1", true));
		result.setName(getDisabledKey());
		return result;
	}

	private SimpleSearchQuery duplicateQuery(final SimpleSearchQuery filter,
			final WhereExpression update, final String updatedName) {
		SimpleSearchQuery result = (SimpleSearchQuery) EcoreUtil.copy(filter);
		if (updatedName.equals(filter.getWhereExpression().getName())) {
			filter.setWhereExpression(update);
		} else {
			updateNamedWhereExpression(filter.getWhereExpression(), update, updatedName);
		}
		return result;
	}

	private boolean updateNamedWhereExpression(final WhereExpression source,
			final WhereExpression update, final String updatedName) {
		if (source instanceof BinaryExpression) {
			return false;
		}
		
		LogicalExpression le = (LogicalExpression) source;
		EList arguments = le.getArguments();
		for (int i = 0; i < arguments.size(); i++) { 
			WhereExpression element = (WhereExpression) arguments.get(i);
			if (updatedName.equals(element.getName())) {
				arguments.set(i, update);
				return true;
			} else if (updateNamedWhereExpression(element, update, updatedName)) {
				return true;
			}
		}
		return false;
	}
}
