/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceViewerTabItem.java,v 1.1 2006/09/21 19:19:30 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class TraceViewerTabItem {

	protected TraceViewerPage _page;
	
	protected TraceViewerTabItem(TraceViewerPage page) {
		_page = page;
	}
	
	public TraceViewerPage getPage() {
		return _page;
	}
	
	public IContextViewer getContextViewer() {
		if (_page != null && _page.getTraceViewer() instanceof IContextViewer) {
			return (IContextViewer)_page.getTraceViewer();
		}
		return null;
	}
	
	public void dispose() {
		_page = null;
	}
	
	public EObject getMOFObject() {
		return (_page != null) ? _page.getMOFObject() : null;
	}
	
	public abstract void createControl(Composite parent);
	
	public abstract boolean isEmpty();
	
	public abstract Control getControl();
	
	public abstract void refresh();
	
	public abstract void setFocus();

	public abstract void selectionChanged();

	public abstract void fillContextMenu(IMenuManager menu);
	
	public abstract void update(boolean newPage);

	public abstract String getViewTitle();

	public abstract void setCheckedLevels(int newLevel);
    
    public abstract void expandToSelectedElement();

	public abstract void runShowPercentAction();

	public abstract void runDeltaColumnsAction();
}
