/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AggregatedExecutionDetailsView.java,v 1.2 2006/10/28 04:01:04 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.AggregatedExecutionStatisticsTab;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;

public class AggregatedExecutionDetailsView implements IViewSelectionChangedListener {
    
    protected AggregatedExecutionStatisticsTab _tabItem;   
    protected AggregatedExecutionStatistic aggrExecutionStatistic;
    protected AggregatedCallStack aggrCallStack;

	protected HyadesFormToolkit _toolkit;
	protected Form _form;

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event){
        selectionChanged();
    }

    public AggregatedExecutionDetailsView(Composite parent, AggregatedExecutionStatisticsTab tabItem) {        
    	this._tabItem = tabItem;

    	_toolkit = new HyadesFormToolkit(parent.getDisplay());
    	_form = _toolkit.createForm(parent);
    	_form.setText(TraceUIPlugin.getString("60"));
    	GridLayout gridLayout = new GridLayout();
    	gridLayout.marginLeft = gridLayout.marginRight = 0;
    	gridLayout.marginTop = gridLayout.marginBottom = 0;
    	_form.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
    	_form.getBody().setLayout(gridLayout);
    	_form.getBody().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

    	SashForm sashForm = new SashForm (_form.getBody(), SWT.VERTICAL);
    	sashForm.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

        aggrExecutionStatistic = new AggregatedExecutionStatistic(sashForm, tabItem);
        aggrCallStack = new AggregatedCallStack(sashForm, tabItem);
        sashForm.setWeights(new int[] {2, 1});
        
        UIPlugin.getDefault().addViewSelectionChangedListener(this);
    }
    
    public void dispose() {
        UIPlugin.getDefault().removeViewSelectionChangedListener(this);
        aggrExecutionStatistic.dispose();
        aggrCallStack.dispose();
        
        _form.dispose();
        _toolkit.dispose();
    }

    public void initialize() {
        /*
         * Do nothing
         */
    } 

    public AggregatedExecutionStatistic getAggregatedExecutionStatistic() {
            return  aggrExecutionStatistic;
        }

    public AggregatedCallStack getAggregatedCallStack() {
        return aggrCallStack;
    }

    public Control getControl() {
        return _form;
    }

    public Object getCurrentSelection() {
        return aggrExecutionStatistic.getLastSelectedObject();
    }

    /**
     * Called when the context menu is about to open.
     * 
     * @see IFillMenuTarget#fillContextMenu
     */
    public void menuAboutToShow(IMenuManager menu) {
        if (aggrExecutionStatistic.getTree().isFocusControl()) {
            aggrExecutionStatistic.menuAboutToShow(menu);
        }
        if (aggrCallStack.getTree().isFocusControl()) {
            aggrCallStack.menuAboutToShow(menu);
        }
    }

    public void openSource() {        
    	OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(_tabItem.getMOFObject()).getFirstElement());        
    }

    public void refresh() {
        aggrExecutionStatistic.refresh();
        aggrCallStack.refresh();
    }
    
    public void selectionChanged() {
        updateCallStacks();
    }
    
    public void update() {
        aggrExecutionStatistic.updateUI(aggrExecutionStatistic.getColumnDataList());
        aggrExecutionStatistic.expandToSelectedElement(false);

        aggrCallStack.updateCallStackInfoProvider();
        aggrCallStack.update();
    }
    
    public void updateCallStacks() {
        if (aggrExecutionStatistic.getTree().isFocusControl()) {
            aggrCallStack.updateCallStackInfoProvider();          
        } else if (aggrCallStack.getTree().isFocusControl()) {
            expandToSelectedElement();
        }
    }

    public void expandToSelectedElement() {
        aggrExecutionStatistic.expandToSelectedElement(false);        
    }
}
