/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContextInfoContainer.java,v 1.9 2008/06/27 17:59:25 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import java.util.Vector;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ContextInfoContainer {
	
	protected Composite _statusContainer;
	protected Composite _statusSelItemContainer;
	protected Composite _statusSelHeaderContainer;
	protected Label _statusIcon;
	protected Label _statusText;
	protected Combo _contextCombo;
	private GridData _visibleLayoutData;
	private GridData _nonVisibleLayoutData;
	
	private Vector _contextInfoContainerListeners;
	
	HyadesFormToolkit _toolkit; 
	
	private EObject mofObject;
	private IContextViewer viewer;
	
	public void setViewer(IContextViewer viewer_)
	{
		viewer = viewer_;	
	}
	
	public void setMOFObject(EObject mofObject_)
	{
		mofObject = mofObject_;
		resetComboListings(_contextCombo);
	}


	public Composite createControl(Composite parent) {
		GridLayout layout;
		
		_toolkit = new HyadesFormToolkit(parent.getDisplay());
		
		_statusContainer = _toolkit.createComposite(parent, SWT.NONE);
		_statusContainer.setLayoutData(GridUtil.createFill());
		layout = new GridLayout();
		layout.numColumns = 3;
		layout.makeColumnsEqualWidth = false;
		_statusContainer.setLayout(layout);

		Label selectedItemContext = new Label(_statusContainer, SWT.NONE);
		selectedItemContext.setBackground(_statusContainer.getBackground());
		selectedItemContext.setText(TraceUIMessages._223);
		selectedItemContext.setLayoutData(GridUtil.createFill());
	
		_statusIcon = new Label(_statusContainer, SWT.CENTER);
		_statusIcon.setBackground(_statusContainer.getBackground());
		GridData data = GridUtil.createFill();
		_statusIcon.setLayoutData(data);

		_statusText = new Label(_statusContainer, SWT.NONE);
		_statusText.setBackground(_statusContainer.getBackground());
		data = GridUtil.createFill();
		_statusText.setLayoutData(data);

		_statusIcon.setImage(null);
		_statusText.setText("");
		
		Label selectedHeaderContext = new Label(_statusContainer, SWT.NONE);
		selectedHeaderContext.setLayoutData(GridUtil.createFill());
		selectedHeaderContext.setBackground(_statusContainer.getBackground());
		selectedHeaderContext.setText(TraceUIMessages._224);
		
		data = GridUtil.createFill();
		data.horizontalSpan = 2;
		_contextCombo = new Combo(_statusContainer, SWT.READ_ONLY);
		_contextCombo.setLayoutData(data);
		_contextCombo.addSelectionListener(new SelectionListener()
			{
				public void widgetSelected(SelectionEvent e) {
					String[] contexts = ContextUpdaterHelper.getContexts(mofObject);
					viewer.setSelectedContext(contexts[_contextCombo.getSelectionIndex()]);
				}

				public void widgetDefaultSelected(SelectionEvent e) {
				}
			}
		);
		
		return _statusContainer;
	}
	
	public void updateStatusContext(IContextLanguage language)
	{	
		if(language == null || language.name().equals(_statusText.getText()))
		   return;
		
		if (_statusIcon.getImage() != null)
			_statusIcon.getImage().dispose();
		
		if (language.icon() != null)
			_statusIcon.setImage(language.icon().createImage());
		else
			_statusIcon.setImage(null);
		
		_statusText.setText(language.name());

		_statusContainer.pack(true);
		notifyContextInfoContainerListeners(_statusContainer.getVisible());
	}
	
	private void resetComboListings(Combo combo) {
		combo.removeAll();

		String[] contexts = ContextUpdaterHelper.getContexts(mofObject);
		String selectedContext = ContextUpdaterHelper.getCurrentContext(contexts, viewer);
		int selectedIndex = -1;
		IContextLanguage language;
		
		for (int i= 0; i < contexts.length; i++)
		{
			language = ContextManager.getContextLanguage(contexts[i]);
			if (language!=null)
			{
				combo.add(language.name());
			
				if (selectedContext != null && selectedContext.equals(contexts[i]))
					selectedIndex = i;
			}
		}
		
		if (selectedIndex >= 0)
			combo.select(selectedIndex);
		
		if (combo.getItemCount() > 1)
			setVisibleLayoutDataForStatusContainer();
		else
			setNonVisibleLayoutDataForStatusContainer();	
	}	
	
	private void setVisibleLayoutDataForStatusContainer()
	{
		if (_visibleLayoutData == null)
		{
			_visibleLayoutData = new GridData();
		}
			
		if (_statusContainer.getLayoutData() != _visibleLayoutData)
		{
			_statusContainer.setLayoutData(_visibleLayoutData);
			_statusContainer.setVisible(true);
			notifyContextInfoContainerListeners(true);
		}
	}
	

	private void setNonVisibleLayoutDataForStatusContainer()
	{
		if (_nonVisibleLayoutData == null)
		{
			_nonVisibleLayoutData = new GridData();
			_nonVisibleLayoutData.heightHint = 0;
			_nonVisibleLayoutData.widthHint = 0;
		}
			
		if (_statusContainer.getLayoutData() != _nonVisibleLayoutData)
		{
			_statusContainer.setLayoutData(_nonVisibleLayoutData);
			_statusContainer.setVisible(false);
			notifyContextInfoContainerListeners(false);
		}
	}
	
	private Vector getContextInfoContainerListeners()
	{
		if (_contextInfoContainerListeners == null)
			_contextInfoContainerListeners = new Vector();
		
		return _contextInfoContainerListeners;
	}
	
	private void notifyContextInfoContainerListeners(boolean isVisible)
	{
		Vector contextInfoContainerListeners = getContextInfoContainerListeners();
		
		for (int i = 0; i < contextInfoContainerListeners.size(); i++)
			((IContextInfoContainerListener)contextInfoContainerListeners.get(i)).visibilityChanged(isVisible);
	}
	
	public void addContextInfoContainerListener(IContextInfoContainerListener listener)
	{
		getContextInfoContainerListeners().add(listener);
	}
}

