/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionSummaryGraphsView.java,v 1.1 2006/09/21 19:19:29 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderConfigurationException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ExecutionSummaryGraphsView {
	private final Composite _parent;
	private final SashForm _graphsContainer;
	private final SummaryGraph _heapGraph;
//	private final SummaryGraph _GCGraph;
	private final SummaryGraph _threadsGraph;
	private final ExecutionStatisticPage2 _page;

	private SummaryGraphSource threadsSource;
	private SummaryGraphSource heapActiveSource;
	private SummaryGraphSource heapTotalSource;
	
	public ExecutionSummaryGraphsView(final ExecutionStatisticPage2 page, final Composite parent) throws ZoomSliderConfigurationException {
		_page = page;
		_parent = parent;
		_graphsContainer = new SashForm(_parent, SWT.HORIZONTAL);
		_graphsContainer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		_heapGraph = new SummaryGraph(_graphsContainer, TraceUIMessages._240);
		heapActiveSource = new SummaryGraphSource(TraceUIMessages._241, Display.getDefault().getSystemColor(SWT.COLOR_BLUE));
		heapTotalSource = new SummaryGraphSource(TraceUIMessages._242, Display.getDefault().getSystemColor(SWT.COLOR_RED));
		_heapGraph.addGraphSource(heapActiveSource);
		_heapGraph.addGraphSource(heapTotalSource);

//		_GCGraph = new SummaryGraph(_graphsContainer, TraceUIMessages._244);
//		_GCGraph.addGraphSource(new SummaryGraphSource(TraceUIMessages._245, Display.getDefault().getSystemColor(SWT.COLOR_BLUE)));
//		_GCGraph.addGraphSource(new SummaryGraphSource(TraceUIMessages._246, Display.getDefault().getSystemColor(SWT.COLOR_DARK_RED)));

		_threadsGraph = new SummaryGraph(_graphsContainer, TraceUIMessages._246);
		threadsSource = new SummaryGraphSource(TraceUIMessages._247, Display.getDefault().getSystemColor(SWT.COLOR_RED));
		_threadsGraph.addGraphSource(threadsSource);
	}
	
	public void update() {
		EObject mof = _page.getMOFObject();
		double time = PerftraceUtil.getMaximumTime(mof);
		Object[] threads = PerftraceUtil.getAllThreads(mof);
		threadsSource.addData(new SummaryGraphSource.GraphDataItem(time, threads.length));
		
		long activeSize = PerftraceUtil.getActiveSize(mof);
		heapActiveSource.addData(new SummaryGraphSource.GraphDataItem(time, activeSize));
		long totalSize = PerftraceUtil.getTotalSize(mof);
		heapTotalSource.addData(new SummaryGraphSource.GraphDataItem(time, totalSize));
		
		_heapGraph.update();
		_threadsGraph.update();
//		_GCGraph.update();
	}

	public void dispose() {
		_heapGraph.dispose();
		_threadsGraph.dispose();
//		_GCGraph.dispose();
	}
}
