/**********************************************************************
 * Copyright (c) 2006,2009 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionSummaryView.java,v 1.11 2009/11/24 22:36:07 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionSummaryTab;
import org.eclipse.hyades.trace.views.adapter.internal.FilterEventsUI;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class ExecutionSummaryView {

	protected HyadesFormToolkit _toolkit;
	protected Form _form;
    protected ExecutionSummaryTab _tabItem;   
    protected ExecutionStatisticView topMethodCalls;
    protected MemoryStatisticView topInstances;
//    protected ExecutionSummaryGraphsView summaryGraphs;

    public ExecutionSummaryView(final Composite parent, final ExecutionSummaryTab tabItem) {        
    	this._tabItem = tabItem;
    	_toolkit = new HyadesFormToolkit(parent.getDisplay());
    	_form = _toolkit.createForm(parent);
    	_form.setText(TraceUIPlugin.getString("59"));
    	GridLayout gridLayout = new GridLayout();
    	gridLayout.marginLeft = gridLayout.marginRight = 0;
    	gridLayout.marginTop = gridLayout.marginBottom = 0;
    	_form.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
    	_form.getBody().setLayout(gridLayout);
    	_form.getBody().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
    	
    	SashForm _sashForm = new SashForm(_form.getBody(), SWT.VERTICAL);
        _sashForm.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
        
    	_toolkit = new HyadesFormToolkit(parent.getDisplay());
        Section titledConvert = getWrappedTitle(_sashForm, TraceUIMessages._237);
        topMethodCalls = new ExecutionStatisticView(titledConvert, tabItem.getPage()) {
            private final SimpleSearchQuery topMethodsFilter = createTopMethodsFilter();
            
        	protected SimpleSearchQuery getCurrentFilter() {
        		return topMethodsFilter;
        	}
        	
        	protected void firstTimeUpdate() {
        		super.firstTimeUpdate();
                redrawTable();
                
//                // sorting by "Base time" column
//                TreeColumn column = getColumn(topMethodCalls.getTree(), 4);
//                if (column != null) {
//                	getViewerSorter().setSortedColumn(-1, column);
//                }
        	}
        };
        topMethodCalls.updateButtons();
        titledConvert.setClient(topMethodCalls.getControl());
        

        if (PerftraceUtil.hasHeapInfo(_tabItem.getMOFObject())) {
        	titledConvert = getWrappedTitle(_sashForm, TraceUIMessages._238);
        	topInstances = new MemoryStatisticView(titledConvert, tabItem.getPage()) {
        		private int level = CLASS_LEVEL;
        		
        		private final SimpleSearchQuery topInstancesFilter = createTopInstancesFilter();

        		protected SimpleSearchQuery getCurrentFilter() {
        			return topInstancesFilter;
        		}

        		protected void firstTimeUpdate() {
        			super.firstTimeUpdate();
        			redrawTable();
        			// sorting by "Total Size" column
        			TreeColumn column = getColumn(topInstances.getTree(), 6);
        			if (column != null) {
        				getViewerSorter().setSortedColumn(-1, column);
        			}
        		}
        		
        		public void setLevel(int level) {
        			this.level = level;
        		}
        		
        		public int getLevel() {
        			return level;
        		}
        	};
        	topInstances.setLevel(topMethodCalls.getLevel());
        	titledConvert.setClient(topInstances.getControl());
        }
        
//        titledConvert = getWrappedTitle(_viewContainer, TraceUIMessages._240);
//        try {
//			summaryGraphs = new ExecutionSummaryGraphsView(_tabItem.getPage(), titledConvert);
//		} catch (ZoomSliderConfigurationException e) {
////			e.printStackTrace();
//		}
//        _viewContainer.setWeights(new int[] {3, 3, 2});
    }

    public void dispose() {
        disposeView(topMethodCalls);
        disposeView(topInstances);
//        summaryGraphs.dispose();
        _toolkit.dispose();
        _form.dispose();
    }

	private void disposeView(final StatisticView view) {
		if (view == null) {
			return;
		}
		view.dispose();
	}

    public void initialize() {
        /*
         * Do nothing
         */
    } 

    public ExecutionStatisticView getExecutionStatisticView() {
    	return topMethodCalls;
    }

    public MemoryStatisticView getMemoryStatisticView() {
    	return topInstances;
    }

    public Control getControl() {
    	return _form;
    }

    /**
     * Called when the context menu is about to open.
     * 
     * @see IFillMenuTarget#fillContextMenu
     */
    public void menuAboutToShow(final IMenuManager menu) {
        menuAboutToShow(menu, topMethodCalls);
        menuAboutToShow(menu, topInstances);
    }

    public void openSource() {        
    	OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(_tabItem.getMOFObject()).getFirstElement());        
    }

    public void refresh() {
    	refreshView(topMethodCalls);
    	refreshView(topInstances);
//        summaryGraphs.update();
    }
    
    public void update() {
    	updateView(topMethodCalls);
    	updateView(topInstances);
//        summaryGraphs.update();
    }
    
    private void updateView(final StatisticView view) {
    	if (view == null) {
    		return;
    	}
    	view.update();
    }

    private void refreshView(final StatisticView view) {
    	if (view == null) {
    		return;
    	}
    	view.refresh();
    }
    
	private SimpleSearchQuery createTopMethodsFilter() {
		SimpleSearchQuery result = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
		FilterEventsUI.addOrderByExpressionAndSetMaxElements(result, TracePackage.eINSTANCE.getTRCPackage_BaseTime(),
				OrderByOperators.DESC_LITERAL, 10);
		setWhereExpressionAnd(result);
		return result;
	}


	private SimpleSearchQuery createTopInstancesFilter() {
		SimpleSearchQuery result = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
		FilterEventsUI.addOrderByExpressionAndSetMaxElements(result, TracePackage.eINSTANCE.getTRCPackage_TotalSize(),
				OrderByOperators.DESC_LITERAL, 10);
		setWhereExpressionAnd(result);
		return result;
	}

	private void setWhereExpressionAnd(final SimpleSearchQuery query) {
		LogicalExpression expr = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		expr.setOperator(LogicalOperators.AND_LITERAL);
		query.setWhereExpression(expr);
	}
	
	private TreeColumn getColumn(final Tree tree, final int logicalIndex) {
		for (int i = 0; i < tree.getColumnCount(); i++) {
			TreeColumn column = tree.getColumn(i);
			StatisticTableColumnInfo info =
                StatisticTableColumnInfo.getStatisticTableColumnInfo(column);
			if (info.getColumnData().getInitalPos() == logicalIndex) {
				return column;
			}
		}
		return null;
	}

	private void menuAboutToShow(final IMenuManager menu, final StatisticView view) {
		if (view == null) {
			return;
		}
		if (view.getTree().isFocusControl()) {
            view.menuAboutToShow(menu);
        }
	}

    private Section getWrappedTitle(final Composite parent, final String title) {
		Section result = _toolkit.createSection(parent, Section.TITLE_BAR);
		result.setText(title);
		result.marginWidth = 3;
		result.marginHeight = 3;

        GridLayout layout = new GridLayout();
        layout.marginLeft = layout.marginRight = 0;
        layout.marginTop = layout.marginBottom = 0;
        TableWrapData data = new TableWrapData();
        data.grabVertical = true;
        data.grabHorizontal = true;
        data.heightHint = 200;
        result.setLayout(layout);
        result.setLayoutData(data);
		return result;
    }

	public void setCheckedLevels(int newLevel) {
		if (newLevel == ExecutionStatisticView.INSTANCE_LEVEL) {
			newLevel = ExecutionStatisticView.METHOD_LEVEL;
		}
		if (topMethodCalls != null && topMethodCalls.getLevel() != newLevel) {
			topMethodCalls.setLevel(newLevel);
			topMethodCalls.updateButtons();
			topMethodCalls.redrawTable();
		}
		if (newLevel == ExecutionStatisticView.METHOD_LEVEL) {
			newLevel = ExecutionStatisticView.CLASS_LEVEL;
		}
		if(topInstances != null && topInstances.getLevel() != newLevel) {
			topInstances.setLevel(newLevel);
			topInstances.redrawTable();
		}
		if (topMethodCalls != null) {
			topMethodCalls.updateButtons();
		} else if (topInstances != null) {
			topInstances.updateButtons();
		}
	}

	public void runDeltaColumnsAction() {
		if (topMethodCalls != null) {
			topMethodCalls.getDeltaColumnsAction().run();
		}
		if (topInstances != null) {
			topInstances.getDeltaColumnsAction().run();
		}
	}

	public void runShowPercentAction() {
		if (topMethodCalls != null) {
			topMethodCalls.getShowPercentAction().run();
		}
		if (topInstances != null) {
			topInstances.getShowPercentAction().run();
		}
	}
}
