/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphDrawStrategy.java,v 1.4 2005/08/10 02:24:22 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.jface.action.*;
import org.eclipse.ui.PlatformUI;

/*
* CONTEXT_ID exef0001 for compress time action in execution flow view
*/
/*
* CONTEXT_ID exef0002 for expand time action in execution flow view
*/
/*
* CONTEXT_ID exef0003 for reset time action in execution flow view
*/


public abstract class GraphDrawStrategy extends StdDrawStrategy
{
 	protected Action _restoreAction;	
	protected final float MAG_STEP = 2;
	protected Separator fSeparator = new Separator();	

	//-------------------------------	
	class RestoreDefaultAction extends Action
	{
		public RestoreDefaultAction(String name)
		{
			super(name);
		    //setImageDescriptor(TracePluginImages.getImageDescriptor(TracePluginImages.IMG_HOME));
		    TracePluginImages.setImageDescriptors(this,TracePluginImages.T_TOOL,TracePluginImages.IMG_HOME);
		    
		    PlatformUI.getWorkbench().getHelpSystem().setHelp(
				RestoreDefaultAction.this,
				TraceUIPlugin.getPluginId()+".exef0003");
		}

		/**
		 * Invoked when an action occurs. 
	 	* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run()
		{
			if(jcanvas() == null)
			  return;

			resetArea();						  
			jcanvas().zoomToFill(1f, 1000f);
			jcanvas().redraw();
			  
		}		
	}		

public GraphDrawStrategy ()
{
	_restoreAction = new RestoreDefaultAction(TraceUIMessages._6);
}
	/**
	 * This method should fill (or update) the given menu. It is called just before
	 * the menu opens. 
	 */
	public void fillContextMenu(IMenuManager menu)
	{
		menu.add(fSeparator);		
		menu.add(_restoreAction);				
	}
}
