/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MethodInvocationDetails.java,v 1.5 2008/04/17 07:49:34 aalexeev Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.SinglePatternTab;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;

public class MethodInvocationDetails 
{
	protected SinglePatternTab _tabItem;	
	
	protected HyadesFormToolkit _toolkit;
	protected Form _form;

	protected SinglePattern _invocationGraph;
	protected MethodInvocationStatistic _invocationStatistic;

	protected Separator fSeparator;

    public MethodInvocationDetails(Composite parent, SinglePatternTab tabItem) {
    	_toolkit = new HyadesFormToolkit(parent.getDisplay());
    	_form = _toolkit.createForm(parent);
    	_form.setText(TraceUIPlugin.getString("5"));
    	GridLayout gridLayout = new GridLayout();
    	gridLayout.marginLeft = gridLayout.marginRight = 0;
    	gridLayout.marginTop = gridLayout.marginBottom = 0;
    	_form.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
    	_form.getBody().setLayout(gridLayout);
    	_form.getBody().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
    	
    	fSeparator = new Separator();
    	_tabItem = tabItem;		

    	SashForm _sashForm = new SashForm(_form.getBody(), SWT.VERTICAL);
        _sashForm.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
        
        Composite composite = _toolkit.createComposite(_sashForm);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
    	_invocationGraph = new SinglePattern (composite, _tabItem, true);
    	_invocationStatistic = new MethodInvocationStatistic(_sashForm, _tabItem);
	}

	/**
	 * Handle the shell resized event.
	 */
	public Control getControl() {
		return _form;
	}
	
	/*
	 * This method handles a selection event
	 */
	public void refresh() {
		update();
	}
	
	/*
	 * This method handles a selection event
	 */
	public void selectionChanged() {
		
		_invocationStatistic.selectionChanged();
		_invocationGraph.selectionChanged();		
	}
	
	
	/**
	 * Called when the context menu is about to open.
	 * @see IFillMenuTarget#fillContextMenu
	 */
	public void menuAboutToShow(IMenuManager menu) {
		
		if(_invocationGraph.getCanvas() != null 
			&& _invocationGraph.getCanvas().getControl() != null
			&& _invocationGraph.getCanvas().getControl().isFocusControl())
		{
			_invocationGraph.menuAboutToShow(menu);
		}
		else
		{
			addInvocationStatisticMenu(menu);
		}
	}

	protected void addInvocationStatisticMenu(IMenuManager menu)
	{
		menu.add(fSeparator);

		menu.add(_invocationStatistic.getUpdateAction());
		
		menu.add(fSeparator);
		menu.add(_invocationStatistic.getChooseColumnsAction(_invocationStatistic.getColumnDataList(), _invocationStatistic.getColumnsPreferencesKey()));		
	}
	
	public void updateButtons() {
		
//		_tabItem.percentMode().setChecked(_invocationStatistic.isShowPercent());		
	}

	public void updateModelSelection() {
		
		ISelection selection = _invocationStatistic.getTreeViewer().getSelection();
		if(selection != null && !selection.isEmpty())
		{
			Object sel = ((IStructuredSelection)selection).getFirstElement();
			
			_invocationStatistic.notifyViewSelectionChanged(this,sel);
		}
		
	}
	
	public void dispose() {
		
		_invocationGraph.dispose();
		_invocationStatistic.dispose();
		
		_form.dispose();
		_toolkit.dispose();
	}

  protected void postUpdateEvents()
	{
	}		
	
	public boolean isEmpty()
	{
		int size = 0;
		ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(_tabItem.getMOFObject());
			
		if(selModel.size() > 0)
		{
			Object obj = selModel.getFirstElement();
			
			if(obj instanceof TRCMethod)
			{
				size = ((TRCMethod)obj).getInvocations().toArray().length;
			} 
			
			if(obj instanceof TRCMethodInvocation)
			{
				size =((TRCMethodInvocation)obj).getMethod().getInvocations().toArray().length;
			} 
		}

		return (!(size > 0));
		
	}
	
    protected String getViewTypeStr()
    {
    	return org.eclipse.hyades.trace.views.adapter.internal.TraceConstants.METHOD_INVOCATION_STATS_VIEW;
    }		
	
	public void update() {
		_invocationGraph.update(true);
		_invocationStatistic.refresh();
	}
	
	public void update(boolean redraw) {
		_invocationGraph.update(redraw);
		
		if(redraw)
			_invocationStatistic.updateUI(_invocationStatistic.getColumnDataList());

	}
	
	public void initialize() {
		_invocationGraph.initialize();
	} 
	
	public JCanvas getCanvas() {
		return _invocationGraph.getCanvas();
	}
	
	public void updateUI() {
	   _invocationGraph.updateUI();
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void zoomOut(boolean zoom) {
		
		_invocationGraph.zoomOut(zoom);
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void zoomIn(boolean zoom) {
		_invocationGraph.zoomIn(zoom);
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void previous() {
		_invocationGraph.previous();
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void next() {
		_invocationGraph.next();
	}

	/**
		 * Insert the method's description here.
		 * Creation date: (6/6/2001 5:21:34 PM)
		 */
		public void showCaller() {
			_invocationGraph.showCaller();
		}

	/**
		 * Insert the method's description here.
		 * Creation date: (6/6/2001 5:21:34 PM)
		 */
		public void showCallee() {
			
			_invocationGraph.showCallee();
			
		}

	/**
	 * Insert the method's description here.
	 * Creation date: (8/21/2001 6:31:49 PM)
	 */
	public void openSource() {
	
		OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(_tabItem.getMOFObject()).getFirstElement());
	
	}

	/**
	 * @return Returns the _invocationStatistic.
	 */
	public MethodInvocationStatistic getInvocationStatistic() {
		return _invocationStatistic;
	}
	/**
	 * @return Returns the _invocationGraph.
	 */
	public SinglePattern getInvocationGraph() {
		return _invocationGraph;
	}
}