/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MethodInvocationStatistic.java,v 1.37 2008/05/27 15:25:35 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.SinglePatternTab;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.CPUTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.CumulativeTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.InstanceNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodInvocationColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodInvocationEntryTimeColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;


public class MethodInvocationStatistic extends MultiLevelStatisticView
                                implements ITimeChangedListener

{
	protected String tmpString;
	protected SinglePatternTab _tabItem;	
	protected ContextInfoContainer _contextInfo;

	/**
	 * 
	 *
	 */
	public class ExecutionStatisticFilter extends StatisticFilter {

		public ExecutionStatisticFilter() {
			super();
		}

		public boolean select(Viewer viewer, Object parent, Object element) {
			
			boolean flag = true;
			
			if(!(element instanceof TRCMethodInvocation))
			  return true;
			  
			String compareText = "";
		   compareText = ((TRCMethodInvocation)element).getMethod().getName();
		   if(compareText.equals(""))
			 compareText = TraceUIMessages._87;
			
			if (_noPattern)
				return true;
			
			if (!_caseSensitive) {
				compareText = compareText.toLowerCase();
			}
			if (_exactMatch) {
				return compareText.compareTo(_prefix) == 0;
			}
			if (_prefix != "") {
				flag = compareText.startsWith(_prefix);
			}
			if (flag && _suffix != "") {
				flag = compareText.endsWith(_suffix);
			}
			if (flag) {
				for (int k = 0; k < _textList.size(); k++) {
					String str1 = (String) _textList.get(k);

					int index = compareText.lastIndexOf(str1);
					if (index == -1) {
						flag = false;
						break;
					}

					compareText = compareText.substring(index + str1.length());
				}
			}
			return flag;
		}
		
	}
	
	public class MethodStatisticSorter extends StatisticSorter {

		public MethodStatisticSorter() {
			super();
		}

		public int compare(Viewer viewer, Object e1, Object e2) {

				switch(_pos)
				{
					case 0://method name
						return _sortSequence * compareElements(e1, e2, _methodInvocationCol, false);
					case 1: //instances
						return _sortSequence * compareElements(e1, e2, _instanceNameCol, false);
					case 2: //base time
						return _sortSequence * compareElements(e1, e2, _methodInvocationEntryTimeCol, false);
					case 3: //cumulative time
						return _sortSequence * compareElements(e1, e2, _cumulativeTimeCol, false);						
					case 4: //cpu time
						return _sortSequence * compareElements(e1, e2, _CPUTimeCol, false);
				}				  				  				 				   				  
				
			
			return 0;
		}
		
	}

    /**
     * 
     */
	public class MethodStatisticContentProvider implements ITreeContentProvider {
		
		public void dispose() {
		}
		
		public Object getParent(Object element) {
			return null;
		}
		
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
		
		public Object[] getElements(Object inputElement)
		{
			tmpList.clear();
			ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(_page.getMOFObject());
			
			if(selModel.size() > 0)
			{
				Object obj = selModel.getFirstElement();
				
				if(obj instanceof TRCMethod)
				{
					Iterator iter = ((TRCMethod)obj).getInvocations().iterator();
					while (iter.hasNext()) {
						Object next = iter.next();
						if (next instanceof TRCFullMethodInvocation) {
							tmpList.add(next);
						}
					}
				} 
				else if(obj instanceof TRCMethodInvocation)
				{
					Iterator iter = ((TRCMethodInvocation)obj).getMethod().getInvocations().iterator();
					while (iter.hasNext()) {
						Object next = iter.next();
						if (next instanceof TRCFullMethodInvocation) {
							tmpList.add(next);
						}
					}
				} 
			}
			return tmpList.toArray();			
		}
				
		public Object[] getChildren(Object element)
		{
			tmpList.clear();			
			Object[] segments = ((TRCMethodInvocation)element).getInvokes().toArray();
			for(int idx=0; idx<segments.length; idx++) {
				if (segments[idx] instanceof TRCFullMethodInvocation) {
					tmpList.add(segments[idx]);
				}
			}
			return tmpList.toArray(); 	
		}
	
		public boolean hasChildren(Object element) {
			Iterator iter = ((TRCMethodInvocation)element).getInvokes().iterator();
			while (iter.hasNext()) {
				if (iter.next() instanceof TRCFullMethodInvocation) {
					return true;
				}
			}
			return false;
		}
	}

	
	 public class MethodStatisticCellLabelProvider extends StatisticCellLabelProvider {
 			public MethodStatisticCellLabelProvider(ColumnData colData) {
				super(colData);
 			}
			
			public void update(ViewerCell cell) {
				visualIndex = cell.getVisualIndex();
				cell.setText(((MethodStatisticLabelProvider)getTableLabelProvider()).getColumnText(cell.getElement(),visualIndex));
				cell.setImage(((MethodStatisticLabelProvider)getTableLabelProvider()).getColumnImage(cell.getElement(),visualIndex));
			}
 		}
	
    /**
     * 
     */
	public class MethodStatisticLabelProvider extends LabelProvider implements ITableLabelProvider
	{
		protected StatisticView _viewer;
		
		public MethodStatisticLabelProvider(StatisticView viewer) {
			super();
			_viewer = viewer;
		}
		
		public Image getColumnImage(Object obj, int col) {
				return null;
		}

		public String getColumnText(Object obj, int col) {
			
            int pos = StatisticTableColumnInfo.getStatisticTableColumnInfo(_viewer.getTree().getColumn(col)).getColumnData().getInitalPos();			
			
            //TRCMethodInvocation
				switch(pos)
				{
					case 0://method name
						return getElementColumnText(obj, _methodInvocationCol, false);
					case 1://instance name  
						return getElementColumnText(obj, _instanceNameCol, false);
					case 2://base time
						return getElementColumnText(obj, _methodInvocationEntryTimeCol, false);
					case 3: //cumulative time
						return getElementColumnText(obj, _cumulativeTimeCol, false);
					case 4://cpu time
						return getElementColumnText(obj, _CPUTimeCol, false);
				}
				
            							
			return "";
		}
	}
	
	private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.TIME_OPTION);

	class ExecutionTreeViewer extends TreeViewer {
		public ExecutionTreeViewer(Composite parent) {
			super(parent);
		}

		public ExecutionTreeViewer(Tree tree) {
			super(tree);
		}

		public void expandItem(TreeItem item) {
			item.setExpanded(true);
			createChildren(item);

		}

	}
	protected Composite createTree(Composite parent, int options) {
		return _toolkit.createTree(parent, options);
	}

	protected ColumnLabelAdapter _methodInvocationCol;
	protected ColumnLabelAdapter _instanceNameCol;
	protected ColumnLabelAdapter _methodInvocationEntryTimeCol;
	protected ColumnLabelAdapter _cumulativeTimeCol;
	protected ColumnLabelAdapter _CPUTimeCol;
	
	public MethodInvocationStatistic(Composite parent, SinglePatternTab tabItem) {
		super(true, parent, tabItem.getPage());
		_tabItem = tabItem;
		
		createColumnsLabelProviders();
		_viewerFilter = new StatisticFilter();				
		
		TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
		_viewerFilter = new ExecutionStatisticFilter();		
	}
	
	protected String getContextHelpId()
	{
		return TraceUIPlugin.getPluginId()+".mthi0000";
	}
	
	public void createColumnsLabelProviders()
	{
		_methodInvocationCol = new MethodInvocationColumnLabel();
		_instanceNameCol =  new InstanceNameColumnLabel();
		_methodInvocationEntryTimeCol = new MethodInvocationEntryTimeColumnLabel();
		_cumulativeTimeCol = new CumulativeTimeColumnLabel();
		_CPUTimeCol = new CPUTimeColumnLabel();	
	}
	
	/**
	 * getClassColumnsPerferencesKey returns the string key used to find the
	 * column preferences information in the preferences store.
	 * @return java.lang.String key name
	 */
	public String getColumnsPreferencesKey() {
		// Note this string is not to be translated and must be changed whenever the 
		// default columns template is changed by adding, removing or renaming columns.
		// Changing the version will result in the default preferences being used.
		return "MInv51"; 
		
	}
	
	public String getDefaultColumnsTemplate() {
				
		//Class Columns Data
		String executionColumn =
			      IContextAttributes.METHOD_INVOCATIONS			+ ":0:"
				+ String.valueOf(ColumnData.NONDELETABLE | ColumnData.IS_VISIBLE | ColumnData.NONMOVABLE) + ":left:200,"
			    + IContextAttributes.OBJECT_NAME 		+ ":1:"
			  	+ String.valueOf(ColumnData.IS_VISIBLE) + ":left:200,"					 	
			  	+ IContextAttributes.METHOD_START_TIME			  	+ ":2:" 
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":right:100,"
				+ IContextAttributes.METHOD_CUMULATIVE_TIME		+ ":3:"
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":right:100,"
				+ IContextAttributes.METHOD_AVG_BASE_TIME	+ ":4:"
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":right:100";
				
		return executionColumn;
	}

	public IContentProvider getContentProvider() {
		return new MethodStatisticContentProvider();
	}
	
	public CellLabelProvider getCellLabelProvider(ColumnData colData) {
		return new MethodStatisticCellLabelProvider(colData);
	}
	
	public LabelProvider getTableLabelProvider()
	{
		return new MethodStatisticLabelProvider(this);
	}
	

	public Tree getTree() {
		return (Tree) getTreeViewer().getControl();
	}

	protected TreeViewer getTreeViewer(Tree tree)
	{
		return new ExecutionTreeViewer(tree);
	}	
	
	protected void doHandleSelectionEvent(boolean isPostponedOperation, int processedOperations) {
	if (_page.getTraceViewer().isFPartVisible()) {
		
			Control tree = (Tree) getTreeViewer().getControl();	
			if((!isPostponedOperation || (processedOperations & LAZY_UPDATE) == 0) 
					&& tree != null && !tree.isDisposed() && !tree.isFocusControl())
			{			
				update();	
			}
	}
	else {
		_page.getTraceViewer().setFRefreshView(true);
	}
	
		ITraceSelection model =
			UIPlugin.getDefault().getSelectionModel(_page.getMOFObject());
		if (model.size() > 0) {
			Object sel = model.getFirstElement();
			if (sel != null && sel instanceof EObject)
					updateStatusContext(ContextManager.getContextLanguage(ContextUpdaterHelper.getContext((EObject)sel)));
		}

	}

	/**
	 * Called when the context menu is about to open.
	 * @see IFillMenuTarget#fillContextMenu
	 */
	public void menuAboutToShow(IMenuManager menu) {
		menu.add(fSeparator);

		menu.add(getUpdateAction());
		
		menu.add(fSeparator);
		menu.add(getChooseColumnsAction(getColumnDataList(), getColumnsPreferencesKey()));
	}

	protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
		if (_tabItem.percentMode() != null)
			_tabItem.percentMode().setChecked(isShowPercent());		
	}

	protected void updateDetailsPane() {
		int selCount = getTree().getSelectionCount();
		if (selCount != 1) {
			return;
		}

		Item item = getTree().getSelection()[0];
		Object itemData = item.getData();

		if (itemData == null) {
			return;
		}
		if (itemData != null && itemData instanceof TreeItem) {
			itemData = ((TreeItem) itemData).getData();
		}
	}

	public void updateModelSelection() {
		ISelection selection = getTreeViewer().getSelection();
		if(selection != null && !selection.isEmpty())
		{
			Object sel = ((IStructuredSelection)selection).getFirstElement();
			
			notifyViewSelectionChanged(this,sel);
		}
	}
	
	public void dispose() {
		
		super.dispose();
	    TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
		
	}

  public void handleTimeChangedEvent()
  {		
  	    Action base = _tabItem.baseTime();
  	    Action raw = _tabItem.rawTime();
	    _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.TIME_OPTION);
	    if(base != null)
	      base.setChecked(_drawMode == TraceConstants.COMPENSATED_TIME);
	    if(raw != null)
	      raw.setChecked(_drawMode == TraceConstants.RAW_TIME);
	    
	    
	    String oldKey;
	    String newKey;
	    if (_drawMode == TraceConstants.COMPENSATED_TIME)
	    	newKey = IContextAttributes.METHOD_CUMULATIVE_TIME;
	    else
	    	newKey = IContextAttributes.METHOD_RAW_CUMULATIVE_TIME;
	    
	    if (newKey.equals(IContextAttributes.METHOD_CUMULATIVE_TIME))
	    	oldKey = IContextAttributes.METHOD_RAW_CUMULATIVE_TIME;
	    else
	    	oldKey = IContextAttributes.METHOD_CUMULATIVE_TIME;
	    
	
		Tree tree = getTree();	
		for (int idx = tree.getColumnCount(); idx > 0; idx--)
		{
			TreeColumn col = tree.getColumn(idx-1);
			StatisticTableColumnInfo staticTblColInfo = (StatisticTableColumnInfo)(col.getData());
			String columnKey = staticTblColInfo.getColumnData().key();	
			if(columnKey.equals(oldKey) )
			{
				staticTblColInfo.getColumnData().key(newKey);
				String newName = staticTblColInfo.getColumnData().name();
			    if(staticTblColInfo.isSortColumn())
			    {
			    	newName = col.getText().substring(0, 1) + newName; 
			    }			   	
 			   	col.setText(newName);
			}
		}
	
		getTreeViewer().refresh();
  }

  
	protected StatisticSorter getViewerSorterInstance()
	{
		return new MethodStatisticSorter();
	}
	
	protected void postUpdateEvents()
	{
	}		
	
	protected boolean isHandleSelectionEventNeeded(Object source) {
		return !(source instanceof MethodInvocationStatistic)
					&& !(source instanceof SinglePattern);
	}

	protected void doHandleViewSelectionChangedEvent(ViewSelectionChangedEvent event, boolean isPostponedOperation, int processedOperations)
	{
		Object  source = event.getSource();
		if(!(source instanceof MethodInvocationStatistic)
			&& !(source instanceof SinglePattern))
		{	  
			handleSelectionEvent();
						
		}
		else
		{
			ITraceSelection model =
				UIPlugin.getDefault().getSelectionModel(_page.getMOFObject());
			if (model.size() > 0) {
				Object sel = model.getFirstElement();
				if (sel != null && sel instanceof EObject)
						updateStatusContext(ContextManager.getContextLanguage(ContextUpdaterHelper.getContext((EObject)sel)));
			}
		}

	}
	
	public boolean isEmpty()
	{
		int size = 0;
		ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(_page.getMOFObject());
			
		if(selModel.size() > 0)
		{
			Object obj = selModel.getFirstElement();
			
			if(obj instanceof TRCMethod)
			{
				size = ((TRCMethod)obj).getInvocations().toArray().length;
			} 
			
			if(obj instanceof TRCMethodInvocation)
			{
				size =((TRCMethodInvocation)obj).getMethod().getInvocations().toArray().length;
			} 
		}

		return (!(size > 0));
		
	}
	
    protected String getViewTypeStr()
    {
    	return org.eclipse.hyades.trace.views.adapter.internal.TraceConstants.METHOD_INVOCATION_STATS_VIEW;
    }		

//	protected void showPercentUpdate()
//	{
////		if(isShowPercent())
////		{
////			_maxTime = PerftraceUtil.getMaximumTime(_page.getMOFObject());
////			if (_maxTime==0)_maxTime=1;				
////			
////			_totalPackageCPUtime = 1;
////			if (_totalPackageCPUtime==0) _totalPackageCPUtime=1;			
////		}		
//		
//		_methodInvocationBaseTimeCol.update(IUpdateAttributes.SHOW_PERCENTAGE, new Boolean(isShowPercent()));
//		_methodInvocationBaseTimeCol.update(IUpdateAttributes.MAX_TIME, new Double(_maxTime));
//
//		_cumulativeTimeCol.update(IUpdateAttributes.SHOW_PERCENTAGE, new Boolean(isShowPercent()));
//		_cumulativeTimeCol.update(IUpdateAttributes.MAX_TIME, new Double(_maxTime));
//
//		_CPUTimeCol.update(IUpdateAttributes.SHOW_PERCENTAGE, new Boolean(isShowPercent()));
//		_CPUTimeCol.update(IUpdateAttributes.MAX_TIME, new Double(1));
//	}
    
	protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn)
	{
		if (col == _cumulativeTimeCol)
			return ContextUpdaterHelper.updateCumulTime(col, isDeltaColumn, isShowPercent(), getDrawMode(), _totalCumulativeTime);			
		else if (col == _CPUTimeCol)
			return ContextUpdaterHelper.updateCPUTime(col, isDeltaColumn, isShowPercent(), 1);			
		else
			return super.getColumnDisplayInfo(col, isDeltaColumn);		
	}    
    
	/**
	 * @return Returns the _drawMode.
	 */
	public int getDrawMode() {
		return _drawMode;
	}
	/**
	 * @param mode The _drawMode to set.
	 */
	public void setDrawMode(int mode) {
		_drawMode = mode;
	}
	
	protected Composite createControl(Composite parent, ArrayList cols) {
		final Composite vc = super.createControl(parent, cols);
		
		_contextInfo = new ContextInfoContainer();
		_contextInfo.setViewer((IContextViewer)_page.getTraceViewer());
		_contextInfo.createControl(vc);
		_contextInfo.addContextInfoContainerListener(
				new IContextInfoContainerListener()
				{
					public void visibilityChanged(boolean isVisible)
					{
						vc.layout(true, true);
					}
				});

		return vc;
	}
	
	protected void updateStatusContext(IContextLanguage language)
	{
		if (_contextInfo != null)
			_contextInfo.updateStatusContext(language);
	}
	
    protected void firstTimeUpdate() {        
        super.firstTimeUpdate();
        redrawTable();
    }
    
    public void redrawTable() {
        getTree().setRedraw(false);

        ArrayList list = ColumnData.createColumnData(getColumnsPreferencesKey(), getDefaultColumnsTemplate());
        resetColumns(list);
        _currentColumns = list;
        getTree().setRedraw(true);
        
        refresh();
    }
	
	protected void doUpdate(boolean refresh, boolean isPostponedOperation, int processedOperations) {
		resetColumms();
		
		if( _page instanceof ExecutionStatisticPage2) {
			if (_contextInfo != null)
				_contextInfo.setMOFObject(_page.getMOFObject());
		}
		
		super.doUpdate(refresh, isPostponedOperation, processedOperations);
	}
	
	protected void resetColumms()
	{
		_methodInvocationCol.resetMap();
		_instanceNameCol.resetMap();
		_methodInvocationEntryTimeCol.resetMap();
		_cumulativeTimeCol.resetMap();
		_CPUTimeCol.resetMap();		

	}

	protected String getDefaultColumnsTemplateClassLevel() {
		// do nothing
		return null;
	}

	protected String getDefaultColumnsTemplatePackageLevel() {
		// do nothing
		return null;
	}

	protected StatisticFilter getFilterInstance() {
		return new ExecutionStatisticFilter();
	}

	public int getLevel() {
		// do nothing
		return 0;
	}

	public boolean isEmptyUpdate() {
		// do nothing
		return false;
	}

	public void setLevel(int i) {
		// do nothing
	}
}