/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MultiLevelStatisticMethodView.java,v 1.3 2008/04/22 17:33:08 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class MultiLevelStatisticMethodView extends MultiLevelStatisticView {

	public static final int METHOD_LEVEL = 3;
	
	protected abstract String getDefaultColumnsTemplateMethodLevel();
	
	public MultiLevelStatisticMethodView(Composite parent, TraceViewerPage page, boolean initializeContent){
		this(false, parent, page, initializeContent);
	}
	
	public MultiLevelStatisticMethodView(Composite parent, TraceViewerPage page){
		this(false, parent, page, true);
	}	

	public MultiLevelStatisticMethodView(boolean lazyMode, Composite parent, TraceViewerPage page, boolean initializeContent){
		super(lazyMode, parent, page, initializeContent);
	}
	
	public MultiLevelStatisticMethodView(boolean lazyMode, Composite parent, TraceViewerPage page){
		this(lazyMode, parent, page, true);
	}
	
	protected void searchInLevel(Tree tree,
			TreeItem item,
			TRCPackage pack,
			TRCClass cls,
			TRCMethod meth,
			TRCObject trcObj)
	{
		super.searchInLevel(tree, item, pack, cls, meth, trcObj);
		
		switch (getLevel()) {
			case METHOD_LEVEL :
				if (meth != null)
					searchInMethodLevel(tree, item, meth);
				break;
		}
	}
	
	public String getDefaultColumnsTemplate()
	{	
		String columns = super.getDefaultColumnsTemplate();
		
		if (columns == null && getLevel() == METHOD_LEVEL)
		{
			columns = getDefaultColumnsTemplateMethodLevel();
		}
	
		return columns;
	}
}
