/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Pattern.java,v 1.8 2008/04/22 17:33:08 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.PatternPage;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
* CONTEXT_ID osrc0000 for open java source action
*/
/*
* CONTEXT_ID exef0008 for exection flow view
*/

public class Pattern extends AbstractLazyHandler
	implements
		ControlListener,
		ITimeChangedListener,
		ISelectionProvider,
		IViewSelectionChangedListener
{
	protected final float MAG_STEP = 2;
	protected Label _status;
	protected JCanvas _canvas;
	protected PatternDrawStrategy _curDS;
	protected PatternDrawStrategy _patDS;
	protected boolean _initialized = false;
	protected PatternPage _page;
	protected Composite viewContainer;
	protected ViewForm dataPane;
	protected Composite viewComp;
	protected Action _updateAction;
	protected Action _openColorDialog;
	protected Separator fSeparator;

	//-------------------------------
	// UpdateAction popup action
	//-------------------------------
	class UpdateAction extends Action {
		public UpdateAction(String name) {
			super(name);
			PDPluginImages.setImageDescriptors(
				this,
				PDPluginImages.T_LCL,
				PDPluginImages.IMG_UPDATEVIEWS);
		}

		/**
		 * Invoked when an action occurs.
		* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			ProfileEvent event = UIPlugin.getDefault().getRefreshViewEvent(_page.getMOFObject());
			UIPlugin.getDefault().notifyProfileEventListener(event);												
		}
	}

	//-------------------------------
	// Open Color Dialog popup action
	//-------------------------------
	class OpenColorDialog extends Action {
		public OpenColorDialog(String name) {
			super(name);
			TracePluginImages.setImageDescriptors(
				this,
				TracePluginImages.T_TOOL,
				TracePluginImages.IMG_COLORS);

		}

		/**
		 * Invoked when an action occurs.
		* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			GraphColorDialog dialog =
				new GraphColorDialog(
					viewContainer.getShell(),
					TraceUIMessages._97,
					null);
			dialog.open();
		}
	}

	public Pattern(Composite parent, PatternPage page) {
		this(parent, page, false);
	}

	public Pattern(Composite parent, PatternPage page, boolean lazyMode) {
		super(lazyMode);
		_page = page;

		createControl(parent);

		_updateAction = new UpdateAction(UIPlugin.getResourceString("REFRESH_VIEWS"));
		_openColorDialog =
			new OpenColorDialog(TraceUIMessages._98);

        fSeparator = new Separator();
        
		TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
		UIPlugin.getDefault().addViewSelectionChangedListener(this);

	}

	public PatternPage getPage() {
		return _page;
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 2:57:06 PM)
	 */
	public void close() {
		viewContainer.dispose();
		_page.dispose();
	}
	public void controlMoved(org.eclipse.swt.events.ControlEvent e) {
	}
	public void controlResized(org.eclipse.swt.events.ControlEvent event) {
		resizeContent();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (06/14/2000 3:36:09 PM)
	 * @return org.eclipse.swt.widgets.Control
	 * @param parent org.eclipse.swt.widgets.Composite
	 */
	public void createControl(Composite parent) {
		GridLayout layout;

		viewContainer = new Composite(parent, SWT.BORDER);
		layout = new GridLayout();
		layout.numColumns = 1;
		viewContainer.setLayout(layout);
		viewContainer.setLayoutData(GridUtil.createFill());

		viewComp = new Composite(viewContainer, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		viewComp.setLayout(layout);
		viewComp.setLayoutData(GridUtil.createFill());

		dataPane = new ViewForm(viewComp, SWT.NULL);
		dataPane.setLayoutData(GridUtil.createFill());

		_canvas = new JCanvas(dataPane, SWT.H_SCROLL | SWT.V_SCROLL, 10);
		dataPane.setContent(_canvas.canvas());

		viewContainer.addControlListener(this);

		_status = new Label(viewContainer, SWT.BORDER);
		_status.setLayoutData(GridUtil.createHorizontalFill());

		PlatformUI.getWorkbench().getHelpSystem().setHelp(
			parent,
			TraceUIPlugin.getPluginId() + ".exef0008");

	}
	public void dispose() {
		
		TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
		UIPlugin.getDefault().removeViewSelectionChangedListener(this);

		if (_patDS != null)
			_patDS.shutdown();

		_page = null;
		_patDS = null;
		_curDS = null;
		
		if(_canvas != null)
		   _canvas.dispose();
		   
		_canvas = null;
		
		if(dataPane != null)
			dataPane.dispose();
		dataPane = null;
		
		if(viewComp != null)
			viewComp.dispose();
		viewComp = null;	
		
		if(viewContainer != null)
			viewContainer.dispose();
		viewContainer = null;	
		
		_updateAction = null;
		_openColorDialog = null;
		
	}
	/**
	 * This method should fill (or update) the given menu. It is called just before
	 * the menu opens.
	 */
	public void fillContextMenu(IMenuManager menu) {
		menu.add(_updateAction);
				
		menu.add(_openColorDialog);
		menu.add(fSeparator);

		_canvas.fillContextMenu(menu);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/10/2001 2:33:22 PM)
	 * @return org.eclipse.swt.widgets.Control
	 */
	public Control getControl() {
		return viewContainer;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (06/15/2000 3:55:00 PM)
	 */
	public void initialize() {
		if (_initialized)
			return;

		_initialized = true;

		initStrategies();

		setDrawStrategy(_patDS);

		updateTitle();
	}
	private void initStrategies() {
		_patDS = new PatternDrawStrategy(this);
	}
		/**
	 * Called when the context menu is about to open.
	 * @see IFillMenuTarget#fillContextMenu
	 */
	public void menuAboutToShow(IMenuManager menu) {
		fillContextMenu(menu);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/21/2001 6:31:49 PM)
	 */
	public void openSource() {

		OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(_page.getMOFObject()).getFirstElement());

	}

	/**
	 * Insert the method's description here.
	 * Creation date: (10/17/2000 2:08:36 PM)
	 */
	public void resizeContent() {
		/* Get the client area for the shell */
		Rectangle viewContainerBounds = viewComp.getClientArea();

		/*
		* Make list 2 half the width and half the height of the tab leaving room for the sash.
		* Place list 2 in the top right quadrant of the tab.
		*/
		dataPane.setBounds(
			viewContainerBounds.x,
			viewContainerBounds.y,
			viewContainerBounds.width,
			viewContainerBounds.height);
	}
	private void setDrawStrategy(PatternDrawStrategy ds) {

		if (_curDS != null) {
			_curDS.jcanvas(null);
		}

		_curDS = ds;
		_curDS.jcanvas(_canvas);

		_canvas.setDrawStrategy(_curDS);
		_canvas.zoomToFit();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 2:57:06 PM)
	 */
	public void update() {
		super.update(true);
	}
	
	protected void doUpdate(boolean redraw, boolean isPostponedOperation, int processedOperations) {
		if(!isPostponedOperation || (processedOperations & LAZY_UPDATE) == 0){
			_canvas.zoomToFill(1f, 1000f);
			_canvas.redraw();
		}
	}

	protected void updateStatus(String status)
	{	
		if(status.equals(_status.getText()))
		   return;	
		
		_status.setText(status);
	}
	protected void updateTitle() {
		dataPane.setToolTipText(_curDS.title());
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 2:57:06 PM)
	 */
	public void updateUI() {
		super.updateUI();
	}
	
	protected void doUpdateUI(boolean isPostponedOperation, int processedOperations) {
		if(!isPostponedOperation || (processedOperations & LAZY_UPDATE) == 0){
			_canvas.zoomToFill(1f, 1000f);
			_canvas.redraw();
		}
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 2:57:06 PM)
	 */
	public void zoomIn(boolean zoom) {
		initialize();

		_canvas.isZoomIn(zoom);
		_canvas.zoomIn();

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 2:57:06 PM)
	 */
	public void zoomOut(boolean zoom) {
		initialize();

		_canvas.isZoomOut(zoom);
		_canvas.zoomOut();
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (9/21/2001 4:00:57 PM)
	 */
	public void updateButtons() {
		super.updateButtons();
	}
	
	protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
	}

	public void handleTimeChangedEvent() {
		Action base = ((PatternPage) _page).baseTime();
		Action raw = ((PatternPage) _page).rawTime();
		int ref =
			TraceUIPlugin.getDefault().getPreferenceStore().getInt(
				TraceConstants.TIME_OPTION);
		if (base != null)
			base.setChecked(ref == TraceConstants.COMPENSATED_TIME);
		if (raw != null)
			raw.setChecked(ref == TraceConstants.RAW_TIME);

		if (_patDS != null)
			_patDS.setDrawMode(ref);
	}

	/*
	 * This method handles a selection event
	 */
	public void refresh() {
		super.refresh();
	}
	
	protected void doRefresh(boolean isPostponedOperation,
			int processedOperations) {
		if (_patDS != null && _canvas != null && !_canvas.canvas().isDisposed() && _canvas.canvas().isVisible()) {
			_patDS.redraw();
		}
	}

	/*
	 * This method handles a selection event
	 */
	public void selectionChanged() {
		handleSelectionEvent();
	}
	
	protected void doHandleSelectionEvent(boolean isPostponedOperation,
			int processedOperations) {
		if ((!isPostponedOperation || 
				(processedOperations & 
						(LAZY_UPDATE 
								| LAZY_UPDATE_UI)) == 0)
				&& _canvas != null && !_canvas.canvas().isDisposed() && _canvas.canvas().isVisible() && !_canvas.canvas().isFocusControl()) {
			_canvas.redraw();
			
		}
	}


	/**
	 * Adds a listener for selection changes in this selection provider.
	 * Has no effect if an identical listener is already registered.
	 *
	 * @param listener a selection changed listener
	 */
	public void addSelectionChangedListener(ISelectionChangedListener listener)
	{
	}
	/**
	 * Returns the current selection for this provider.
	 * 
	 * @return the current selection
	 */
	public ISelection getSelection()
	{
		if(_page == null)
		  return new StructuredSelection();
		  
		Object selection = UIPlugin.getDefault().getSelectionModel(_page.getMOFObject()).getFirstElement();
		
		if(selection != null)		
			return new StructuredSelection(selection);
			
	    return new StructuredSelection();
	}
	/**
	 * Removes the given selection change listener from this selection provider.
	 * Has no affect if an identical listener is not registered.
	 *
	 * @param listener a selection changed listener
	 */
	public void removeSelectionChangedListener(ISelectionChangedListener listener)
	{
	}
	/**
	 * Sets the current selection for this selection provider.
	 *
	 * @param selection the new selection
	 */
	public void setSelection(ISelection selection)
	{
	}

	/**
	 * @return
	 */
	public JCanvas getCanvas() {
		return _canvas;
	}
	
	public boolean isEmpty()
	{
		if ((_patDS._visibleThreads.size() > 0) || (_curDS._visibleThreads.size() > 0))
		{
			return false;
		}
		return true;
	

	}
	
	/* bug 68873 */
	public void openExecutionStatisticView() 
	{
		IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
				
		try
		{
			IWorkbenchPage persp = UIPlugin.getActivePage();     
			persp.showView("org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer");	 					 
		}
		catch(Exception e)
		{
			String msg = TraceUIMessages._100;                 
		
			Status err = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, e.toString(), null ); 
		
			ErrorDialog.openError(window.getShell(),
					msg,
					"", // no special message
					err);
			
			e.printStackTrace();    
		}		
	}

	public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
		super.handleViewSelectionChangedEvent(event);
	}

	protected void doHandleViewSelectionChangedEvent(
			ViewSelectionChangedEvent event, boolean isPostponedOperation, int processedOperations) {
		Object  source = event.getSource();
		if(!(source instanceof Pattern)){	  
			selectionChanged();  
		}
	}
	
	protected boolean isHandleSelectionEventNeeded(Object source){
		return !(source instanceof Pattern);
	}

}