/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReferenceTable.java,v 1.37 2010/12/08 18:45:43 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.loaders.trace.ISnapshot;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCPrimitiveType;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.ReferenceTablePage;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ClassNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.InstanceNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.NumberReferencesColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.PackageNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ReferenceDetailColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ReferenceSizeColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.IFTRCClass;
import org.eclipse.hyades.trace.views.util.internal.IFTRCObject;
import org.eclipse.hyades.trace.views.util.internal.IRefChangedListener;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ReferenceTable
	extends StatisticView
	implements IRefChangedListener
{
	private static boolean USE_NEW_FILTERING_FOR_GET_REF = false;
	private static boolean USE_NEW_FILTERING_FOR_GET_CHILDREN = false;	
	protected ContextInfoContainer _contextInfo;
	

	public class ClassStatisticFilter extends StatisticFilter {

		public ClassStatisticFilter() {
			super();
		}


		public boolean select(Viewer viewer, Object parent, Object element) {
			
			boolean flag = true;
			if(!(element instanceof TRCClass))
			  return true;
						
			String compareText = "";
			
			if (_noPattern)
				return true;
			
			if(element instanceof TRCClass)   
			   compareText = ((TRCClass)element).getName();
			   
			if (!_caseSensitive) {
				compareText = compareText.toLowerCase();
			}
			if (_exactMatch) {
				return compareText.compareTo(_prefix) == 0;
			}
			if (_prefix != "") {
				flag = compareText.startsWith(_prefix);
			}
			if (flag && _suffix != "") {
				flag = compareText.endsWith(_suffix);
			}
			if (flag) {
				for (int k = 0; k < _textList.size(); k++) {
					String str1 = (String) _textList.get(k);

					int index = compareText.lastIndexOf(str1);
					if (index == -1) {
						flag = false;
						break;
					}

					compareText = compareText.substring(index + str1.length());
				}
			}
			return flag;
		}
		
	}
	
	protected int	_drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION);
	
	public class ObjReferenceSorter extends StatisticSorter {

		public ObjReferenceSorter() {
			super();
		}

		public int compare(Viewer viewer, Object e1, Object e2) {

			if (e1 instanceof TRCClass) {
				switch (_pos) {
					case 0 : //class name
						return _sortSequence * compareElements(e1, e2, _classNameCol, false);
					case 1 : //package name
						return _sortSequence * compareElements(e1, e2, _packageNameCol, false);						
					case 2 : //ref size
						return _sortSequence * compareElements(e1, e2, _refSizeCol, false);
					case 3 : //nb of references
						return 0;
				}
			}
			else if(e1 instanceof TRCHeapObject)
			{
				//TRCObject
				switch (_pos) {
					case 0 : //object name
						return _sortSequence * compareElements(e1, e2, _instanceNameCol, false);
					case 1 : //package name
						return _sortSequence * compareElements(e1, e2, _packageNameCol, false);						
					case 2 : //ref size
						return _sortSequence * compareElements(e1, e2, _refSizeCol, false);				
					case 3 : //nb of references
						return _sortSequence * compareElements(e1, e2, _numRefsCol, false);
					case 4 :
						return 0;
				}
			}
			else //TRCAggregatedObjectReference
			{			
				switch (_pos) {
						case 0 : //object name
							return _sortSequence * compareElements(e1, e2, _instanceNameCol, false);
						case 1 : //package name
							return _sortSequence * compareElements(e1, e2, _packageNameCol, false);
						case 2 : //ref size
							return _sortSequence * compareElements(e1, e2, _refSizeCol, false);
						case 3 : //nb of references
							return _sortSequence * compareElements(e1, e2, _numRefsCol, false);
						case 4 : //nb of instances for this reference
							return _sortSequence * compareElements(e1, e2, _numRefsInstCol, false);
				}
			}

			return 0;
		}

	}

	public class ObjReferenceContentProvider
		implements ITreeContentProvider {

		public void dispose() {
		}

		public Object getParent(Object element) {
			
			if(element instanceof TRCClass)
			  return null;
			  
			if(element instanceof TRCHeapObject)
			   return ((TRCHeapObject)element).getIsA();  
			  
			return null;
		}

		public void inputChanged(
			Viewer viewer,
			Object oldInput,
			Object newInput) {
		}

		public Object[] getElements(Object inputElement) {
			
				List classes = FilteringUtil.getFilteredClasses(getCurrentFilter(), FilteringUtil.getProcessList(_page.getMOFObject()));
				
				Object[] elements = new Object[classes.size()];// + objects.size()];
				
				int i;
				for (i = 0; i < classes.size(); i++)
					elements[i] = new MyTRCClassData((TRCClass) classes.get(i));
				
				return elements;
		}
		
		private EList getRef(TRCHeapObject obj)
		{
			if (USE_NEW_FILTERING_FOR_GET_REF)		
			{
				EList eList = new BasicEList();
				if (showReferTo())
					eList.addAll(FilteringUtil.getFilteredObjectReferences(getCurrentFilter(), obj, false));
				else
					eList.addAll(FilteringUtil.getFilteredObjectReferences(getCurrentFilter(), obj, true));
				
				return eList;
			}
			else
			{
				if (showReferTo())
					return obj.getRefTarget();
				else
					return obj.getRefOwner();
			}
		}
		
		private TRCHeapObject getHeapObject(TRCObjectReference obj)
		{
			if (showReferTo())
				return obj.getOwner();
			else
				return obj.getTarget();
		}		

		public Object[] getChildren(Object element) {
			tmpList.clear();
			
			if (element instanceof TRCClass)
			{
				if (USE_NEW_FILTERING_FOR_GET_CHILDREN)		
				{
					TRCHeapObject obj = null;
					Object[] classObjects;
					
					if (element instanceof MyTRCClassData)
						classObjects = FilteringUtil.getFilteredHeapObjects(getCurrentFilter(), ((MyTRCClassData)element).getTRCClass(), true).toArray();
					else
						classObjects = FilteringUtil.getFilteredHeapObjects(getCurrentFilter(), (TRCClass)element, true).toArray();
					
					for(int idx=0; idx<classObjects.length; idx++)
					{
						TRCObject tmpObject = (TRCObject)classObjects[idx];						
						if(tmpObject instanceof TRCHeapObject)
						{
							obj = (TRCHeapObject)tmpObject;
							break;							
						}
					}
						
					if(obj != null && getRef(obj).size() > 0)
					  tmpList.add(obj);
					
					Object[] objects; 

					if (element instanceof MyTRCClassData)
						objects = FilteringUtil.getFilteredHeapObjects(getCurrentFilter(), ((MyTRCClassData)element).getTRCClass()).toArray();
					else
						objects = FilteringUtil.getFilteredHeapObjects(getCurrentFilter(), (TRCClass)element).toArray();
					
					for(int idx=0; idx<objects.length; idx++)
					{
						TRCObject tmpObject = (TRCObject)objects[idx];
						if(tmpObject instanceof TRCHeapObject)
						{
							if(getRef((TRCHeapObject)tmpObject).size() > 0)//obj.getIsA() == element &&
							   tmpList.add(tmpObject);							
						}
					}				
				}
				else
				{
					TRCHeapObject obj = null;
					Object[] classObjects = ((TRCClass) element).getClassObjects().toArray();
					for(int idx=0; idx<classObjects.length; idx++)
					{
						TRCObject tmpObject = (TRCObject)classObjects[idx];						
						if(tmpObject instanceof TRCHeapObject)
						{
							obj = (TRCHeapObject)tmpObject;
							break;							
						}
					}
						
					if(obj != null && getRef(obj).size() > 0)
					  tmpList.add(obj);
					
					Object[] objects = ((TRCClass) element).getObjects().toArray();
					for(int idx=0; idx<objects.length; idx++)
					{
						TRCObject tmpObject = (TRCObject)objects[idx];
						if(tmpObject instanceof TRCHeapObject)
						{
							if(getRef((TRCHeapObject)tmpObject).size() > 0)//obj.getIsA() == element &&
							   tmpList.add(tmpObject);							
						}
					}
				}
				
			}
			else if(element instanceof TRCHeapObject)
			{
				tmpList.addAll(getRef((TRCHeapObject)element));
			}
			else //TRCAggregatedObjectReference
			{
				tmpList.addAll(getRef(getHeapObject((TRCObjectReference)element)));
			}				
			
			return tmpList.toArray();
		}

		public boolean hasChildren(Object element) {
				if (FilteringUtil.USE_ENGINE_FOR_HAS_CHILDREN)
					return getChildren(element).length > 0;
				else
					return true;
		}
	}

	
	public class ObjReferenceCellLabelProvider  extends StatisticCellLabelProvider {
		public ObjReferenceCellLabelProvider(ColumnData colData) {
			super(colData);
		}
		
		public void update(ViewerCell cell) {
			visualIndex = cell.getVisualIndex();
			cell.setText(((ObjReferenceLabelProvider)getTableLabelProvider()).getColumnText(cell.getElement(),visualIndex));
			cell.setImage(((ObjReferenceLabelProvider)getTableLabelProvider()).getColumnImage(cell.getElement(),visualIndex));
		}
	}
	
	public class ObjReferenceLabelProvider
		extends LabelProvider
		implements ITableLabelProvider {
		protected StatisticView _viewer;

		public ObjReferenceLabelProvider(StatisticView viewer) {
			super();
			_viewer = viewer;
		}

		public Image getColumnImage(Object obj, int col) {
			return null;
		}

		public String getColumnText(Object obj, int col) {

			int pos =
				StatisticTableColumnInfo
					.getStatisticTableColumnInfo(
						_viewer.getTree().getColumn(col))
					.getColumnData()
					.getInitalPos();

			if (obj instanceof TRCClass) {
				switch (pos) {
					case 0 : //class name
						return getElementColumnText(obj, _classNameCol, false);
					case 1 : //package name
						return getElementColumnText(obj, _packageNameCol, false);
					case 2 : //ref size
						return getElementColumnText(obj, _refSizeCol, false);
					case 3 : //nb of references
						return "";

				}
			}
			
			else if(obj instanceof TRCHeapObject)
			{
				switch (pos) {
					case 0 : //object name
						return getElementColumnText(obj, _instanceNameCol, false);
						case 1 : //package name
							return getElementColumnText(obj, _packageNameCol, false);					
						case 2 : //ref size
							return getElementColumnText(obj, _refSizeCol, false);
						case 3 : //nb of references
							return getElementColumnText(obj, _numRefsCol, false);
						case 4 :
							return "";
				}
			}
			else //TRCObjectReference
			{
				switch (pos) {
					case 0 : //object name
						return getElementColumnText(obj, _instanceNameCol, false);
					case 1 : //package name
						return getElementColumnText(obj, _packageNameCol, false);
					case 2 : //ref size
						return getElementColumnText(obj, _refSizeCol, false);
					case 3 : //nb of references
						return getElementColumnText(obj, _numRefsCol, false);
					case 4 : //nb of instances for this reference
						return getElementColumnText(obj, _numRefsInstCol, false);			
				}				
			}

			return "";
		}
	}
	
	class ReferenceTreeViewer extends TreeViewer {
		public ReferenceTreeViewer(Composite parent) {
			super(parent);
		}

		public ReferenceTreeViewer(Tree tree) {
			super(tree);
		}

		public void expandItem(TreeItem item) {
			item.setExpanded(true);
			createChildren(item);

		}

	}
	protected Composite createTree(Composite parent, int options) {
		return _toolkit.createTree(parent, options);
	}

	private TRCClassSnapshot classSnapshot = new TRCClassImpl.TRCClassSnapshot();
	
	protected ColumnLabelAdapter _classNameCol;
	protected ColumnLabelAdapter _packageNameCol;
	protected ColumnLabelAdapter _refSizeCol;
	protected ColumnLabelAdapter _instanceNameCol;

	protected ColumnLabelAdapter _numRefsCol;
	protected ColumnLabelAdapter _numRefsInstCol;	
	
	
	public ReferenceTable(Composite parent, TraceViewerPage page) {
		super(parent, page);
		_viewerFilter = new ClassStatisticFilter();				

		TraceUIPlugin.getDefault().addRefChangedEventListener(this);
		createColumnsLabelProviders();
	}
	
	protected String getContextHelpId()
	{
		return TraceUIPlugin.getPluginId()+".rfst0000";
	}
	
	public void createColumnsLabelProviders()
	{
		_classNameCol = new ClassNameColumnLabel();
		_packageNameCol = new PackageNameColumnLabel();
		_refSizeCol = new ReferenceSizeColumnLabel();
		ContextUpdaterHelper.addSnapshots(_refSizeCol, null, classSnapshot, null);
		_instanceNameCol = new InstanceNameColumnLabel();
		_numRefsCol = new NumberReferencesColumnLabel();
		_numRefsInstCol = new ReferenceDetailColumnLabel();			
	}

	/**
	 * getClassColumnsPerferencesKey returns the string key used to find the
	 * column preferences information in the preferences store.
	 * @return java.lang.String key name
	 */
	public String getColumnsPreferencesKey() {
		// Note this string is not to be translated and must be changed whenever the 
		// default columns template is changed by adding, removing or renaming columns.
		// Changing the version will result in the default preferences being used.
		return "Ref63";

	}
	public String getDefaultColumnsTemplate() {
		//Class Columns Data
		_drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION);
		
		String name = TraceUIMessages._109;
		if(showReferTo())
		    name = TraceUIMessages._108;
		    
		String executionColumn =
			    name
				+ ":0:"
				+ String.valueOf(
					ColumnData.NONDELETABLE
						| ColumnData.IS_VISIBLE
						| ColumnData.NONMOVABLE)
				+ ":left:200,"
				+ IContextAttributes.PACKAGE_NAME + ":1:"
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":left:150,"
				+ IContextAttributes.REF_SIZE	+ ":2:"
				+ String.valueOf(ColumnData.IS_VISIBLE)	+ ":right:100,"
				+ IContextAttributes.REF_NUMBER_BY + ":3:"
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":left:170,"
				+ IContextAttributes.REF_DETAILS_BY + ":4:"
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":left:350";
				

		return executionColumn;
	}
	protected IContentProvider getContentProvider() {
		return new ObjReferenceContentProvider();
	}
	
	public LabelProvider getTableLabelProvider()
	{
		return new ObjReferenceLabelProvider(this);
	}
	

	public Tree getTree() {
		return (Tree) getTreeViewer().getControl();
	}
	
	protected TreeViewer getTreeViewer(Tree tree)
	{
		return new ReferenceTreeViewer(tree);
	}	

	protected void handleSelectionEvent() {
		((ReferenceTablePage) getTraceViewerPage()).openSource().setEnabled(
			false);

		ITraceSelection model = UIPlugin.getDefault().getSelectionModel(_page.getMOFObject());
		
		if (model.size() > 0)
		{
			((ReferenceTablePage) getTraceViewerPage()).openSource().setEnabled(true);
			Object sel = model.getFirstElement();
			
			if(!(sel instanceof TRCPackage))
				((ReferenceTablePage) getTraceViewerPage()).openSource().setEnabled(true);
				
            select(sel);
			
			// If the selection is an object then turn the selection into the class of the object
			if (sel instanceof TRCObject) {
				
				sel = ((TRCObject)sel).getIsA();
			}
			else if (sel instanceof TRCClass) {
				select((TRCClass) sel);
			}
			
			if (sel instanceof EObject)
				updateStatusContext(ContextManager.getContextLanguage(ContextUpdaterHelper.getContext((EObject)sel)));
		}
	}

	/**
	 * Called when the context menu is about to open.
	 * @see IFillMenuTarget#fillContextMenu
	 */
	public void menuAboutToShow(IMenuManager menu) {
		menu.add(fSeparator);

		menu.add(getUpdateAction());

		menu.add(fSeparator);
		menu.add(
			getChooseColumnsAction(
				getColumnDataList(),
				getColumnsPreferencesKey()));

		menu.add(
				getSortByColumnAction());
	}

	private void select(Object sel) {
		
		TRCClass cls = null;
		TRCObject obj = null;
		
		if(sel instanceof TRCClass)
		{
			cls = (TRCClass)sel;
		}
		else if(sel instanceof TRCObject)
		{
			obj = (TRCObject)sel;
		    cls = obj.getIsA();			  			  
		}
		
		if(cls == null)
		  return;
		  
		Tree tree = (Tree) getTreeViewer().getControl();

		TreeItem[] items = tree.getItems();
		TRCClass clsItem = null;
		for (int idx = 0; idx < items.length; idx++) {
			TreeItem item = items[idx];
			if (item.getData() instanceof TRCClass)
				clsItem = (TRCClass) item.getData();
			if (item.getData() instanceof TRCObject)
				clsItem = ((TRCObject) item.getData()).getIsA();
			//if (item.getData().equals(cls))
			if (clsItem != null && clsItem.getId() == cls.getId())
			{
				((ReferenceTreeViewer) getTreeViewer()).expandItem(item);
				
				if(obj == null)
				{
					tree.setSelection(new TreeItem[] { item });
					setNewSelection();
					return;
				}
				
				TreeItem[] childItems = item.getItems();
	
				for (int i = 0; i < childItems.length; i++) {
					TreeItem childItem = childItems[i];
	  				if (childItem.getData().equals(obj)) {
							tree.setSelection(new TreeItem[] { childItem });
							setNewSelection();
							return;
					}
				}
				
			}
		}
		
	}

	public void updateButtons() {
		((ReferenceTablePage) getTraceViewerPage()).openSource().setEnabled(canOpenSourceOnThisObject());
	}

	private boolean canOpenSourceOnThisObject() {
		ITraceSelection model =	UIPlugin.getDefault().getSelectionModel(_page.getMOFObject());
		if (model.size() == 0 || model.getFirstElement() == null) {
			return false;
		}
		Object sel = model.getFirstElement();
		return (sel instanceof TRCClass);
	}

	protected void updateDetailsPane() {
		int selCount = getTree().getSelectionCount();
		if (selCount != 1) {
			return;
		}

		Item item = getTree().getSelection()[0];
		Object itemData = item.getData();

		if (itemData == null) {
			return;
		}
		if (itemData != null && itemData instanceof TreeItem) {
			itemData = ((TreeItem) itemData).getData();
		}
	}

	public void updateModelSelection() {
		
		ISelection selection = getTreeViewer().getSelection();
		if(selection != null && !selection.isEmpty())
		{
			Object itemData = ((IStructuredSelection)selection).getFirstElement();

			if(itemData instanceof TRCObjectReference)
			{  
			   if(showReferTo())
				   itemData = ((TRCObjectReference)itemData).getOwner();
			   else	   
				   itemData = ((TRCObjectReference)itemData).getTarget();			   
			}
			
			notifyViewSelectionChanged(this,itemData);
//			UIPlugin.getDefault().getSelectionModel(
//				_page.getMOFObject()).add(
//				itemData);
//	
//			ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
//			event.setSource(_page.getMOFObject());
//			UIPlugin.getDefault().notifyViewSelectionChangedListener(event);			
		}		
	}
	
	protected StatisticSorter getViewerSorterInstance()
	{
		return new ObjReferenceSorter();
	}
	
	protected void setLinesVisible(Tree tree)
	{
		tree.setLinesVisible(false);		
	}
	
	public void update() {
		resetColumns();
		_drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION);
		
		if(_page instanceof ReferenceTablePage)
		{
			if (_contextInfo != null)
				_contextInfo.setMOFObject(_page.getMOFObject());
		}
		
		super.update();
		
		((ReferenceTablePage)_page).updateFilterAppliedDescription();		
	}

	public void dispose() {
		TraceUIPlugin.getDefault().removeRefChangedEventListener(this);

		super.dispose();
	}

	public void handleRefChangedEvent() {
		
		_drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION);
				
		Tree tree = getTree();
		TreeColumn firstColumn = tree.getColumn(0);
		
		String text = firstColumn.getText();
		String name = TraceUIMessages._109;
		if(showReferTo())
		    name = TraceUIMessages._108;
		
		if (text.startsWith(">") || text.startsWith("<"))
		{
			firstColumn.setText(text.substring(0,1) + name);
		}
		else
			firstColumn.setText(name);		  
		
		Action referands =
			((ReferenceTablePage) getTraceViewerPage()).referands();
		Action referee = ((ReferenceTablePage) getTraceViewerPage()).referee();
		int ref =
			TraceUIPlugin.getDefault().getPreferenceStore().getInt(
				TraceConstants.OBJ_REF_OPTION);
		if (referands != null)
			referands.setChecked(ref == TraceConstants.OBJ_REF_REFERANDS);
		if (referee != null)
			referee.setChecked(ref == TraceConstants.OBJ_REF_REFEREES);

		update();

	}

    private boolean showReferTo()
    {
    	return _drawmode == TraceConstants.OBJ_REF_REFERANDS;
    }
    
	public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event)
	{
		Object  source = event.getSource();
		if(source!=this){	
			handleSelectionEvent();
		}
		else
		{
			ITraceSelection model =
				UIPlugin.getDefault().getSelectionModel(_page.getMOFObject());
			if (model.size() > 0) {
				Object sel = model.getFirstElement();
				if (sel != null && sel instanceof EObject)
						updateStatusContext(ContextManager.getContextLanguage(ContextUpdaterHelper.getContext((EObject)sel)));
			}
		}
	}
	
	public boolean isEmpty()
	{
		if (PerftraceUtil.getAllClasses(_page.getMOFObject()).length > 0)
			return false;
		return true;
	}
    
    protected String getViewTypeStr()
    {
    	return org.eclipse.hyades.trace.views.adapter.internal.TraceConstants.REFERENCE_VIEW;
    }
    
    class MyTRCClassData implements IFTRCClass{
    	private TRCClass cls = null;

    	public MyTRCClassData(TRCClass o){
    		cls = o;
    	}
    	
    	public TRCClass getTRCClass()
		{
    		return cls;    		
		}    	

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getId()
		 */
		public long getId() {
			return cls.getId();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setId(long)
		 */
		public void setId(long value) {
			cls.setId(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getName()
		 */
		public String getName() {
			return cls.getName();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setName(java.lang.String)
		 */
		public void setName(String value) {
			cls.setName(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getSize()
		 */
		public int getSize() {
			return cls.getSize();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setSize(int)
		 */
		public void setSize(int value) {
			cls.setSize(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getLoadTime()
		 */
		public double getLoadTime() {
			return cls.getLoadTime();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setLoadTime(double)
		 */
		public void setLoadTime(double value) {
			cls.setLoadTime(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getUnloadTime()
		 */
		public double getUnloadTime() {
			return cls.getUnloadTime();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setUnloadTime(double)
		 */
		public void setUnloadTime(double value) {
			cls.setUnloadTime(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#isInterface()
		 */
		public boolean isInterface() {
			return cls.isInterface();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setInterface(boolean)
		 */
		public void setInterface(boolean value) {
			cls.setInterface(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getLineNo()
		 */
		public int getLineNo() {
			return cls.getLineNo();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setLineCount(int)
		 */
		public void setLineCount(int value) {
			cls.setLineCount(value);
		}
		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getLineCount(int)
		 */
		public int getLineCount() {
			return cls.getLineCount();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setLineNo(int)
		 */
		public void setLineNo(int value) {
			cls.setLineNo(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getBaseTime()
		 */
		public double getBaseTime() {
			return cls.getBaseTime();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setBaseTime(double)
		 */
		public void setBaseTime(double value) {
			cls.setBaseTime(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getCumulativeTime()
		 */
		public double getCumulativeTime() {
			return cls.getCumulativeTime();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setCumulativeTime(double)
		 */
		public void setCumulativeTime(double value) {
			cls.setCumulativeTime(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getCalls()
		 */
		public int getCalls() {
			return cls.getCalls();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setCalls(int)
		 */
		public void setCalls(int value) {
			cls.setCalls(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getInheritedCalls()
		 */
		public int getInheritedCalls() {
			return cls.getInheritedCalls();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setInheritedCalls(int)
		 */
		public void setInheritedCalls(int value) {
			cls.setInheritedCalls(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getInheritedBaseTime()
		 */
		public double getInheritedBaseTime() {
			return cls.getInheritedBaseTime();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setInheritedBaseTime(double)
		 */
		public void setInheritedBaseTime(double value) {
			cls.setInheritedBaseTime(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getInheritedCumulativeTime()
		 */
		public double getInheritedCumulativeTime() {
			return cls.getInheritedCumulativeTime();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setInheritedCumulativeTime(double)
		 */
		public void setInheritedCumulativeTime(double value) {
			cls.setInheritedCumulativeTime(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getTotalSize()
		 */
		public int getTotalSize() {
			return cls.getTotalSize();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setTotalSize(int)
		 */
		public void setTotalSize(int value) {
			cls.setTotalSize(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getTotalInstances()
		 */
		public int getTotalInstances() {
			return cls.getTotalInstances();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setTotalInstances(int)
		 */
		public void setTotalInstances(int value) {
			cls.setTotalInstances(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getCollectedSize()
		 */
		public int getCollectedSize() {
			return cls.getCollectedSize();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setCollectedSize(int)
		 */
		public void setCollectedSize(int value) {
			cls.setCollectedSize(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getCollectedInstances()
		 */
		public int getCollectedInstances() {
			return cls.getCollectedInstances();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setCollectedInstances(int)
		 */
		public void setCollectedInstances(int value) {
			cls.setCollectedInstances(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getTotalCpuTime()
		 */
		public double getTotalCpuTime() {
			return cls.getTotalCpuTime();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setTotalCpuTime(double)
		 */
		public void setTotalCpuTime(double value) {
			cls.setTotalCpuTime(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getObjects()
		 */
		public EList getObjects() {
			return cls.getObjects();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getLoadedBy()
		 */
		public TRCThread getLoadedBy() {
			return cls.getLoadedBy();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setLoadedBy(org.eclipse.hyades.models.trace.TRCThread)
		 */
		public void setLoadedBy(TRCThread value) {
			cls.setLoadedBy(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getMethods()
		 */
		public EList getMethods() {
			return cls.getMethods();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getClassObjects()
		 */
		public EList getClassObjects() {
			return cls.getClassObjects();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getPackage()
		 */
		public TRCPackage getPackage() {
			return cls.getPackage();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setPackage(org.eclipse.hyades.models.trace.TRCPackage)
		 */
		public void setPackage(TRCPackage value) {
			cls.setPackage(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getClassLoader()
		 */
		public TRCClassLoader getClassLoader() {
			return cls.getClassLoader();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setClassLoader(org.eclipse.hyades.models.trace.TRCClassLoader)
		 */
		public void setClassLoader(TRCClassLoader value) {
			cls.setClassLoader(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getSourceInfo()
		 */
		public TRCSourceInfo getSourceInfo() {
			return cls.getSourceInfo();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setSourceInfo(org.eclipse.hyades.models.trace.TRCSourceInfo)
		 */
		public void setSourceInfo(TRCSourceInfo value) {
			cls.setSourceInfo(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getEnclosedBy()
		 */
		public TRCClass getEnclosedBy() {
			return cls.getEnclosedBy();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#setEnclosedBy(org.eclipse.hyades.models.trace.TRCClass)
		 */
		public void setEnclosedBy(TRCClass value) {
			cls.setEnclosedBy(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getExtends()
		 */
		public EList getExtends() {
			return this.getExtends();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getImplements()
		 */
		public EList getImplements() {
			return this.getImplements();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCClass#getLocks()
		 */
		public EList getLocks() {
			return this.getLocks();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eClass()
		 */
		public EClass eClass() {
			return cls.eClass();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eResource()
		 */
		public Resource eResource() {
			return cls.eResource();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eContainer()
		 */
		public EObject eContainer() {
			return cls.eContainer();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eContainingFeature()
		 */
		public EStructuralFeature eContainingFeature() {
			return cls.eContainingFeature();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eContainmentFeature()
		 */
		public EReference eContainmentFeature() {
			return cls.eContainmentFeature();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eContents()
		 */
		public EList eContents() {
			return cls.eContents();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eAllContents()
		 */
		public TreeIterator eAllContents() {
			return cls.eAllContents();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eIsProxy()
		 */
		public boolean eIsProxy() {
			return cls.eIsProxy();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eCrossReferences()
		 */
		public EList eCrossReferences() {
			return cls.eCrossReferences();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eGet(org.eclipse.emf.ecore.EStructuralFeature)
		 */
		public Object eGet(EStructuralFeature feature) {
			return cls.eGet(feature);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eGet(org.eclipse.emf.ecore.EStructuralFeature, boolean)
		 */
		public Object eGet(EStructuralFeature feature, boolean resolve) {
			return cls.eGet(feature, resolve);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eSet(org.eclipse.emf.ecore.EStructuralFeature, java.lang.Object)
		 */
		public void eSet(EStructuralFeature feature, Object newValue) {
			cls.eSet(feature, newValue);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eIsSet(org.eclipse.emf.ecore.EStructuralFeature)
		 */
		public boolean eIsSet(EStructuralFeature feature) {
			return cls.eIsSet(feature);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eUnset(org.eclipse.emf.ecore.EStructuralFeature)
		 */
		public void eUnset(EStructuralFeature feature) {
			cls.eUnset(feature);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.common.notify.Notifier#eAdapters()
		 */
		public EList eAdapters() {
			return cls.eAdapters();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.common.notify.Notifier#eDeliver()
		 */
		public boolean eDeliver() {
			return cls.eDeliver();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.common.notify.Notifier#eSetDeliver(boolean)
		 */
		public void eSetDeliver(boolean deliver) {
			cls.eSetDeliver(deliver);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.common.notify.Notifier#eNotify(org.eclipse.emf.common.notify.Notification)
		 */
		public void eNotify(Notification notification) {
			cls.eNotify(notification);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.loaders.trace.IDeltaManager#takeSnapshot()
		 */
		public void takeSnapshot() {
			cls.takeSnapshot();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.loaders.trace.IDeltaManager#retrieveSnapshot()
		 */
		public ISnapshot retrieveSnapshot() {
			return cls.retrieveSnapshot();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.loaders.trace.IDeltaManager#removeSnapshot()
		 */
		public void removeSnapshot() {
			cls.removeSnapshot();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.loaders.trace.IDeltaManager#computeDelta(org.eclipse.hyades.loaders.trace.IDelta)
		 */
		public int computeDelta(IDelta delta) {
			return cls.computeDelta(delta);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.loaders.trace.IDeltaManager#computeDelta(org.eclipse.hyades.loaders.trace.IDelta, int)
		 */
		public int computeDelta(IDelta delta, int featureID) {
			return cls.computeDelta(delta, featureID);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.ui.IActionFilter#testAttribute(java.lang.Object, java.lang.String, java.lang.String)
		 */
		public boolean testAttribute(Object target, String name, String value) {
			// TODO Auto-generated method stub
			return true;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCArrayClass#getArrayType()
		 */
		public TRCPrimitiveType getArrayType() {
			return cls instanceof TRCArrayClass ? ((TRCArrayClass) cls).getArrayType() : null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCArrayClass#setArrayType(org.eclipse.hyades.models.trace.TRCPrimitiveType)
		 */
		public void setArrayType(TRCPrimitiveType value) {
			if (cls instanceof TRCArrayClass)
				((TRCArrayClass) cls).setArrayType(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCArrayClass#getElementType()
		 */
		public TRCClass getElementType() {
			return cls instanceof TRCArrayClass ? ((TRCArrayClass) cls).getElementType() : null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCArrayClass#setElementType(org.eclipse.hyades.models.trace.TRCClass)
		 */
		public void setElementType(TRCClass value) {
			if (cls instanceof TRCArrayClass)
				((TRCArrayClass) cls).setElementType(value);
		}

		public EList getAnnotations() {
			return cls.getAnnotations();
		}

		public Object eInvoke(EOperation arg0, EList<?> arg1)
				throws InvocationTargetException {
			return cls instanceof TRCArrayClass ? ((TRCArrayClass) cls).eInvoke(arg0, arg1) : null;
		}

		public int getCumulativeSize() {
			return cls.getCumulativeSize();
		}

		public void setCumulativeSize(int value) {
			cls.setCumulativeSize(value);
		}

   }

    class MyTRCObjectData implements IFTRCObject{
    	private TRCObject obj;
    	public MyTRCObjectData(TRCObject o){
    		obj = o;
    	}
    	
    	public TRCObject getTRCObject()
		{
    		return obj;    		
		}      	
    	
		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCObject#getId()
		 */
		public long getId() {
			return obj.getId();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCObject#setId(long)
		 */
		public void setId(long value) {
			obj.setId(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCObject#getSize()
		 */
		public int getSize() {
			return obj.getSize();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCObject#setSize(int)
		 */
		public void setSize(int value) {
			obj.setSize(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCObject#getIsA()
		 */
		public TRCClass getIsA() {
			return obj.getIsA();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCObject#setIsA(org.eclipse.hyades.models.trace.TRCClass)
		 */
		public void setIsA(TRCClass value) {
			obj.setIsA(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCObject#getProcess()
		 */
		public TRCProcess getProcess() {
			return obj.getProcess();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCObject#setProcess(org.eclipse.hyades.models.trace.TRCProcess)
		 */
		public void setProcess(TRCProcess value) {
			obj.setProcess(value);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eClass()
		 */
		public EClass eClass() {
			return obj.eClass();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eResource()
		 */
		public Resource eResource() {
			return obj.eResource();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eContainer()
		 */
		public EObject eContainer() {
			return obj.eContainer();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eContainingFeature()
		 */
		public EStructuralFeature eContainingFeature() {
			return obj.eContainingFeature();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eContainmentFeature()
		 */
		public EReference eContainmentFeature() {
			return obj.eContainmentFeature();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eContents()
		 */
		public EList eContents() {
			return obj.eContents();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eAllContents()
		 */
		public TreeIterator eAllContents() {
			return obj.eAllContents();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eIsProxy()
		 */
		public boolean eIsProxy() {
			return obj.eIsProxy();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eCrossReferences()
		 */
		public EList eCrossReferences() {
			return obj.eCrossReferences();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eGet(org.eclipse.emf.ecore.EStructuralFeature)
		 */
		public Object eGet(EStructuralFeature feature) {
			return obj.eGet(feature);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eGet(org.eclipse.emf.ecore.EStructuralFeature, boolean)
		 */
		public Object eGet(EStructuralFeature feature, boolean resolve) {
			return obj.eGet(feature, resolve);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eSet(org.eclipse.emf.ecore.EStructuralFeature, java.lang.Object)
		 */
		public void eSet(EStructuralFeature feature, Object newValue) {
			obj.eSet(feature, newValue);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eIsSet(org.eclipse.emf.ecore.EStructuralFeature)
		 */
		public boolean eIsSet(EStructuralFeature feature) {
			return obj.eIsSet(feature);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.EObject#eUnset(org.eclipse.emf.ecore.EStructuralFeature)
		 */
		public void eUnset(EStructuralFeature feature) {
			obj.eUnset(feature);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.common.notify.Notifier#eAdapters()
		 */
		public EList eAdapters() {
			return obj.eAdapters();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.common.notify.Notifier#eDeliver()
		 */
		public boolean eDeliver() {
			return obj.eDeliver();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.common.notify.Notifier#eSetDeliver(boolean)
		 */
		public void eSetDeliver(boolean deliver) {
			obj.eSetDeliver(deliver);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.emf.common.notify.Notifier#eNotify(org.eclipse.emf.common.notify.Notification)
		 */
		public void eNotify(Notification notification) {
			obj.eNotify(notification);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.ui.IActionFilter#testAttribute(java.lang.Object, java.lang.String, java.lang.String)
		 */
		public boolean testAttribute(Object target, String name, String value) {
			// TODO Auto-generated method stub
			return false;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCHeapObject#getRefOwner()
		 */
		public EList getRefOwner() {
			return obj instanceof TRCHeapObject ? ((TRCHeapObject) obj).getRefOwner() : null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCHeapObject#getRefTarget()
		 */
		public EList getRefTarget() {
			return obj instanceof TRCHeapObject ? ((TRCHeapObject) obj).getRefTarget() : null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCTraceObject#getInvocations()
		 */
		public EList getInvocations() {
			return obj instanceof TRCTraceObject ? ((TRCTraceObject) obj).getInvocations() : null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCTraceObject#getThread()
		 */
		public TRCThread getThread() {
			return obj instanceof TRCTraceObject ? ((TRCTraceObject) obj).getThread() : null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.models.trace.TRCTraceObject#setThread(org.eclipse.hyades.models.trace.TRCThread)
		 */
		public void setThread(TRCThread value) {
			if (obj instanceof TRCTraceObject)
				((TRCTraceObject) obj).setThread(value);
		}

		public Object eInvoke(EOperation arg0, EList<?> arg1)
				throws InvocationTargetException {
			return obj instanceof TRCTraceObject ? ((TRCTraceObject) obj).eInvoke(arg0, arg1) : null;
		}

		public int getCumulativeSize() {
			return obj.getCumulativeSize();
		}

		public void setCumulativeSize(int value) {
			obj.setCumulativeSize(value);
		}
    	
    }


	protected SimpleSearchQuery getCurrentFilter()
	{
		return ((ReferenceTablePage)_page).getCurrentFilter();
	}
	
//	protected void showPercentUpdate()
//	{
//		super.showPercentUpdate();	
//		
//		_packageNameCol.update(IUpdateAttributes.MOF_OBJECT, _page.getMOFObject());
//
//	}
	
	protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn)
	{
		if (col == _packageNameCol)
			return ContextUpdaterHelper.updatePackageName(col, _page.getMOFObject());
		else
			return ContextUpdaterHelper.updateRefCol(col, showReferTo());
	}	
	
	protected Composite createControl(Composite parent, ArrayList cols) {
		final Composite vc = super.createControl(parent, cols);
		
		_contextInfo = new ContextInfoContainer();
		_contextInfo.setViewer((IContextViewer)_page.getTraceViewer());
		_contextInfo.createControl(vc);
		_contextInfo.addContextInfoContainerListener(
				new IContextInfoContainerListener()
				{
					public void visibilityChanged(boolean isVisible)
					{
						vc.layout(true, true);
					}
				});

		return vc;
	}
	
	protected void updateStatusContext(IContextLanguage language)
	{
		if (_contextInfo != null)
			_contextInfo.updateStatusContext(language);
	}
	
	protected void resetColumns()
	{
		_classNameCol.resetMap();
		_packageNameCol.resetMap();
		_refSizeCol.resetMap();
		_instanceNameCol.resetMap();
		_numRefsCol.resetMap();
		_numRefsInstCol.resetMap();		
	}

	public CellLabelProvider getCellLabelProvider(ColumnData colData) {
		return new ObjReferenceCellLabelProvider(colData);
	}
}

