/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SinglePattern.java,v 1.9 2008/04/17 07:49:34 aalexeev Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.SinglePatternTab;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
* CONTEXT_ID osrc0000 for open java source action
*/

public class SinglePattern extends AbstractLazyHandler
	implements ITimeChangedListener, ControlListener, ISelectionProvider
			   , IViewSelectionChangedListener
	
{
	protected final float MAG_STEP = 2;
	private Label _status;
	private JCanvas _canvas;
	private SinglePatternDrawStrategy _curDS;
	private SinglePatternDrawStrategy _singlePatDS;
	private boolean _initialized = false;
	protected SinglePatternTab _tabItem;
	protected Composite viewContainer;
	protected ViewForm dataPane;
	protected Composite viewComp;
	private Action _showNextAction;
	private Action _showPrevAction;
	private Action _showCallerAction;
	private Action _showCalleeAction;
	private Action _updateAction;
	private Action _openColorDialog;
	protected Separator fSeparator;
	
	class UpdateAction extends Action {
		public UpdateAction(String name) {
			super(name);
			PDPluginImages.setImageDescriptors(
				this,
				PDPluginImages.T_LCL,
				PDPluginImages.IMG_UPDATEVIEWS);
		}

		/**
		 * Invoked when an action occurs.
			* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			ProfileEvent event = UIPlugin.getDefault().getRefreshViewEvent(_tabItem.getMOFObject());
			UIPlugin.getDefault().notifyProfileEventListener(event);
		}
	}

	//-------------------------------
	// Open Color Dialog popup action
	//-------------------------------
	class OpenColorDialog extends Action {
		public OpenColorDialog(String name) {
			super(name);
			TracePluginImages.setImageDescriptors(
				this,
				TracePluginImages.T_TOOL,
				TracePluginImages.IMG_COLORS);

		}

		/**
		 * Invoked when an action occurs.
		* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			GraphColorDialog dialog =
				new GraphColorDialog(
					viewContainer.getShell(),
					TraceUIMessages._97,
					null);
			dialog.open();
		}
	}

	//-------------------------------
	// ShowCallerAction popup action
	//-------------------------------	
	class ShowCallerAction extends Action {
		public ShowCallerAction(String name) {
			super(name);
		}

		/**
		 * Invoked when an action occurs.
			* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			showCaller();
		}
	}

	//-------------------------------
	// ShowCalleeAction popup action
	//-------------------------------	
	class ShowCalleeAction extends Action {
		public ShowCalleeAction(String name) {
			super(name);
		}

		/**
		 * Invoked when an action occurs.
			* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			showCallee();
		}
	}

	//-------------------------------
	// ShowNextAction popup action
	//-------------------------------	
	class ShowNextAction extends Action {
		public ShowNextAction(String name) {
			super(name);
		}

		/**
		 * Invoked when an action occurs.
			* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			next();
		}
	}

	//-------------------------------
	// ShowPreviousAction popup action
	//-------------------------------	
	class ShowPreviousAction extends Action {
		public ShowPreviousAction(String name) {
			super(name);
		}

		/**
		 * Invoked when an action occurs.
			* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			previous();
		}
	}

	public SinglePattern(Composite parent, SinglePatternTab tabItem) {
		this(parent, tabItem, false);
	}

	public SinglePattern(Composite parent, SinglePatternTab tabItem, boolean lazyMode) {
		super(lazyMode);
		
		_tabItem = tabItem;

		createControl(parent);
		_showNextAction = new ShowNextAction(TraceUIMessages._10);
		_showPrevAction =
			new ShowPreviousAction(TraceUIMessages._9);
		_showCallerAction =
			new ShowCallerAction(TraceUIMessages._71);
		_showCalleeAction =
			new ShowCalleeAction(TraceUIMessages._72);
		_updateAction = new UpdateAction(UIPlugin.getResourceString("REFRESH_VIEWS"));
		_openColorDialog =
			new OpenColorDialog(TraceUIMessages._98);

		TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
		UIPlugin.getDefault().addViewSelectionChangedListener(this);

	}
	public void controlMoved(org.eclipse.swt.events.ControlEvent e) {
	}
	public void controlResized(org.eclipse.swt.events.ControlEvent event) {
		resizeContent();
	}
	/**
	 * @return org.eclipse.swt.widgets.Control
	 * @param parent org.eclipse.swt.widgets.Composite
	 */
	public void createControl(Composite parent) {
		GridLayout layout;

		viewContainer = new Composite(parent, SWT.BORDER);
		layout = new GridLayout();
		layout.numColumns = 1;
		viewContainer.setLayout(layout);
		viewContainer.setLayoutData(GridUtil.createFill());

		viewComp = new Composite(viewContainer, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		viewComp.setLayout(layout);
		viewComp.setLayoutData(GridUtil.createFill());

		dataPane = new ViewForm(viewComp, SWT.NULL);
		dataPane.setLayoutData(GridUtil.createFill());

		_canvas = new JCanvas(dataPane, SWT.H_SCROLL | SWT.V_SCROLL, 10);
		dataPane.setContent(_canvas.canvas());
		viewContainer.addControlListener(this);

		_status = new Label(viewContainer, SWT.BORDER);
		_status.setLayoutData(GridUtil.createHorizontalFill());

		dataPane.setTopLeft(new CLabel(dataPane, SWT.NONE));

	}
	public void dispose() {
		TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
		UIPlugin.getDefault().removeViewSelectionChangedListener(this);

		if (_singlePatDS != null)
			_singlePatDS.shutdown();
		
		if(_canvas != null)
		  _canvas.dispose();
		  
		_canvas = null;

		if(dataPane != null)
			dataPane.dispose();
		dataPane = null;

		if(viewComp != null)
			viewComp.dispose();
		viewComp = null;	

		if(viewContainer != null)
			viewContainer.dispose();
		viewContainer = null;	

		_tabItem = null;
		_singlePatDS = null;
		_curDS = null;
		
		if(_status != null)
			_status.dispose();
		_status = null;	
		
		_openColorDialog = null;
		_showCalleeAction = null;
		_showCallerAction = null;
		_showNextAction = null;
		_showPrevAction = null;
		_updateAction = null;			

	}
	/**
	 * This method should fill (or update) the given menu. It is called just before
	 * the menu opens.
	 */
	public void fillContextMenu(IMenuManager menu) {
		menu.add(fSeparator);
		menu.add(_updateAction);

		menu.add(_openColorDialog);
		menu.add(fSeparator);

		menu.add(_showCallerAction);
		menu.add(_showCalleeAction);
		menu.add(fSeparator);
		menu.add(_showNextAction);
		menu.add(_showPrevAction);
		menu.add(fSeparator);

		_showPrevAction.setEnabled(_curDS.hasLessElements());
		_showNextAction.setEnabled(_curDS.hasMoreElements());
		_showCallerAction.setEnabled(_curDS.hasCaller());
		_showCalleeAction.setEnabled(_curDS.hasCallee());

		_canvas.fillContextMenu(menu);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/10/2001 2:33:22 PM)
	 * @return org.eclipse.swt.widgets.Control
	 */
	public Control getControl() {
		return viewContainer;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (06/15/2000 3:55:00 PM)
	 */
	public void initialize() {
		if (_initialized)
			return;

		_initialized = true;

		initStrategies();
		setDrawStrategy(_singlePatDS);
		fSeparator = new Separator();
//		((SinglePatternViewer)_page.getTraceViewer()).updateTitle();	
		
	}
	private void initStrategies() {
		_singlePatDS = new SinglePatternDrawStrategy(this);
	}
	/**
	 * Called when the context menu is about to open.
	 * @see IFillMenuTarget#fillContextMenu
	 */
	public void menuAboutToShow(IMenuManager menu) {
		fillContextMenu(menu);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void next() {
		initialize();
		if (_singlePatDS != null) {
			_singlePatDS.drawNextPattern();
			_singlePatDS.jcanvas().zoomToFill(1f, 1000f);
			_singlePatDS.jcanvas().redraw();
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/21/2001 6:31:49 PM)
	 */
	public void openSource() {

		OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(_tabItem.getMOFObject()).getFirstElement());

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void previous() {
		initialize();
		if (_singlePatDS != null) {
			_singlePatDS.drawPreviousPattern();
			_singlePatDS.jcanvas().zoomToFill(1f, 1000f);
			_singlePatDS.jcanvas().redraw();
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/17/2000 2:08:36 PM)
	 */
	public void resizeContent() {
		/* Get the client area for the shell */
		Rectangle viewContainerBounds = viewComp.getClientArea();
		dataPane.setBounds(
			viewContainerBounds.x,
			viewContainerBounds.y,
			viewContainerBounds.width,
			viewContainerBounds.height);
	}
	private void setDrawStrategy(SinglePatternDrawStrategy ds) {
		if (ds != _curDS) {
			if (_curDS != null) {
				_curDS.jcanvas(null);
			}

			_curDS = ds;
			_curDS.jcanvas(_canvas);

			_canvas.zoomToFit();
			_canvas.setDrawStrategy(_curDS);
			_canvas.redraw();
			//			_curDS.bgRedraw();

		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (6/6/2001 5:21:34 PM)
	 */
	public void showCallee() {
		if (_curDS != null)
			_curDS.showCallee();

//		updateButtons();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (6/6/2001 5:21:34 PM)
	 */
	public void showCaller() {
		if (_curDS != null)
			_curDS.showCaller();

//		updateButtons();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/14/2000 5:45:18 PM)
	 */
	public void update() {
		update(true);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/14/2000 5:45:18 PM)
	 */
	public void update(boolean redraw) {
		super.update(redraw);
	}
	
	protected void doUpdate(boolean redraw, boolean isPostponedOperation, int processedOperations) {
		initialize();
		if (_singlePatDS != null) {
			_singlePatDS.searchPattern();

			/*
			if(redraw)
			{
				_singlePatDS.jcanvas().zoomToFill(1f, 1000f);			
				_singlePatDS.jcanvas().redraw();			
			}
			*/
			updateUI();
		}

	}
	public void updateButtons() {
		super.updateButtons();
	}

	protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
		if (_curDS != null) {
			if (_tabItem.previous() != null)
				_tabItem.previous().setEnabled(_curDS.hasLessElements());

			if (_tabItem.next() != null)
				_tabItem.next().setEnabled(_curDS.hasMoreElements());

			if (_tabItem.caller() != null)
				_tabItem.caller().setEnabled(_curDS.hasCaller());

			if (_tabItem.callee() != null)
				_tabItem.callee().setEnabled(_curDS.hasCallee());

			if(_tabItem.openSource() != null)				
				_tabItem.openSource().setEnabled(UIPlugin.getDefault().getSelectionModel(_tabItem.getMOFObject()).getFirstElement() != null);				

		}
	}
	
	public boolean isPreviousEnabled() {
		return (_curDS != null) && _curDS.hasLessElements();
	}
	
	public boolean isNextEnabled() {
		return (_curDS != null) && _curDS.hasMoreElements();
	}
	
	public boolean isCallerEnabled() {
		return (_curDS != null) && _curDS.hasCaller();
	}
	
	public boolean isCalleeEnabled() {
		return (_curDS != null) && _curDS.hasCallee();
	}
	
	public boolean isOpenSourceEnabled() {
		return (_curDS != null) && UIPlugin.getDefault().getSelectionModel(
				_tabItem.getMOFObject()).getFirstElement() != null;
	}
	
	
	public void updateStatus(String status) {
		_status.setText(status);
	}
	public void updateTitle(String title) {
		((CLabel) dataPane.getTopLeft()).setText(title);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void updateUI() {
		super.updateUI();
	}
	
	protected void doUpdateUI(boolean isPostponedOperation, int processedOperations) {
		if ((!isPostponedOperation || (processedOperations & LAZY_UPDATE) == 0)
				&& _curDS.jcanvas() != null) {
			_curDS.jcanvas().zoomToFill(1f, 1000f);
			_curDS.jcanvas().redraw();
		}
	}
	
	
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void zoomIn(boolean zoom) {
		initialize();

		_canvas.isZoomIn(zoom);
		_canvas.zoomIn();

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void zoomOut(boolean zoom) {
		initialize();

		_canvas.isZoomOut(zoom);
		_canvas.zoomOut();
	}

	public void handleTimeChangedEvent() {
		Action base = _tabItem.baseTime();
		Action raw = _tabItem.rawTime();
		int ref =
			TraceUIPlugin.getDefault().getPreferenceStore().getInt(
				TraceConstants.TIME_OPTION);
		if (base != null)
			base.setChecked(ref == TraceConstants.COMPENSATED_TIME);
		if (raw != null)
			raw.setChecked(ref == TraceConstants.RAW_TIME);

		if (_curDS != null)
			_curDS.setDrawMode(ref);
	}

	public SinglePatternTab getTabItem() {
		return _tabItem;
	}
	
	/*
	 * This method handles a selection event
	 */
	public void refresh() {
		super.refresh();
	}
	
	protected void doRefresh(boolean isPostponedOperation,
			int processedOperations) {
		if ((!isPostponedOperation || (processedOperations & LAZY_UPDATE) == 0)
				&& _canvas != null && !_canvas.canvas().isDisposed() && _canvas.canvas().isVisible()) {
			_canvas.redraw();
		}
	}
	
	/*
	 * This method handles a selection event
	 */
	public void selectionChanged() {
		handleSelectionEvent();
	}

	protected void doHandleSelectionEvent(boolean isPostponedOperation,
			int processedOperations) {
		if ((!isPostponedOperation || (processedOperations & LAZY_UPDATE) == 0)
				&& _canvas != null && !_canvas.canvas().isDisposed() && !_canvas.canvas().isFocusControl()) {

			update();			
		}
	}

	/**
	 * Adds a listener for selection changes in this selection provider.
	 * Has no effect if an identical listener is already registered.
	 *
	 * @param listener a selection changed listener
	 */
	public void addSelectionChangedListener(ISelectionChangedListener listener)
	{
	}
	/**
	 * Returns the current selection for this provider.
	 * 
	 * @return the current selection
	 */
	public ISelection getSelection()
	{
		if(_tabItem == null)
		  return new StructuredSelection();
		  
		Object selection = UIPlugin.getDefault().getSelectionModel(_tabItem.getMOFObject()).getFirstElement();
		
		if(selection != null)		
			return new StructuredSelection(selection);
			
		return new StructuredSelection();
	}
	/**
	 * Removes the given selection change listener from this selection provider.
	 * Has no affect if an identical listener is not registered.
	 *
	 * @param listener a selection changed listener
	 */
	public void removeSelectionChangedListener(ISelectionChangedListener listener)
	{
	}
	/**
	 * Sets the current selection for this selection provider.
	 *
	 * @param selection the new selection
	 */
	public void setSelection(ISelection selection)
	{
	}
	
	/**
	 * @return
	 */
	public JCanvas getCanvas() {
		return _canvas;
	}

	public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
		super.handleViewSelectionChangedEvent(event);
	}

	protected void doHandleViewSelectionChangedEvent(
			ViewSelectionChangedEvent event, boolean isPostponedOperation, int processedOperations) {
		Object  source = event.getSource();
		if(!(source instanceof SinglePattern))
			selectionChanged();  
	}
	
	protected boolean isHandleSelectionEventNeeded(Object source){
		return !(source instanceof SinglePattern);
	}
	
	
}