/**********************************************************************
 * Copyright (c) 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatisticCellLabelProvider.java,v 1.1 2008/03/10 16:37:19 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import java.util.Vector;

import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.tptp.platform.common.ui.views.TableCellLabelProvider;
import org.eclipse.tptp.platform.common.ui.views.TableCellLabelProviderManager;

public abstract class StatisticCellLabelProvider extends CellLabelProvider {
	ColumnData data;
	int visualIndex;
	Vector tblCellLabelProviders;
	
	public StatisticCellLabelProvider(ColumnData colData) {
		this.data = colData;
		tblCellLabelProviders = TableCellLabelProviderManager.getProvidersByColIDLKey(data.key());
	}

	public String getToolTipText(Object element) {
		if (tblCellLabelProviders!=null && tblCellLabelProviders.size()>0) {
			StringBuffer buf = new StringBuffer();
			
			for (int i=0;i<tblCellLabelProviders.size();i++) {
				TableCellLabelProvider tblCellLabelProvider = (TableCellLabelProvider)(tblCellLabelProviders.get(i));
				buf.append(tblCellLabelProvider.getColumnHoverText(element, data.key()));
				
				if (i<tblCellLabelProviders.size()-1) buf.append("\n");
			}
			return buf.toString();
		}
		else {
			return null;
		}
	}

	public boolean useNativeToolTip(Object arg0) {
		return (tblCellLabelProviders==null||tblCellLabelProviders.size()==0?true:false);
//		return false;
	}
}
