/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatisticView.java,v 1.47 2010/12/06 16:56:52 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.actions.internal.OpenMethodDetailsAction;
import org.eclipse.hyades.trace.views.actions.internal.OpenSourceAction;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.internal.fragment.ContentProviderNewLazyAdaptor;
import org.eclipse.hyades.trace.views.internal.fragment.FragmentedTreeViewer;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelComparator;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnsDialog;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;
import org.eclipse.hyades.trace.views.util.internal.SortByColumnDialog;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ColumnLayout;

/*
* CONTEXT_ID stvw0001 for filter entry field of statistics views
*/
/*
* CONTEXT_ID stvw0002 for filter case sensitive checkbox of statistics views
*/

/**
 * 
 * StatisticView is the abstract base class for all of the statistics style views.
 * <p>
 * <b>Note:</b> This class is going to be deprecated and replaced with an external class in TPTP 4.1.
 * 
 * @version 	1.0
 * @author Mike Wulkan
 */
public abstract class StatisticView extends AbstractLazyHandler 
									implements
                                      IViewSelectionChangedListener
									  , ControlListener
{
	protected ArrayList tmpList;
	
	protected StructuredViewer _viewer;
	protected Layout _layout = null;
	protected Composite _viewContainer;
	protected Composite _filterContainer;
	protected ViewForm _dataPane;
	protected Composite _viewComp;
	protected boolean _initialized = false;
	protected TraceViewerPage _page;
	protected StatisticFilter _viewerFilter;
	protected StatisticSorter _viewerSorter;
	protected ArrayList _currentColumns = null;
	protected boolean _newSelection = false;
	protected boolean _isShowPercent = false;
	protected boolean _deltaColumns = false;
	
	protected boolean _refresh = false;

	protected Action _updateAction;
	protected Action _chooseColumnAction;
	protected Action _sortByColumnAction;
	protected Action _showPercent;
	protected Action _deltaColumnsAction;	
	protected Action _chooseColumnsAction;
	protected Separator fSeparator;
		
	protected double _maxTime;
	protected double _totalPackagesCumulativeTime;
	protected double _totalBaseTime;
	protected double _totalCumulativeTime;
	protected double _totalInheritedBaseTime;
	protected double _totalInheritedCumulativeTime;
	protected int    _totalInst;
	protected int    _totalCalls;
	protected int    _activeInst;
	protected long   _totalSize;
	protected long   _activeSize;
	protected int    _collectedInst;
	
	protected ContentProviderNewLazyAdaptor adaptor;
	protected LabelProvider wrappedLp;
	
	//extention points
	protected ArrayList _listOfColumExtension = new ArrayList();
	protected String _templateOfColumExtension="";
	
	protected HyadesFormToolkit _toolkit;
	
	protected static String _previousColumnText;
	protected static int _previousColumnIndex;
	protected static int _previousSequence;
	
	public abstract class StatisticSorter extends ViewerSorter {
		protected TreeColumn _sortColumn;
		protected int _sortSequence = -1;
		protected StatisticTableColumnInfo _info;
		protected int _pos = 0;

		public StatisticSorter() {
			super();
		}
		
		public void setSortedColumn(TreeColumn newSortColumn) {
			// Get the currently designated sort column and turn remove its sorted indicator
			TreeColumn currentColumn = getCurrentSortColumn(newSortColumn.getParent());
			if (currentColumn != null) {
				if (currentColumn == newSortColumn) {
					_sortSequence = -_sortSequence;
				}
				else {
					_sortSequence = -1;
				}
			}
			else {
				_sortSequence = 1;
			}
			_previousSequence = _sortSequence;
			setSortedColumn(_sortSequence, newSortColumn);
		}
		
		public void setSortedColumn(int sortSequence, TreeColumn newSortColumn) {
			_sortSequence = sortSequence;
			_sortColumn = newSortColumn;	
			
			// Get the currently designated sort column and turn remove its sorted indicator
			TreeColumn currentColumn = getCurrentSortColumn(newSortColumn.getParent());
			if (currentColumn != null) {
				String text = currentColumn.getText();
				if (text.startsWith(">") || text.startsWith("<"))
					text = text.substring(1);
				currentColumn.setText(text);
				StatisticTableColumnInfo.getStatisticTableColumnInfo(currentColumn).setSortColumn(false);
			}
			
			String text = newSortColumn.getText();
			_previousColumnText = new String(text);	
			
			_info = StatisticTableColumnInfo.getStatisticTableColumnInfo(newSortColumn);
            _pos = _info.getColumnData().getInitalPos();			
            
			newSortColumn.setText(((_sortSequence > 0) ? ">" : "<") + text);
			StatisticTableColumnInfo.getStatisticTableColumnInfo(newSortColumn).setSortColumn(true);
		}		
		
		public int getSortSequence()
		{
			return _sortSequence;
		}
		
		public String getPreviousSelection(){
			return _previousColumnText;
		}
		
		public void setSortSequence(int sortSequence)
		{
			_sortSequence = sortSequence;
		}

		public TreeColumn getCurrentSortColumn(Tree tree) {
			for (int idx = 0; idx < tree.getColumnCount(); idx++) {
				if (StatisticTableColumnInfo.getStatisticTableColumnInfo(tree.getColumn(idx)).isSortColumn()) {
					return tree.getColumn(idx);
				}
			}
			return null;
		}

		public TreeColumn resetSortColumn(Tree tree) {
			_sortColumn = getCurrentSortColumn(tree);
			return _sortColumn;
		}
	}

	public class StatisticFilter extends ViewerFilter {
		protected String _pattern;
		protected String _prefix = "";
		protected String _suffix = "";
		protected ArrayList _textList;
		protected boolean _caseSensitive = true;
		protected boolean _exactMatch;
		protected boolean _noPattern = true;

		public StatisticFilter() {
			super();
		}

		public void setPattern(String pattern, boolean caseSensitive) {
			_caseSensitive = caseSensitive;
			_pattern = _caseSensitive ? pattern : pattern.toLowerCase();
			if (pattern.equals("*") || pattern.equals("")) {
				_noPattern = true;
			}
			else {
				_noPattern = false;
			}

			_exactMatch = (_pattern.indexOf("*") == -1);

			StringTokenizer st = new StringTokenizer(_pattern, "*");
			_textList = new ArrayList();
			while (st.hasMoreTokens()) {
				_textList.add(st.nextToken());
			}

			if (_pattern.startsWith("*")) {
				_prefix = "";
			}
			else if (_textList.size() > 0) {
				_prefix = (String) _textList.get(0);
				_textList.remove(0);
			}

			if (_pattern.endsWith("*")) {
				_suffix = "";
			}
			else if (_textList.size() > 0) {
				_suffix = (String) _textList.get(_textList.size() - 1);
				_textList.remove(_textList.size() - 1);
			}
		}

		public boolean select(Viewer viewer, Object parent, Object element) {
			
			boolean flag = true;
			
			if (_noPattern)
				return true;
			
			String compareText = "";
			if(element instanceof TRCPackage)
			{
			   compareText = ((TRCPackage)element).getName();
			   if(compareText.equals(""))
			     compareText = TraceUIMessages._87;
			}						
			else if(element instanceof TRCClass)   
			   compareText = ((TRCClass)element).getName();
			else if(element instanceof TRCMethod)   
			   compareText = ((TRCMethod)element).getName()+((TRCMethod)element).getSignature();
			else if(element instanceof TRCObject)  
			{
				TRCObject obj = (TRCObject) element;
				compareText = obj.getIsA().getName();
			   		
			}
			   
			if (!_caseSensitive) {
				compareText = compareText.toLowerCase();
			}
			if (_exactMatch) {
				return compareText.compareTo(_prefix) == 0;
			}
			if (_prefix != "") {
				flag = compareText.startsWith(_prefix);
			}
			if (flag && _suffix != "") {
				flag = compareText.endsWith(_suffix);
			}
			if (flag) {
				for (int k = 0; k < _textList.size(); k++) {
					String str1 = (String) _textList.get(k);

					int index = compareText.lastIndexOf(str1);
					if (index == -1) {
						flag = false;
						break;
					}

					compareText = compareText.substring(index + str1.length());
				}
			}
			return flag;
		}
		
	}
	
	//-------------------------------
	// UpdateAction popup action
	//-------------------------------
	class UpdateAction extends Action {
		public UpdateAction(String name) {
			super(name);
			PlatformUI.getWorkbench().getHelpSystem().setHelp(UpdateAction.this, TraceUIPlugin.getPluginId() + ".uvew0000");

		    PDPluginImages.setImageDescriptors(this,PDPluginImages.T_LCL,PDPluginImages.IMG_UPDATEVIEWS);					

		}

		/**
		 * Invoked when an action occurs.
		 * Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			ProfileEvent event = UIPlugin.getDefault().getRefreshViewEvent(_page.getMOFObject());
			UIPlugin.getDefault().notifyProfileEventListener(event);
		}
	}

	//-------------------------------
	// ChooseColumnsAction popup action
	//-------------------------------
	class ChooseColumnsAction extends Action {
		private ArrayList _cols;
		private String _key;
		public ChooseColumnsAction(String name, ArrayList cols, String key) {
			super(name);
			_cols = cols;
			_key = key;
			PlatformUI.getWorkbench().getHelpSystem().setHelp(ChooseColumnsAction.this, TraceUIPlugin.getPluginId() + ".ccol0000");
			TracePluginImages.setImageDescriptors(this, TracePluginImages.T_LCL, TracePluginImages.IMG_CHOOSECOLUMNS);
		}

		/**
		 * Invoked when an action occurs.
		 * Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			ColumnsDialog dialog =
				new ColumnsDialog(getControl().getShell(), TraceUIMessages._56, null, _cols, getDefaultColumnsTemplate(), getContextHelpId(),getContext());
			dialog.open();

			if (dialog.getReturnCode() == Window.OK) {
				ColumnData.setColumns(dialog.getData(), _cols, _key);
				resetColumns(_cols);
				refresh();
			}
		}
	}   
		//-------------------------------
	// Show percent popup action
	//-------------------------------
	class ShowPercentAction extends Action {
		public ShowPercentAction(String name) {
			super(name);

			PlatformUI.getWorkbench().getHelpSystem().setHelp(ShowPercentAction.this, TraceUIPlugin.getPluginId() + ".clst0003");
		}

		public void setChecked(boolean value) {
			super.setChecked(value);
		}

		/**
		 * Invoked when an action occurs.
		* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			handlePercentChanged();
		}
	}

    /**
     * 
     */
	class DeltaColumnsAction extends Action {
		public DeltaColumnsAction(String name) {
			super(name);
			PlatformUI.getWorkbench().getHelpSystem().setHelp(DeltaColumnsAction.this, TraceUIPlugin.getPluginId() + ".ccol0000");
		}

		public void setChecked(boolean value) {
			super.setChecked(value);
		}
		
		public void run() {
			handleDeltaChanged();
		}
	}

	//-------------------------------
	// ChooseColumnsAction popup action
	//-------------------------------
	class SortByColumnsAction extends Action {
		public SortByColumnsAction(String name) {
			super(name);
			PlatformUI.getWorkbench().getHelpSystem().setHelp(SortByColumnsAction.this, TraceUIPlugin.getPluginId() + ".ccol0000");
			TracePluginImages.setImageDescriptors(this, TracePluginImages.T_LCL, TracePluginImages.IMG_SORTCOLUMNS);
		}
	
		private TreeColumn getTreeColumn(Tree tree, StatisticTableColumnInfo columnInfo)
		{
			for (int idx = 0; idx < tree.getColumnCount(); idx++) {
				StatisticTableColumnInfo treeColumnInfo = getColumnInfo(tree.getColumn(idx));
				if (treeColumnInfo != null && columnInfo != null
						&& columnInfo.getColumnData().name().equals(treeColumnInfo.getColumnData().name())
						&& columnInfo.isDeltaColumn() == treeColumnInfo.isDeltaColumn()) {
					return tree.getColumn(idx);
				}
			}
			return null;
		}
		
		/**
		 * Invoked when an action occurs.
		 * Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			List statisticTableColumnInfoList = new ArrayList();
			
			for (int i = 0; i < getTree().getColumnCount(); i++)
			{
				StatisticTableColumnInfo ci = getColumnInfo(getTree().getColumn(i));
				if (ci != null)
					statisticTableColumnInfoList.add(ci);
			}
			
			
			SortByColumnDialog dialog =	new SortByColumnDialog(getControl().getShell(),
					TraceUIMessages._58,
					null,
					statisticTableColumnInfoList,
					getViewerSorter().getSortSequence());
			
			dialog.open();
			
			if (dialog.getReturnCode() == Window.OK) {
				getViewerSorter().setSortedColumn(dialog.sortSequence(), getTreeColumn(getTree(), dialog.sortColumn()));
				_viewer.refresh();
			}
		}
	}

	protected StatisticView(Composite parent, TraceViewerPage page) {
		
		this(false, parent, page, true);
		
	}

	protected StatisticView(boolean lazyMode, Composite parent, TraceViewerPage page) {
		
		this(lazyMode, parent, page, true);
		
	}

	protected StatisticView(Composite parent, TraceViewerPage page, boolean initializeContent) {
		this(false, parent, page, true);
	}

	protected StatisticView(boolean lazyMode, Composite parent, TraceViewerPage page, boolean initializeContent) {
		super(lazyMode);
		
		_page = page;
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, getContextHelpId());
		
		if(initializeContent)
			createContent(parent);		
	}
	
	public void createContent(Composite parent)
	{
		_toolkit = new HyadesFormToolkit(parent.getDisplay());
		
		_currentColumns = ColumnData.createColumnData(getColumnsPreferencesKey(), getDefaultColumnsTemplate());

		//parse the columns extension
 		ArrayList list=parseExtensions();
 		if ((list!=null)&&(list.size()!=0))
 			_currentColumns.addAll(list);
		
		createControl(parent, _currentColumns);
	    int perc = TraceUIPlugin.getDefault().getPreferenceStore().getInt(buildPreferenceStoreSring(TraceConstants.PERCENTAGE));
	    if(perc == 1)
	        _isShowPercent = true;
	    
	    int delt = TraceUIPlugin.getDefault().getPreferenceStore().getInt(buildPreferenceStoreSring(TraceConstants.DELTA));
	    if(delt == 1)
	        _deltaColumns = true;


		initialize();
		
		tmpList = new ArrayList();
		fSeparator = new Separator();		
	}
	

	public abstract Tree getTree();
	protected abstract IContentProvider getContentProvider();
//	protected abstract void handleSelectionEvent();
	protected abstract Composite createTree(Composite parent, int options);
	protected abstract String getColumnsPreferencesKey();
	protected abstract String getDefaultColumnsTemplate();
	protected abstract TreeViewer getTreeViewer(Tree tree);

	protected void openSourceForSelection(ISelection selection)
	{
		OpenSourceAction action = new OpenSourceAction();

		action.selectionChanged(action,	selection);
		action.run();
	}
	
	protected StructuredViewer createTreeViewer(Composite tree) {
		
		TreeViewer tv = getTreeViewer((Tree) tree);
		tv.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				ISelection selection = event.getSelection();

				if (selection != null && !selection.isEmpty()) {
					TreeViewer tv = (TreeViewer)getTreeViewer();
	                Object node = ((IStructuredSelection)selection).getFirstElement();
	                Object element = node;

	                if(adaptor != null)
	                      node = ContentProviderNewLazyAdaptor.getObject(node);
					
					if(tv.isExpandable(element))
					{
						    tv.setExpandedState(element, !tv.getExpandedState(element));
					}
					else
					{
						if(node instanceof TRCMethod || node instanceof TRCMethodInvocation || node instanceof MethodCallDetails)
							openMethodDetails(selection);
						else	
							openSourceForSelection(selection);
					}
				}
			}

			private void openMethodDetails(ISelection selection) {
				OpenMethodDetailsAction action = new OpenMethodDetailsAction();

				action.selectionChanged(action,	selection);
				action.run();
				
			}
		});
		
		ColumnViewerToolTipSupport.enableFor(tv);
		
		return (StructuredViewer) tv;
	}
	
	
	protected Composite getViewComponent() {
		return _viewComp;
	}

	protected TraceViewerPage getTraceViewerPage() {
		return _page;
	}

	protected ViewForm getDataPane() {
		return _dataPane;
	}

	public void showNewSelection() {
		if (_newSelection) {
			getTree().showSelection();
			_newSelection = false;
		}
	}

	public boolean showingDeltaColumns() {
		return _deltaColumns; 
	}

	protected void setNewSelection() {
		_newSelection = true;
	}

	public Action getUpdateAction() {
		if (_updateAction == null) {
			_updateAction = new UpdateAction(UIPlugin.getResourceString("REFRESH_VIEWS"));
		}
		return _updateAction;
	}

	public Action getDeltaColumnsAction() {
		if (_deltaColumnsAction == null) {
			_deltaColumnsAction = new DeltaColumnsAction(TraceUIMessages._84);
		}
		return _deltaColumnsAction;
	}
	
	public Action getChooseColumnsAction(ArrayList cols, String key) {
		_chooseColumnAction = new ChooseColumnsAction(TraceUIMessages._55, cols, key);

		return _chooseColumnAction;
	}
	
	public Action getSortByColumnAction() {
		_sortByColumnAction = new SortByColumnsAction(TraceUIMessages._57);

		return _sortByColumnAction;
	}
	
	public Action getShowPercentAction() {
		if (_showPercent == null) {
			_showPercent = new ShowPercentAction(TraceUIMessages._13);
		}
		return _showPercent;
	}
	
	public boolean isShowPercent() {
		return _isShowPercent;
	}
	
	public Control getControl() {
		return _viewContainer;
	}
	
	public ArrayList getColumnDataList() {
		return _currentColumns;
	}

	public StructuredViewer getTreeViewer() {
		return _viewer;
	}
	
	public StatisticSorter getViewerSorter() {
		return _viewerSorter;
	}
	
	public StatisticFilter getViewerFilter() {
		return _viewerFilter;
	}

	public Layout getLayout() {
		if (_layout == null)
		{
			_layout = new ColumnLayout();
			((ColumnLayout)_layout).maxNumColumns = 100;
		}
		return _layout;
	}

//	protected abstract void updateButtons();

	public abstract void updateModelSelection();
	

	/*
	 * @see ControlListener#controlMoved(ControlEvent)
	 */
	public void controlMoved(ControlEvent arg0) {
	}

	/*
	 * @see ControlListener#controlResized(ControlEvent)
	 */
	public void controlResized(ControlEvent arg0) {
		/* Get the client area for the shell */
		Rectangle dataBounds = getViewComponent().getClientArea();
		getDataPane().setBounds(dataBounds.x, dataBounds.y, dataBounds.width, dataBounds.height);

		// If the table column was resized, update the ColumnData array with the new size
		// and save the new column definitions to the preferences.
		if (arg0.getSource() instanceof TableColumn) {
			ColumnData.setColumns(getColumnDataList(), getColumnsPreferencesKey());
		}
	}

	/*
	 * @see IMenuListener#menuAboutToShow(IMenuManager)
	 */
	public void menuAboutToShow(IMenuManager arg0) {
	}

	protected void setRedrawTable(boolean redraw)
	{
		(_viewer.getControl()).setRedraw(redraw);
	}
	
	/*
	 * This method handles a selection event
	 */
	public void refresh() {
		super.refresh();
	}
	
	protected void doRefresh(boolean isPostponedOperation,
			int processedOperations) {
		//showPercentUpdate();
		if((!isPostponedOperation || (processedOperations & LAZY_UPDATE) == 0)
				&& !getTreeViewer().getControl().isDisposed())	
			update();
	}

	/*
	 * This method handles a selection event
	 */
	public void selectionChanged() {
		
			handleSelectionEvent();
		
	}
	

	public void updateUI(ArrayList cols) {
		updateUI();
	}

	protected void doUpdateUI(boolean isPostponedOperation,
			int processedOperations) {
		if(!isPostponedOperation){
			update();
			updateButtons();
		} else {
			if((processedOperations & LAZY_UPDATE) == 0)
				update();
			if((processedOperations & LAZY_UPDATE_BUTTONS) == 0)
				updateButtons();
		}
	}

	protected boolean _firstTime = true;
	
	protected abstract StatisticSorter getViewerSorterInstance();
	
	protected void showPercentUpdate()
	{
	}

	protected void setLinesVisible(Tree tree)
	{
	}
	
	protected void firstTimeUpdate()
	{
		Tree tree = getTree();
		setLinesVisible(tree);
		_viewerSorter = getViewerSorterInstance();
		
		_firstTime=false;
		if(_previousColumnText != null){
			for(int i = 0; i < tree.getColumnCount(); i++) {
				if(tree.getColumn(i).getText().equals(_previousColumnText)) {
					_viewerSorter.setSortedColumn(_previousSequence,tree.getColumn(i));
					return;
				}
				
			}
				String s1 = "package.base.time";
				String s2 = "class.base.time";
				String s3 = "method.base.time";
				for(int n=0; n<tree.getColumnCount(); n++){
					if(tree.getColumn(n).getText().equals(s1) ||
						tree.getColumn(n).getText().equals(s2) ||
						tree.getColumn(n).getText().equals(s3)) {						
						_viewerSorter.setSortedColumn(tree.getColumn(n));
						_viewer.setSorter(_viewerSorter);
						break;}
			}
		}else{
			_previousColumnText = "package.base.time";
			for(int k=0; k<tree.getColumnCount(); k++){

				if(tree.getColumn(k).getText().equals(_previousColumnText)){
					_viewerSorter.setSortedColumn(tree.getColumn(k));
					_viewer.setSorter(_viewerSorter);}
				}
			}
	}
	
	protected int updateTableGetColumnNumber()
	{
		return 0;
	}
	
	protected void postUpdateEvents()
	{
        handleSelectionEvent();
	}	
	
	protected void expandFirstElement()
	{
	}	
	
	protected String getContext()
	{
		IContextViewer viewer = getContextViewer();
		if (viewer != null)
			return viewer.getSelectedContext();
		else
			return null;
	}
	
	protected boolean contextChanged()
	{
		IContextViewer viewer = getContextViewer();
		if (viewer != null)
		{
			if (viewer.contextChanged())
				return true;
			else
			{
				viewer.setSelectedContext(ContextUpdaterHelper.getCurrentContext(ContextUpdaterHelper.getContexts(_page.getMOFObject()), viewer), false);
				return viewer.contextChanged(); 
			}
		}
		else
			return false;
	}
	
	protected void updateContext()
	{
		resetColumns(_currentColumns);
		
		IContextViewer viewer = getContextViewer();
		if (viewer != null)
			viewer.updateContext();
	}
	

	private IContextViewer getContextViewer()
	{
		if (_page != null)
		{
			TraceViewer traceViewer = _page.getTraceViewer();
			
			if (traceViewer != null && traceViewer instanceof IContextViewer)
				return (IContextViewer)traceViewer;
		}
		
		return null;
	}

	public void update() {
		super.update();
	}

	protected void doUpdate(boolean refresh, boolean isPostponedOperation,
			int processedOperations) {
		
		// Bug 259189 - save the expanded elements
		TreeViewer tv = (TreeViewer)_viewer;
		Object[] expandedElements = tv.getExpandedElements();
		
		if (_firstTime)
			firstTimeUpdate();

		if (contextChanged() || _page.getTraceViewer().contextHandlerSelectionChanged()) // context changes or context handler selection changes
			updateContext();
		
		IContextViewer viewer = getContextViewer();
		if (viewer != null)
			viewer.getContextSelectionMenuListener().setMOFObject(_page.getMOFObject());
		
		// set the input of the viewer		
		showPercentUpdate();

		setRedrawTable(false);

        getTreeViewer().setInput(_page.getMOFObject());

        //_viewer.refresh();
		expandFirstElement();		
				
		postUpdateEvents();

		// Bug 259189 - restore the expanded elements
		for (Object e : expandedElements) {
			if(e != null) {
				tv.setExpandedState(e, true);
			}
		}
		
		setRedrawTable(true);

	}

	/**
	* This method is called as a result of changing the selected columns.
	* It takes the new column definition list and adjusts the columns of the
	* table to match this list.
	*/
	protected void resetColumns(ArrayList list) {
		String sortedColumnKey=""; //store sorted column
		boolean isDeltaColumn = false;
		if(_firstTime&&_viewerSorter==null)
			_viewerSorter=this.getViewerSorterInstance();
		int sortSequence = _viewerSorter.getSortSequence(); //store sorted sequence
	
		Tree tree = getTree();

		setRedrawTable(false);
	
		// Dispose all the existing columns
		for (int idx = tree.getColumnCount(); idx > 0; idx--) {
			TreeColumn col = tree.getColumn(tree.getColumnCount() - 1);
			StatisticTableColumnInfo staticTblColInfo = (StatisticTableColumnInfo)(col.getData());
			if (staticTblColInfo.isSortColumn())
			{
				sortedColumnKey = staticTblColInfo.getColumnData().key();			
				isDeltaColumn = staticTblColInfo.isDeltaColumn();
			}
			col.dispose();
		}
	
		for (int idx = 0; idx < list.size(); idx++) {
			ColumnData data = (ColumnData) list.get(idx);
			data.setContext(getContext());
			if (data.visible()) {
				new StatisticTableColumnInfo(this, data, _deltaColumns);
			}
		}
		
		tree = getTree();
		for (int idx = 0; idx < tree.getColumnCount(); idx++) {
			StatisticTableColumnInfo treeColumnInfo = getColumnInfo(tree.getColumn(idx));
			if (treeColumnInfo != null && sortedColumnKey.equals(treeColumnInfo.getColumnData().key())
					&& isDeltaColumn == treeColumnInfo.isDeltaColumn()) {
				treeColumnInfo.setSortColumn(true);
				break;
			}
		}

		
		if (_viewerSorter.resetSortColumn(getTree()) == null) {
			_viewer.setSorter(null);
		}
		else {
			_viewerSorter.setSortSequence(sortSequence*-1);
			_viewerSorter.setSortedColumn(_viewerSorter.resetSortColumn(getTree()));
			_viewer.setSorter(_viewerSorter);
		}
		
		setRedrawTable(true);
	}

	protected Composite createControl(Composite parent, ArrayList cols) {
		GridLayout layout;
		GridData data;

		_viewContainer = _toolkit.createComposite(parent, SWT.FLAT);
		layout = new GridLayout();
		layout.numColumns = 1;
		_viewContainer.setLayout(layout);
		_viewContainer.setLayoutData(GridUtil.createFill());
				
		_viewComp = _toolkit.createComposite(_viewContainer, SWT.FLAT);
		layout = new GridLayout();
		layout.numColumns = 1;
		_viewComp.setLayout(layout);
		data = GridUtil.createFill();
		_viewComp.setLayoutData(data);

		_dataPane = _toolkit.createViewForm(_viewComp);
		Control table = createTableViewer(_dataPane, cols);
		_dataPane.setContent(table);

		_dataPane.setLayoutData(GridUtil.createFill());

		_viewContainer.addControlListener(this);
		
		return _viewContainer;
	}
	
	private Control createTableViewer(Composite parent, ArrayList cols) {
		Composite tree = createTree(parent, SWT.SINGLE | SWT.FULL_SELECTION | SWT.FLAT);

		// Create the TableTree Viewer
		_viewer = createTreeViewer(tree);

		for (int idx = 0; idx < cols.size(); idx++) {
			ColumnData data = (ColumnData) cols.get(idx);
			data.setContext(getContext());
			if (data.visible()) {
				new StatisticTableColumnInfo(this, data, _deltaColumns);
			}
		}

		Tree tre = getTree();
		tre.setLinesVisible(true);
		tre.setHeaderVisible(true);
		tre.setLayout(getLayout());
		tre.setLayoutData(new GridData(GridData.FILL_BOTH));
		if((tre.getStyle() & SWT.VIRTUAL) != 0 && _viewer instanceof FragmentedTreeViewer){
			IContentProvider cp = getContentProvider();
			if(cp instanceof ITreeContentProvider){
				ITableLabelProvider lp = (ITableLabelProvider)getTableLabelProvider();
				ContentProviderNewLazyAdaptor adaptor = new ContentProviderNewLazyAdaptor((ITreeContentProvider)cp, null, null);
				wrappedLp = (LabelProvider)adaptor.wrapLableProvider(lp);
				_viewer.setContentProvider(adaptor);
//				_viewer.setLabelProvider(lp);
				this.adaptor = adaptor;
			}
		}

		if(adaptor == null){
		// add the content provider
			_viewer.setContentProvider(getContentProvider());

		//label provider is added in the StatisticTableColumnInfo class
		//with CellLabelProvider added for each column in the view.
        //bug 80440
		// add the label provider
		// _viewer.setLabelProvider(getTableLabelProvider());
		}

		if (tree instanceof Tree) {
			((Tree) tree).addSelectionListener(this.getSelectionListener());
		}

		UIPlugin.getDefault().addViewSelectionChangedListener(this);
        
		return _viewer.getControl();
	}

	public void dispose() {
		
		UIPlugin.getDefault().removeViewSelectionChangedListener(this);
		
		_page = null;
	}

	private void initialize() {
		if (_initialized)
			return;

		_initialized = true;

	}
	
	public abstract LabelProvider getTableLabelProvider();
	
	public abstract CellLabelProvider getCellLabelProvider(ColumnData colData);

    public void handlePercentChanged()
	{			
		_isShowPercent = !_isShowPercent;
		TraceUIPlugin.getDefault().getPreferenceStore()
			.setValue(buildPreferenceStoreSring(TraceConstants.PERCENTAGE), (_isShowPercent?1:0));
		
		refresh();
		
		updateButtons();
	}
    
    protected abstract String getViewTypeStr();
    
    public void handleDeltaChanged()
    {
    	_deltaColumns = !_deltaColumns;

    	TraceUIPlugin.getDefault().getPreferenceStore()
		.setValue(buildPreferenceStoreSring(TraceConstants.DELTA), (_deltaColumns?1:0));
    	
    	
    	resetColumns(_currentColumns);
    	refresh();
    }
    
    protected String buildPreferenceStoreSring(String str)
    {
    	return getViewTypeStr() + "." + str;
    }
    
    /**
 	 * This method should be implemented in the childs 
 	 * @return
 	 */
 	protected ArrayList parseExtensions(){return null;}
	
 	public void notifyViewSelectionChanged(Object source, Object selection) {
		UIPlugin.getDefault().getSelectionModel(_page.getMOFObject()).add(selection);
			
		ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
		event.setSource(source);
		UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
	}
	/**
	 * @return Returns the _toolkit.
	 */
	public HyadesFormToolkit getToolkit() {
		return _toolkit;
	}
	
	protected StatisticTableColumnInfo getColumnInfo(TreeColumn treeColumn) {
		if (treeColumn.getData() !=null &&	treeColumn.getData() instanceof StatisticTableColumnInfo)
			return (StatisticTableColumnInfo)treeColumn.getData();
		
		return null;
	}	
	

//	public static String getContext(EObject eObject)
//	{
//		return ContextUpdaterHelper.getContext(eObject);
//	}
//	
//	public IContextLabelFormatProvider getContextFormatter(Object object, String attributeId)
//	{
//		return getContextFormatter(getContext((EObject)object), attributeId);
//	}
//	
//	public static IContextLabelFormatProvider getContextFormatter(String context, String attributeId)
//	{
//		return ContextManager.instance().getContextProvider(context).getContextLabelFormatProvider(attributeId);
//	}
	
	protected int compareElements(Object obj1, Object obj2, ColumnLabelAdapter col, boolean isDeltaColumn)
	{
		//ColumnDisplayInfo info1 = getColumnDisplayInfo(col1, isDeltaColumn);
		ColumnDisplayInfo info = getColumnDisplayInfo(col, isDeltaColumn);		
		
		return ColumnLabelComparator.compare(obj1, obj2, col, info);
	}
	
	protected String getElementColumnText(Object obj, ColumnLabelAdapter col, boolean isDeltaColumn)
	{
		ColumnDisplayInfo info = getColumnDisplayInfo(col, isDeltaColumn);
		
		return col.getDisplayString(obj, info);		
	}
	
	protected Image getElementColumnImage(Object obj, ColumnLabelAdapter col, boolean isDeltaColumn)
	{
		ColumnDisplayInfo info = getColumnDisplayInfo(col, isDeltaColumn);
		
		return col.getDisplayImage(obj, info);		
	}	
	
	protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn)
	{
		return col.getColumnDisplayInfo();
	}
	
	protected String getContextHelpId()
	{
		return null;
	}

	//defined for backwards compatibility purposes
	protected void doHandleSelectionEvent(boolean isPostponedOperation,
			int processedOperations) {
	}

	//defined for backwards compatibility purposes
	protected void doHandleViewSelectionChangedEvent(
			ViewSelectionChangedEvent event, boolean isPostponedOperation,
			int processedOperations) {
	}

	//defined for backwards compatibility purposes
	protected void doUpdateButtons(boolean isPostponedOperation,
			int processedOperations) {
	}

	// Bug 299440 - This selection listener was originally implemented in the
	// statistics view class above. I moved it into its own class for convenience,
	// (the contents of the listener remain the same, otherwise) - jgw
	class StatViewSelectionListener implements SelectionListener {
		public StatViewSelectionListener() {
		}

		public void widgetSelected(SelectionEvent arg0) {
			
			if (arg0.widget instanceof TreeColumn) {

				_viewerSorter.setSortedColumn((TreeColumn) arg0.widget);
				if(adaptor != null){
					adaptor.setViewerComparator(_viewerSorter);
				} else {
					_viewer.setSorter(_viewerSorter);
				}
				_viewer.refresh();
			}
			else if (arg0.widget instanceof Table || arg0.widget instanceof Tree) {
								
				updateModelSelection();
			}

			updateButtons();
		}

		public void widgetDefaultSelected(SelectionEvent e) {
			// stub
		}

				
	}
	
	public SelectionListener getSelectionListener() {
		return new StatViewSelectionListener();
	}
	
}
