/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SummaryGraphSource.java,v 1.1 2006/09/21 19:19:29 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.ui.widgets.grapher.GraphSource;
import org.eclipse.swt.graphics.Color;

public class SummaryGraphSource implements GraphSource {
	public static class GraphDataItem {
		public double x;
		public double y;
		
		public GraphDataItem(final double x, final double y) {
			this.x = x;
			this.y = y;
		}
	}

	private final List dataList = new ArrayList();
	private final String name;
	private final Color color;
	private final GraphDataItem minValue = new GraphDataItem(0, 0); 
	private final GraphDataItem maxValue = new GraphDataItem(0, 0);
	
	public SummaryGraphSource(final String name, final Color color) {
		this.name = name;
		this.color = color;
	}
	
	public final String getName() {
		return name;
	}
	
	public final Color getColor() {
		return color;
	}
	
	public void addData(final GraphDataItem data) {
		dataList.add(data);
		if (minValue.x > data.x) {
			minValue.x = data.x;
		}
		if (maxValue.x < data.x) {
			maxValue.x = data.x;
		}
		if (minValue.y > data.y) {
			minValue.y = data.y;
		}
		if (maxValue.y < data.y) {
			maxValue.y = data.y;
		}
	}

	public double getValueMax() {
		return maxValue.y;
	}

	public double getValueMin() {
		return minValue.y;
	}

	public double getMax() {
		return maxValue.x;
	}

	public double getMin() {
		return minValue.x;
	}

	public double getAverageBetween(double x, double x2) {
		return getValueAt(x);
	}

	public double getCountBetween(double x, double x2) {
		return getValueAt(x);
	}

	public double getMaxBetween(double x, double x2) {
		return getValueAt(x);
	}

	public double getMinBetween(double x, double x2) {
		return getValueAt(x);
	}

	public double getSessionMax() {
		return 0;
	}

	public double getSessionMin() {
		return 0;
	}

	public double getStandardDeviationBetween(double x, double x2) {
		return getValueAt(x);
	}

	public double getSumBetween(double x, double x2) {
		return getValueAt(x);
	}

	public double getValueAt(double x) {
		if (x < minValue.x || x > maxValue.x || dataList.isEmpty()) {
			return 0;
		}
		for (int i = 0; i < dataList.size(); i++) {
			GraphDataItem dataItem = (GraphDataItem) dataList.get(i);
			if (x >= dataItem.x) {
				return dataItem.y;
			}
		}
		return ((GraphDataItem)dataList.get(dataList.size() - 1)).y;
	}
}
