/********************************************************************** 
 * Copyright (c) 2005, 2006  IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: BasicContextProvider.java,v 1.8 2006/10/11 21:41:17 ewchan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal.context.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ActiveSizeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.AgentNameAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.AvgBaseTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.CPUTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.CallsAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ClassBaseTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ClassCallsAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ClassCollectInstAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ClassCumulTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ClassInhBaseTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ClassInhCallsAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ClassInhCumulTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ClassNameAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ClassTotalInstAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ClassTotalSizeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.CoverageMethodsHitAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.CoverageMethodsMissedAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.CoverageMethodsPercHitAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.GarbageCollectedObjectLabel;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.LiveInstancesAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodAvgTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodBaseTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodCallsAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodCumulTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodInvEntryTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodInvocationAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodMaxTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodMinTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodNameAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodPercentPerThreadAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.MethodQualifiedNameAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.NumberReferencesByAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.NumberReferencesToAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ObjectBaseTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ObjectCallsAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ObjectCollectedAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ObjectCumulTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ObjectIdAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ObjectNameAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ObjectSizeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.PackageBaseTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.PackageCallsAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.PackageCollectInstAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.PackageCumulTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.PackageInhBaseTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.PackageInhCallsAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.PackageInhCumulTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.PackageNameAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.PackageTotalInstAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.PackageTotalSizeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.RawCumulTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ReferenceDetailsByAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ReferenceDetailsToAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ReferenceSizeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ShowClassLevelLabel;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ShowInstanceLevelLabel;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ShowMethodLevelLabel;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ShowPackageLevelLabel;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadBlockCountAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadBlockedTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadClassNameAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadDeadlockCountAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadDeadlockedTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadStateAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadIdAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadNameAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadRunningTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadSleepingTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadStartTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadStopTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.ThreadWaitingTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.TopBaseTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.TopCallsAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.TopCollectedInstAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.TopCollectedSizeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.TopCumulTimeAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.TopTotalInstAttrLP;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.TopTotalSizeAttrLP;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.hyades.ui.provisional.context.IContextProvider;

public class BasicContextProvider implements IContextProvider {

	private Map contextLabelFormatProviders;
	private ArrayList supportAttributes;

	public BasicContextProvider()
	{
		contextLabelFormatProviders = new HashMap();
		supportAttributes = new ArrayList();
		

		supportAttributes.add(IContextAttributes.SHOW_PACKAGE_LEVEL);
		supportAttributes.add(IContextAttributes.SHOW_CLASS_LEVEL);
		supportAttributes.add(IContextAttributes.SHOW_METHOD_LEVEL);
		supportAttributes.add(IContextAttributes.SHOW_INSTANCE_LEVEL);
		
		supportAttributes.add(IContextAttributes.GARBAGE_COLLECTED_OBJECT);
		
		supportAttributes.add(IContextAttributes.PACKAGE_NAME);
		supportAttributes.add(IContextAttributes.CLASS_NAME);
		supportAttributes.add(IContextAttributes.METHOD_NAME);
		supportAttributes.add(IContextAttributes.THREAD_NAME);

		supportAttributes.add(IContextAttributes.FT_THREAD_ID);
		
		supportAttributes.add(IContextAttributes.PACKAGE_BASE_TIME);
		supportAttributes.add(IContextAttributes.PACKAGE_AVG_BASE_TIME);
		supportAttributes.add(IContextAttributes.PACKAGE_INH_BASE_TIME);
		supportAttributes.add(IContextAttributes.PACKAGE_CUMULATIVE_TIME);
		supportAttributes.add(IContextAttributes.PACKAGE_INH_CUMULATIVE_TIME);
		supportAttributes.add(IContextAttributes.PACKAGE_CPU_TIME);
		supportAttributes.add(IContextAttributes.PACKAGE_CALLS);
		supportAttributes.add(IContextAttributes.PACKAGE_INH_CALLS);
		supportAttributes.add(IContextAttributes.PACKAGE_TOTAL_INST);
		supportAttributes.add(IContextAttributes.PACKAGE_LIVE_INST);
		supportAttributes.add(IContextAttributes.PACKAGE_COLLECTED_INST);
		supportAttributes.add(IContextAttributes.PACKAGE_TOTAL_SIZE);
		supportAttributes.add(IContextAttributes.PACKAGE_ACTIVE_SIZE);
		
		supportAttributes.add(IContextAttributes.CLASS_BASE_TIME);
		supportAttributes.add(IContextAttributes.CLASS_AVG_BASE_TIME);
		supportAttributes.add(IContextAttributes.CLASS_INH_BASE_TIME);
		supportAttributes.add(IContextAttributes.CLASS_CUMULATIVE_TIME);
		supportAttributes.add(IContextAttributes.CLASS_INH_CUMULATIVE_TIME);
		supportAttributes.add(IContextAttributes.CLASS_CPU_TIME);	
		supportAttributes.add(IContextAttributes.CLASS_CALLS);
		supportAttributes.add(IContextAttributes.CLASS_INH_CALLS);
		supportAttributes.add(IContextAttributes.CLASS_TOTAL_INST);
		supportAttributes.add(IContextAttributes.CLASS_LIVE_INST);
		supportAttributes.add(IContextAttributes.CLASS_COLLECTED_INST);
		supportAttributes.add(IContextAttributes.CLASS_TOTAL_SIZE);
		supportAttributes.add(IContextAttributes.CLASS_ACTIVE_SIZE);

		supportAttributes.add(IContextAttributes.METHOD_BASE_TIME);
		supportAttributes.add(IContextAttributes.METHOD_AVG_BASE_TIME);
		supportAttributes.add(IContextAttributes.METHOD_CUMULATIVE_TIME);
		supportAttributes.add(IContextAttributes.METHOD_RAW_CUMULATIVE_TIME);
		supportAttributes.add(IContextAttributes.METHOD_CPU_TIME);	
		supportAttributes.add(IContextAttributes.METHOD_CALLS);
		supportAttributes.add(IContextAttributes.METHOD_START_TIME);	
		supportAttributes.add(IContextAttributes.METHOD_INVOCATIONS);
		supportAttributes.add(IContextAttributes.METHOD_MIN_TIME);	
		supportAttributes.add(IContextAttributes.METHOD_MAX_TIME);	
		supportAttributes.add(IContextAttributes.METHOD_AVG_TIME);
		supportAttributes.add(IContextAttributes.METHOD_PERCENT_PER_THREAD);
		supportAttributes.add(IContextAttributes.METHOD_QUALIFIED_NAME);
		
		supportAttributes.add(IContextAttributes.COVERAGE_CALLS);
		supportAttributes.add(IContextAttributes.COVERAGE_METHOD_MISSED);
		supportAttributes.add(IContextAttributes.COVERAGE_METHOD_HIT);
		supportAttributes.add(IContextAttributes.COVERAGE_METHOD_PERC_HIT);
		
		supportAttributes.add(IContextAttributes.FT_OBJECT_ID);
		
		supportAttributes.add(IContextAttributes.OBJECT_NAME);

		supportAttributes.add(IContextAttributes.OBJECT_CALLS);
		supportAttributes.add(IContextAttributes.OBJECT_BASE_TIME);
		supportAttributes.add(IContextAttributes.OBJECT_CUMULATIVE_TIME);
		supportAttributes.add(IContextAttributes.OBJECT_CPU_TIME);
		supportAttributes.add(IContextAttributes.OBJECT_COLLECTED);
		supportAttributes.add(IContextAttributes.OBJECT_SIZE);
		supportAttributes.add(IContextAttributes.OBJECT_ACTIVE_SIZE);

		supportAttributes.add(IContextAttributes.THREAD_CLASS_NAME);
		supportAttributes.add(IContextAttributes.THREAD_START_TIME);
		supportAttributes.add(IContextAttributes.THREAD_STOP_TIME);
		supportAttributes.add(IContextAttributes.THREAD_STATE);
		supportAttributes.add(IContextAttributes.THREAD_RUNNING_TIME);
		supportAttributes.add(IContextAttributes.THREAD_SLEEPING_TIME);
		supportAttributes.add(IContextAttributes.THREAD_WAITING_TIME);
		supportAttributes.add(IContextAttributes.THREAD_BLOCKED_TIME);
		supportAttributes.add(IContextAttributes.THREAD_DEADLOCKED_TIME);
		supportAttributes.add(IContextAttributes.THREAD_BLOCK_COUNT);
		supportAttributes.add(IContextAttributes.THREAD_DEADLOCK_COUNT);
		
		supportAttributes.add(IContextAttributes.REF_SIZE);
		supportAttributes.add(IContextAttributes.REF_NUMBER_BY);
		supportAttributes.add(IContextAttributes.REF_NUMBER_TO);
		supportAttributes.add(IContextAttributes.REF_DETAILS_BY);
		supportAttributes.add(IContextAttributes.REF_DETAILS_TO);
		
		supportAttributes.add(IContextAttributes.FT_AGENT_NAME);	
		
		supportAttributes.add(IContextAttributes.FT_TOP_BASE_TIME);
		supportAttributes.add(IContextAttributes.FT_TOP_CUMULATIVE_TIME);
		supportAttributes.add(IContextAttributes.FT_TOP_CALLS);
		supportAttributes.add(IContextAttributes.FT_TOP_TOTAL_SIZE);
		supportAttributes.add(IContextAttributes.FT_TOP_COLLECTED_SIZE);	
		supportAttributes.add(IContextAttributes.FT_TOP_TOTAL_INST);
		supportAttributes.add(IContextAttributes.FT_TOP_COLLECTED_INST);
	
	}
	
	public String getName() {
		return TraceUIMessages._225;
	}

	public String getDescription() {
		// TODO Auto-generated method stub
		return null;
	}

	public String[] getSupportAttributes() {
		String[] supportAttributesA = new String[supportAttributes.size()];
		supportAttributes.toArray(supportAttributesA);
		return supportAttributesA;		
	}


	public IContextLabelFormatProvider getContextLabelFormatProvider(String key) {
		Object result = contextLabelFormatProviders.get(key);	
		if (result != null) {
			return (IContextLabelFormatProvider)result;
		}
		else {
			if (supportAttributes.contains(key)) {
				if (key.equals(IContextAttributes.SHOW_PACKAGE_LEVEL)) result = new ShowPackageLevelLabel();
				if (key.equals(IContextAttributes.SHOW_CLASS_LEVEL)) result = new ShowClassLevelLabel();
				if (key.equals(IContextAttributes.SHOW_METHOD_LEVEL)) result = new ShowMethodLevelLabel();
				if (key.equals(IContextAttributes.SHOW_INSTANCE_LEVEL)) result = new ShowInstanceLevelLabel();
				
				if (key.equals(IContextAttributes.GARBAGE_COLLECTED_OBJECT)) result = new GarbageCollectedObjectLabel();
				
				if (key.equals(IContextAttributes.PACKAGE_NAME)) result = new PackageNameAttrLP();
				if (key.equals(IContextAttributes.CLASS_NAME)) result = new ClassNameAttrLP();
				if (key.equals(IContextAttributes.METHOD_NAME)) result = new MethodNameAttrLP();
				if (key.equals(IContextAttributes.THREAD_NAME)) result = new ThreadNameAttrLP();

				if (key.equals(IContextAttributes.FT_THREAD_ID)) return new ThreadIdAttrLP();
				
				if (key.equals(IContextAttributes.PACKAGE_BASE_TIME)) result = new PackageBaseTimeAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_AVG_BASE_TIME)) result = new AvgBaseTimeAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_INH_BASE_TIME)) result = new PackageInhBaseTimeAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_CUMULATIVE_TIME)) result = new PackageCumulTimeAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_INH_CUMULATIVE_TIME)) result = new PackageInhCumulTimeAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_CPU_TIME)) result = new CPUTimeAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_CALLS)) result = new PackageCallsAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_INH_CALLS)) result = new PackageInhCallsAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_TOTAL_INST)) result = new PackageTotalInstAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_LIVE_INST)) result = new LiveInstancesAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_COLLECTED_INST)) result = new PackageCollectInstAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_TOTAL_SIZE)) result = new PackageTotalSizeAttrLP();
				if (key.equals(IContextAttributes.PACKAGE_ACTIVE_SIZE)) result = new ActiveSizeAttrLP();
				
				if (key.equals(IContextAttributes.CLASS_BASE_TIME)) result = new ClassBaseTimeAttrLP();
				if (key.equals(IContextAttributes.CLASS_AVG_BASE_TIME)) result = new AvgBaseTimeAttrLP();
				if (key.equals(IContextAttributes.CLASS_INH_BASE_TIME)) result = new ClassInhBaseTimeAttrLP();
				if (key.equals(IContextAttributes.CLASS_CUMULATIVE_TIME)) result = new ClassCumulTimeAttrLP();
				if (key.equals(IContextAttributes.CLASS_INH_CUMULATIVE_TIME)) result = new ClassInhCumulTimeAttrLP();
				if (key.equals(IContextAttributes.CLASS_CPU_TIME)) result = new CPUTimeAttrLP();
				if (key.equals(IContextAttributes.CLASS_CALLS)) result = new ClassCallsAttrLP();
				if (key.equals(IContextAttributes.CLASS_INH_CALLS)) result = new ClassInhCallsAttrLP();
				if (key.equals(IContextAttributes.CLASS_TOTAL_INST)) result = new ClassTotalInstAttrLP();
				if (key.equals(IContextAttributes.CLASS_LIVE_INST)) result = new LiveInstancesAttrLP();
				if (key.equals(IContextAttributes.CLASS_COLLECTED_INST)) result = new ClassCollectInstAttrLP();
				if (key.equals(IContextAttributes.CLASS_TOTAL_SIZE)) result = new ClassTotalSizeAttrLP();
				if (key.equals(IContextAttributes.CLASS_ACTIVE_SIZE)) result = new ActiveSizeAttrLP();

				if (key.equals(IContextAttributes.METHOD_BASE_TIME)) result = new MethodBaseTimeAttrLP();
				if (key.equals(IContextAttributes.METHOD_AVG_BASE_TIME)) result = new AvgBaseTimeAttrLP();
				if (key.equals(IContextAttributes.METHOD_CUMULATIVE_TIME)) result = new MethodCumulTimeAttrLP();
				if (key.equals(IContextAttributes.METHOD_RAW_CUMULATIVE_TIME)) result = new RawCumulTimeAttrLP();
				if (key.equals(IContextAttributes.METHOD_CPU_TIME)) result = new CPUTimeAttrLP();
				if (key.equals(IContextAttributes.METHOD_CALLS)) result = new MethodCallsAttrLP();
				if (key.equals(IContextAttributes.METHOD_START_TIME)) result = new MethodInvEntryTimeAttrLP();
				if (key.equals(IContextAttributes.METHOD_INVOCATIONS)) result = new MethodInvocationAttrLP();
				
				if (key.equals(IContextAttributes.METHOD_MIN_TIME)) result = new MethodMinTimeAttrLP();
				if (key.equals(IContextAttributes.METHOD_MAX_TIME)) result = new MethodMaxTimeAttrLP();
				if (key.equals(IContextAttributes.METHOD_AVG_TIME)) result = new MethodAvgTimeAttrLP();
				if (key.equals(IContextAttributes.METHOD_PERCENT_PER_THREAD)) result = new MethodPercentPerThreadAttrLP();
				if (key.equals(IContextAttributes.METHOD_QUALIFIED_NAME)) result = new MethodQualifiedNameAttrLP();
				
				if (key.equals(IContextAttributes.COVERAGE_CALLS)) result = new CallsAttrLP();
				if (key.equals(IContextAttributes.COVERAGE_METHOD_MISSED)) result = new CoverageMethodsMissedAttrLP();
				if (key.equals(IContextAttributes.COVERAGE_METHOD_HIT)) result = new CoverageMethodsHitAttrLP();
				if (key.equals(IContextAttributes.COVERAGE_METHOD_PERC_HIT)) result = new CoverageMethodsPercHitAttrLP();
				
				if (key.equals(IContextAttributes.FT_OBJECT_ID)) result = new ObjectIdAttrLP();
				
				if (key.equals(IContextAttributes.OBJECT_NAME)) result = new ObjectNameAttrLP();

				if (key.equals(IContextAttributes.OBJECT_CALLS)) result = new ObjectCallsAttrLP();
				if (key.equals(IContextAttributes.OBJECT_BASE_TIME)) result = new ObjectBaseTimeAttrLP();
				if (key.equals(IContextAttributes.OBJECT_CUMULATIVE_TIME)) result = new ObjectCumulTimeAttrLP();
				if (key.equals(IContextAttributes.OBJECT_CPU_TIME)) result = new CPUTimeAttrLP();
				if (key.equals(IContextAttributes.OBJECT_COLLECTED)) result = new ObjectCollectedAttrLP();
				if (key.equals(IContextAttributes.OBJECT_SIZE)) result = new ObjectSizeAttrLP();
				if (key.equals(IContextAttributes.OBJECT_ACTIVE_SIZE)) result = new ActiveSizeAttrLP();

				if (key.equals(IContextAttributes.THREAD_CLASS_NAME)) result = new ThreadClassNameAttrLP();
				if (key.equals(IContextAttributes.THREAD_START_TIME)) result = new ThreadStartTimeAttrLP();
				if (key.equals(IContextAttributes.THREAD_STOP_TIME)) result = new ThreadStopTimeAttrLP();
				if (key.equals(IContextAttributes.THREAD_STATE)) result = new ThreadStateAttrLP();
				if (key.equals(IContextAttributes.THREAD_RUNNING_TIME)) result = new ThreadRunningTimeAttrLP();
				if (key.equals(IContextAttributes.THREAD_SLEEPING_TIME)) result = new ThreadSleepingTimeAttrLP();
				if (key.equals(IContextAttributes.THREAD_WAITING_TIME)) result = new ThreadWaitingTimeAttrLP();
				if (key.equals(IContextAttributes.THREAD_BLOCKED_TIME)) result = new ThreadBlockedTimeAttrLP();
				if (key.equals(IContextAttributes.THREAD_DEADLOCKED_TIME)) result = new ThreadDeadlockedTimeAttrLP();
				if (key.equals(IContextAttributes.THREAD_BLOCK_COUNT)) result = new ThreadBlockCountAttrLP();
				if (key.equals(IContextAttributes.THREAD_DEADLOCK_COUNT)) result = new ThreadDeadlockCountAttrLP();
				
				if (key.equals(IContextAttributes.REF_SIZE)) result = new ReferenceSizeAttrLP();
				if (key.equals(IContextAttributes.REF_NUMBER_TO)) result = new NumberReferencesToAttrLP();
				if (key.equals(IContextAttributes.REF_NUMBER_BY)) result = new NumberReferencesByAttrLP();
				if (key.equals(IContextAttributes.REF_DETAILS_BY)) result = new ReferenceDetailsByAttrLP();
				if (key.equals(IContextAttributes.REF_DETAILS_TO)) result = new ReferenceDetailsToAttrLP();

				
				if (key.equals(IContextAttributes.FT_AGENT_NAME)) result = new AgentNameAttrLP();	
				
				if (key.equals(IContextAttributes.FT_TOP_BASE_TIME)) result = new TopBaseTimeAttrLP();
				if (key.equals(IContextAttributes.FT_TOP_CUMULATIVE_TIME)) result = new TopCumulTimeAttrLP();
				if (key.equals(IContextAttributes.FT_TOP_CALLS)) result = new TopCallsAttrLP();
				if (key.equals(IContextAttributes.FT_TOP_TOTAL_SIZE)) result = new TopTotalSizeAttrLP();
				if (key.equals(IContextAttributes.FT_TOP_COLLECTED_SIZE)) result = new TopCollectedSizeAttrLP();	
				if (key.equals(IContextAttributes.FT_TOP_TOTAL_INST)) result = new TopTotalInstAttrLP();
				if (key.equals(IContextAttributes.FT_TOP_COLLECTED_INST)) result = new TopCollectedInstAttrLP();
				
			}
			if (result!=null) {
				contextLabelFormatProviders.put(key,result);
				return (IContextLabelFormatProvider)result;
			}
		}
		
		return null;
	}

	public String getParentProvider() {
		return null;
	}

	public String getBaseProvider() {
		return null;
	}
}
