/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.views.internal.context.java.formatters;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public abstract class AttrLPAdapter implements IContextLabelFormatProvider {

	public Image getDisplayImageByElement(Object value, Object element, int mode) {
		return null;
	}

	public String getDisplayDescription() {
		return null;
	}

	public String getDisplayToolTip() {
		return null;
	}

	public String convertModelValueToDisplayString(String text) {
		return text;
	}

	public String convertDisplayStringToModelValue(String text) {
		return text;
	}
	
	private int[] supportModes = null;
	
	protected List internalSupportModes()
	{
		return new ArrayList();
	}
	
	public int[] getSupportModes()
	{
		if (supportModes == null)
		{
			List modes = internalSupportModes();
			supportModes = new int[modes.size()];
			for (int i = 0; i < supportModes.length; i++)
				supportModes[i] = ((Integer)modes.get(i)).intValue();
		}
		
		return supportModes;
	}
}
