/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.trace.views.internal.context.java.formatters;

import java.util.List;

import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;

public class CoverageMethodsPercHitAttrLP extends AttrLPAdapter {
	
	public String getDisplayStringFromElement(Object value, Object element, int mode) {
		if (mode == IContextLabelFormatProvider.MODE_COLUMN_HEADER)
			return TraceUIMessages._137;
		else if (mode == IContextLabelFormatProvider.MODE_COLUMN_CONTENT)
		{
			if (element instanceof TRCMethod)
				return "";
			else if (value instanceof Double)
				return TString.formatAsPercentage(((Double)value).doubleValue());		
		}
		
		return "";
	}	
	
	protected List internalSupportModes()
	{
		List modes = super.internalSupportModes();
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_HEADER));
		
		return modes;
	}
}
